/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.configmanager.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.configmanager.IConfigurationFileHandler;
import org.ops4j.pax.configmanager.internal.ManagedFactoryPropertiesProcessor;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigurationAdminFacade {
    private static final Log LOGGER = LogFactory.getLog(ConfigurationAdminFacade.class);
    public static final String DIRECTORY_NAME_FACTORIES = "factories";
    public static final String DIRECTORY_NAME_SERVICES = "services";
    public static final String DEFAULT_CONFIGURATION_LOCATION = "configurations";
    public static final String BUNDLES_CONFIGURATION_LOCATION = "bundles.configuration.location";
    private final List<IConfigurationFileHandler> m_handlers;
    private ConfigurationAdmin m_configAdminService;
    private final ManagedFactoryPropertiesProcessor m_processor = new ManagedFactoryPropertiesProcessor();
    private final PropertyResolver m_propertyResolver;

    public ConfigurationAdminFacade(PropertyResolver propertyResolver) {
        this.m_propertyResolver = propertyResolver;
        this.m_handlers = new ArrayList<IConfigurationFileHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addFileHandler(IConfigurationFileHandler handler) throws IllegalArgumentException {
        NullArgumentException.validateNotNull(handler, "handler");
        List<IConfigurationFileHandler> list = this.m_handlers;
        synchronized (list) {
            this.m_handlers.add(0, handler);
            if (this.m_configAdminService != null) {
                try {
                    this.registerConfigurations(null, false);
                }
                catch (IOException e) {
                    String msg = "IOException by either getting the configuration admin or loading the configuration file.";
                    LOGGER.error(msg, e);
                }
                catch (InvalidSyntaxException e) {
                    LOGGER.error("Invalid syntax. This should not happened.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerConfigurations(String configuration, boolean overwrite) throws IOException, InvalidSyntaxException, IllegalStateException {
        Configuration[] existingConfigurations;
        if (this.m_configAdminService == null) {
            throw new IllegalStateException("Configuration admin service is not available. Please start configuration admin bundle.");
        }
        File configDir = this.getConfigDir();
        if (configDir == null) {
            return;
        }
        ConfigurationAdminFacade configurationAdminFacade = this;
        synchronized (configurationAdminFacade) {
            existingConfigurations = this.m_configAdminService.listConfigurations(null);
        }
        HashSet<String> configCache = new HashSet<String>();
        if (existingConfigurations != null && !overwrite) {
            for (Configuration existingConfig : existingConfigurations) {
                configCache.add(existingConfig.getPid());
            }
        }
        this.createConfiguration(configuration, configDir, configCache, true);
        this.createConfiguration(configuration, configDir, configCache, false);
    }

    private void createConfiguration(String configuration, File configDir, Set<String> configCache, boolean isFactory) throws IOException {
        String[] files;
        File dir = isFactory ? new File(configDir, DIRECTORY_NAME_FACTORIES) : new File(configDir, DIRECTORY_NAME_SERVICES);
        if (!dir.exists()) {
            LOGGER.info("Directory [" + dir + "] does not exist.");
            return;
        }
        for (String configFileName : files = dir.list()) {
            this.createConfigurationForFile(configuration, configFileName, configCache, dir, isFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConfigurationForFile(String configuration, String configFileName, Set<String> configCache, File dir, boolean isFactory) throws IOException {
        File f = new File(dir, configFileName);
        if (!f.isDirectory()) {
            ArrayList<IConfigurationFileHandler> handlers;
            List<IConfigurationFileHandler> list = this.m_handlers;
            synchronized (list) {
                handlers = new ArrayList<IConfigurationFileHandler>(this.m_handlers);
            }
            for (IConfigurationFileHandler handler : handlers) {
                if (!handler.canHandle(f)) continue;
                String servicePid = handler.getServicePID(configFileName);
                if (configCache.contains(servicePid)) {
                    return;
                }
                if (configuration != null && !servicePid.equals(configuration)) {
                    return;
                }
                this.handle(handler, configFileName, f, isFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(IConfigurationFileHandler handler, String configFile, File file, boolean isFactory) throws IOException {
        String servicePid = handler.getServicePID(configFile);
        Properties prop = handler.handle(file);
        String str = (String)prop.get("service.pid");
        if (str != null) {
            servicePid = str;
        }
        ConfigurationAdminFacade configurationAdminFacade = this;
        synchronized (configurationAdminFacade) {
            if (isFactory) {
                this.m_processor.process(this.m_configAdminService, servicePid, prop);
            } else {
                Configuration conf = this.m_configAdminService.getConfiguration(servicePid, null);
                conf.update((Dictionary)prop);
            }
        }
        LOGGER.info("Register configuration [" + servicePid + "]");
    }

    private File getConfigDir() {
        String configArea = this.m_propertyResolver.getProperty(BUNDLES_CONFIGURATION_LOCATION);
        if (configArea == null) {
            LOGGER.info("System property [bundles.configuration.location] is not defined.");
            LOGGER.info("Using default configurations location [configurations].");
            configArea = DEFAULT_CONFIGURATION_LOCATION;
        }
        LOGGER.info("Using configuration from [" + configArea + "]");
        File dir = new File(configArea);
        if (!dir.exists()) {
            String absolutePath = dir.getAbsolutePath();
            LOGGER.error("Configuration area [" + absolutePath + "] does not exist. Unable to load properties.");
            return null;
        }
        return dir;
    }

    void dispose() {
        this.m_configAdminService = null;
        this.m_handlers.clear();
    }

    final void printConfigFileList(PrintWriter writer, String fileName) {
        String[] files;
        File configDir = this.getConfigDir();
        if (configDir == null) {
            writer.println("Configuration dir is not setup.");
            return;
        }
        if (fileName != null) {
            this.printConfiguration(writer, fileName, configDir);
            return;
        }
        String configAbsolutePath = configDir.getAbsolutePath();
        writer.println("config dir: [" + configAbsolutePath + "] contains the following config files:");
        for (String file : files = configDir.list()) {
            writer.println(file);
        }
    }

    private void printConfiguration(PrintWriter writer, String fileName, File configDir) {
        File configFile = new File(configDir, fileName);
        String absolutePath = configFile.getAbsolutePath();
        if (!configFile.canRead() || !configFile.exists()) {
            writer.println("Can't read configfile [" + absolutePath + "]");
            return;
        }
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(configFile);
            props.load(in);
        }
        catch (Exception e) {
            String message = "Can't read configfile [" + absolutePath + "] - not a correct config file";
            writer.println(message);
            return;
        }
        writer.println("Config file: [" + absolutePath + "]");
        for (Object keyObject : props.keySet()) {
            String key = (String)keyObject;
            String value = props.getProperty(key);
            writer.println(key + " = " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeFileHandler(IConfigurationFileHandler handler) throws IllegalArgumentException {
        NullArgumentException.validateNotNull(handler, "handler");
        List<IConfigurationFileHandler> list = this.m_handlers;
        synchronized (list) {
            this.m_handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setConfigurationAdminService(ConfigurationAdmin configurationAdminService) {
        ConfigurationAdminFacade configurationAdminFacade = this;
        synchronized (configurationAdminFacade) {
            this.m_configAdminService = configurationAdminService;
        }
    }

    static interface PropertyResolver {
        public String getProperty(String var1);
    }
}

