/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.binding.http;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.ResponseTypeInfo;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.service.CseService;

public class RestHttpServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(RestHttpServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String BEARER_AUTH_TYPE = "Bearer";
    private static final String BASIC_AUTH_TYPE = "Basic";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static CseService cse;
    protected String CSE_BASE_CONTEXT = "";

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String uri;
        LOGGER.info((Object)"----------------------------------------------------------------------------------------------");
        RequestPrimitive request = new RequestPrimitive();
        String targetID = uri = httpServletRequest.getRequestURI();
        if (this.CSE_BASE_CONTEXT.length() > 1 && uri.length() > this.CSE_BASE_CONTEXT.length()) {
            targetID = uri.substring(this.CSE_BASE_CONTEXT.length());
        }
        if (targetID.startsWith("/~")) {
            targetID = targetID.replaceFirst("/~/", "/");
        } else if (targetID.startsWith("/_")) {
            targetID = targetID.replaceFirst("/_/", "//");
        } else if (targetID.startsWith("/")) {
            targetID = targetID.replaceFirst("/", "");
        }
        request.setTo(targetID);
        String content = null;
        try {
            if (httpServletRequest.getInputStream().available() > 0) {
                content = Util.convertStreamToString((InputStream)httpServletRequest.getInputStream());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error reading httpServletRequest InputStream", (Throwable)e);
        }
        if (content != null && !content.isEmpty()) {
            request.setContent((Object)content);
        }
        this.mapParameters(httpServletRequest, request);
        LOGGER.info((Object)("Built RequestPrimitive: " + request.toString()));
        try {
            request.setOperation(RestHttpServlet.getOneM2MOperation(httpServletRequest));
        }
        catch (BadRequestException e) {
            httpServletResponse.setStatus(400);
            httpServletResponse.getWriter().print(e.getMessage());
            httpServletResponse.setContentType("text/plain");
            return;
        }
        this.mapHeaders(httpServletRequest, request);
        request.getQueryStrings().putAll(RestHttpServlet.getParamsFromQuery(httpServletRequest.getQueryString()));
        ResponsePrimitive response = null;
        if (cse != null) {
            response = cse.doRequest(request);
        } else {
            response = new ResponsePrimitive();
            response.setResponseStatusCode(ResponseStatusCode.SERVICE_UNAVAILABLE);
            response.setContent((Object)"CSE service is not available.");
            response.setContentType("text/plain");
        }
        if (response.getLocation() != null) {
            httpServletResponse.setHeader("Content-Location", response.getLocation());
        }
        if (response.getRequestIdentifier() != null) {
            httpServletResponse.setHeader("X-M2M-RI", response.getRequestIdentifier());
        }
        if (response.getFrom() != null) {
            httpServletResponse.setHeader("X-M2M-Origin", response.getFrom());
        }
        int httpStatus = RestHttpServlet.getHttpStatusCode(response.getResponseStatusCode());
        httpServletResponse.setStatus(httpStatus);
        httpServletResponse.setHeader("X-M2M-RSC", response.getResponseStatusCode().toString());
        if (response.getContent() != null) {
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType(response.getContentType());
            String body = (String)response.getContent();
            LOGGER.info((Object)"send UTF8");
            httpServletResponse.getOutputStream().write(body.getBytes(Charset.forName("UTF-8")));
        }
        httpServletResponse.getOutputStream().close();
    }

    private static BigInteger getOneM2MOperation(HttpServletRequest httpServletRequest) {
        BigInteger result = null;
        switch (httpServletRequest.getMethod()) {
            case "GET": {
                return Operation.RETRIEVE;
            }
            case "POST": {
                result = httpServletRequest.getHeader("Content-Type") != null && httpServletRequest.getHeader("Content-Type").contains("ty=") ? Operation.CREATE : Operation.NOTIFY;
                return result;
            }
            case "PUT": {
                return Operation.UPDATE;
            }
            case "DELETE": {
                return Operation.DELETE;
            }
        }
        throw new BadRequestException("HTTP Operation not supported: " + httpServletRequest.getMethod());
    }

    public static int getHttpStatusCode(BigInteger statusCode) {
        if (statusCode.equals(ResponseStatusCode.OK) || statusCode.equals(ResponseStatusCode.UPDATED) || statusCode.equals(ResponseStatusCode.DELETED)) {
            return 200;
        }
        if (statusCode.equals(ResponseStatusCode.CREATED)) {
            return 201;
        }
        if (statusCode.equals(ResponseStatusCode.ACCEPTED)) {
            return 202;
        }
        if (statusCode.equals(ResponseStatusCode.BAD_REQUEST) || statusCode.equals(ResponseStatusCode.CONTENTS_UNACCEPTABLE) || statusCode.equals(ResponseStatusCode.MAX_NUMBER_OF_MEMBER_EXCEEDED) || statusCode.equals(ResponseStatusCode.MEMBER_TYPE_INCONSISTENT) || statusCode.equals(ResponseStatusCode.INVALID_CMDTYPE) || statusCode.equals(ResponseStatusCode.INSUFFICIENT_ARGUMENTS) || statusCode.equals(ResponseStatusCode.ALREADY_COMPLETED) || statusCode.equals(ResponseStatusCode.COMMAND_NOT_CANCELLABLE)) {
            return 400;
        }
        if (statusCode.equals(ResponseStatusCode.ACCESS_DENIED) || statusCode.equals(ResponseStatusCode.SUBSCRIPTION_CREATOR_HAS_NO_PRIVILEGE) || statusCode.equals(ResponseStatusCode.NO_PRIVILEGE) || statusCode.equals(ResponseStatusCode.ALREADY_EXISTS) || statusCode.equals(ResponseStatusCode.TARGET_NOT_SUBSCRIBABLE) || statusCode.equals(ResponseStatusCode.SUBSCRIPTION_HOST_HAS_NO_PRIVILEGE)) {
            return 403;
        }
        if (statusCode.equals(ResponseStatusCode.NOT_FOUND) || statusCode.equals(ResponseStatusCode.TARGET_NOT_REACHABLE) || statusCode.equals(ResponseStatusCode.EXTERNAL_OBJECT_NOT_FOUND) || statusCode.equals(ResponseStatusCode.EXTERNAL_OBJECT_NOT_REACHABLE)) {
            return 404;
        }
        if (statusCode.equals(ResponseStatusCode.OPERATION_NOT_ALLOWED)) {
            return 405;
        }
        if (statusCode.equals(ResponseStatusCode.REQUEST_TIMEOUT)) {
            return 408;
        }
        if (statusCode.equals(ResponseStatusCode.CONFLICT) || statusCode.equals(ResponseStatusCode.GROUP_REQUEST_IDENTIFIER_EXISTS)) {
            return 409;
        }
        if (statusCode.equals(ResponseStatusCode.INTERNAL_SERVER_ERROR) || statusCode.equals(ResponseStatusCode.SUBSCRIPTION_VERIFICATION_INITIATION_FAILED) || statusCode.equals(ResponseStatusCode.MGMT_SESSION_CANNOT_BE_ESTABLISHED) || statusCode.equals(ResponseStatusCode.MGMT_SESSION_ESTABLISHMENT_TIMEOUT) || statusCode.equals(ResponseStatusCode.MGMT_CONVERSION_ERROR) || statusCode.equals(ResponseStatusCode.MGMT_CANCELATION_FAILURE)) {
            return 500;
        }
        if (statusCode.equals(ResponseStatusCode.NOT_IMPLEMENTED) || statusCode.equals(ResponseStatusCode.NON_BLOCKING_REQUEST_NOT_SUPPORTED)) {
            return 501;
        }
        if (statusCode.equals(ResponseStatusCode.SERVICE_UNAVAILABLE)) {
            return 503;
        }
        return 501;
    }

    public static CseService getScl() {
        return cse;
    }

    public static void setCse(CseService cse) {
        RestHttpServlet.cse = cse;
    }

    private void mapParameters(HttpServletRequest request, RequestPrimitive primitive) {
        if (request.getParameter("rt") != null) {
            if (primitive.getResponseTypeInfo() == null) {
                primitive.setResponseTypeInfo(new ResponseTypeInfo());
            }
            primitive.getResponseTypeInfo().setResponseType(new BigInteger(request.getParameter("rt")));
        }
        if (request.getParameter("rcn") != null) {
            primitive.setResultContent(new BigInteger(request.getParameter("rcn")));
        }
        if (request.getParameter("rp") != null) {
            try {
                Duration duration = DatatypeFactory.newInstance().newDuration(request.getParameter("rp"));
                primitive.setResultPersistence(duration);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.debug((Object)"Error in Duration creation", (Throwable)e);
            }
        }
        if (request.getParameter("da") != null) {
            primitive.setDeliveryAggregation(Boolean.valueOf(Boolean.parseBoolean(request.getParameter("da"))));
        }
        if (request.getParameter("drt") != null) {
            primitive.setDiscoveryResultType(new BigInteger(request.getParameter("drt")));
        }
        FilterCriteria filterCriteria = new FilterCriteria();
        primitive.setFilterCriteria(filterCriteria);
        if (request.getParameter("lvl") != null) {
            filterCriteria.setLevel(new BigInteger(request.getParameter("lvl")));
        }
        if (request.getParameter("ofst") != null) {
            filterCriteria.setOffset(new BigInteger(request.getParameter("ofst")));
        }
        if (request.getParameter("fu") != null) {
            filterCriteria.setFilterUsage(new BigInteger(request.getParameter("fu")));
        }
        if (request.getParameter("lim") != null) {
            filterCriteria.setLimit(new BigInteger(request.getParameter("lim")));
        }
        if (request.getParameter("lbl") != null) {
            filterCriteria.getLabels().addAll(Arrays.asList(request.getParameterValues("lbl")));
        }
        if (request.getParameter("ty") != null) {
            filterCriteria.setResourceType(new BigInteger(request.getParameter("ty")));
        }
    }

    private void mapHeaders(HttpServletRequest httpServletRequest, RequestPrimitive request) {
        String rtuHeader;
        block43: {
            block41: {
                int n;
                String contentFormat;
                block40: {
                    block38: {
                        String contentTypeHeaders;
                        contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
                        String originator = httpServletRequest.getHeader("X-M2M-Origin");
                        if (originator != null) {
                            request.setFrom(originator);
                        }
                        this.parseAuthorizationHeader(request, httpServletRequest.getHeader(AUTHORIZATION_HEADER));
                        String requestIdentifier = httpServletRequest.getHeader("X-M2M-RI");
                        if (requestIdentifier != null) {
                            request.setRequestIdentifier(requestIdentifier.trim());
                        }
                        if ((contentTypeHeaders = httpServletRequest.getHeader("Content-Type")) == null) break block38;
                        LOGGER.info((Object)("Content type headers: " + contentTypeHeaders));
                        String[] stringArray = contentTypeHeaders.split(";");
                        n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String contentTypeHeader = stringArray[n2];
                            LOGGER.info((Object)("Header value: " + contentTypeHeader));
                            if (contentTypeHeader.trim().startsWith("ty=")) {
                                String resourceType = contentTypeHeader.trim().split("ty=")[1];
                                request.setResourceType(new BigInteger(resourceType));
                            }
                            switch (contentTypeHeader.trim()) {
                                case "application/vnd.onem2m-res+xml": 
                                case "application/xml": {
                                    request.setRequestContentType("application/xml");
                                    break;
                                }
                                case "application/vnd.onem2m-res+json": 
                                case "application/json": {
                                    request.setRequestContentType("application/json");
                                    break;
                                }
                            }
                            ++n2;
                        }
                        break block40;
                    }
                    request.setRequestContentType(contentFormat);
                }
                if (request.getRequestContentType() == null) {
                    request.setRequestContentType(contentFormat);
                }
                String acceptHeaders = httpServletRequest.getHeader("Accept");
                LOGGER.info((Object)("Accept header: " + acceptHeaders));
                if (acceptHeaders == null) break block41;
                Object object = acceptHeaders.split(";");
                int n3 = ((String[])object).length;
                n = 0;
                while (n < n3) {
                    String acceptHeader = object[n];
                    switch (acceptHeader.trim()) {
                        case "application/vnd.onem2m-res+xml": 
                        case "application/xml": {
                            request.setReturnContentType("application/xml");
                            break;
                        }
                        case "application/vnd.onem2m-res+json": 
                        case "application/json": {
                            request.setReturnContentType("application/json");
                            break;
                        }
                    }
                    ++n;
                }
                break block43;
            }
            request.setReturnContentType(request.getRequestContentType());
        }
        if (request.getReturnContentType() == null) {
            request.setReturnContentType(request.getRequestContentType());
        }
        if ((rtuHeader = httpServletRequest.getHeader("X-M2M-RTU")) != null) {
            LOGGER.info((Object)("Response Type URI header: " + rtuHeader));
            if (request.getResponseTypeInfo() == null) {
                request.setResponseTypeInfo(new ResponseTypeInfo());
            }
            String[] stringArray = rtuHeader.split("&");
            int n = stringArray.length;
            int n4 = 0;
            while (n4 < n) {
                String notifUri = stringArray[n4];
                request.getResponseTypeInfo().getNotificationURI().add(notifUri.trim());
                ++n4;
            }
        }
    }

    private void parseAuthorizationHeader(RequestPrimitive request, String authorizationHeader) {
        LOGGER.info((Object)("parseAuthorizationHeader(authorizationHeader:" + authorizationHeader + ")"));
        if (authorizationHeader == null || authorizationHeader.isEmpty()) {
            return;
        }
        if (authorizationHeader.startsWith(BASIC_AUTH_TYPE)) {
            LOGGER.debug((Object)"request with basic http auth");
            String base64UsernameAndPassword = authorizationHeader.substring(BASIC_AUTH_TYPE.length() + 1).trim();
            String usernameAndPassword = new String(Base64.getDecoder().decode(base64UsernameAndPassword));
            request.setFrom(usernameAndPassword);
        }
        if (authorizationHeader.startsWith(BEARER_AUTH_TYPE)) {
            String accessToken = authorizationHeader.substring(BEARER_AUTH_TYPE.length() + 1);
            request.getTokens().add(accessToken);
        }
    }

    public static String httpRequestToString(HttpServletRequest request, String content) {
        String heads = "{\n";
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            heads = String.valueOf(heads) + "\t" + headerName + ": ";
            Enumeration headers = request.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                heads = String.valueOf(heads) + headerValue + "\n";
            }
        }
        heads = String.valueOf(heads) + "}";
        return "HttpRequest [method=" + request.getMethod() + ", URI=" + request.getRequestURI() + ", representation=" + content + ", queryString=" + request.getQueryString() + ", headers :\n" + heads + "]";
    }

    public static String httpResponseToString(int statusCode, String errorMessage) {
        return "HttpResponse [statusCode=" + statusCode + ", errorMessage=" + errorMessage + "]";
    }

    public static Map<String, List<String>> getParamsFromQuery(String query) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (query != null) {
            String[] pairs;
            String[] stringArray = pairs = query.split("[&]");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = param[0];
                }
                if (param.length > 1) {
                    value = param[1];
                }
                if (parameters.containsKey(key)) {
                    ((List)parameters.get(key)).add(value);
                } else {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    parameters.put(key, values);
                }
                ++n2;
            }
        }
        return parameters;
    }
}

