/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.Switch;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.modules.PushButton;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedSwitch
extends Switch
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;
    private boolean running;
    private PushButton pushButton;
    private boolean pushed;

    public MockedSwitch(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.pushButton = new PushButton("pushButton_" + id, domain, new BooleanDataPoint((Identifiers)DatapointType.pushed){

            public Boolean doGetValue() throws DataPointException {
                return MockedSwitch.this.pushed;
            }
        });
        this.addModule(this.pushButton);
    }

    @Override
    public void registerDevice() {
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
        this.running = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("start thread " + MockedSwitch.this.pushButton);
                while (MockedSwitch.this.running) {
                    try {
                        Thread.sleep((int)(30000.0 + 5000.0 * Math.random()));
                        System.out.println("Generating Push Button event");
                        Event evt = new Event("PUSH");
                        MockedSwitch.this.pushed = !MockedSwitch.this.pushed;
                        evt.setValue((Object)MockedSwitch.this.pushed);
                        evt.addDataPoint(MockedSwitch.this.pushButton.getDataPointByShortName(DatapointType.pushed.getShortName()));
                        MockedSwitch.this.pushButton.addEvent(evt);
                    }
                    catch (Throwable e) {
                        System.out.println("Error generating event");
                        e.printStackTrace();
                        MockedSwitch.this.running = false;
                    }
                }
                System.out.println("stopped thread");
            }
        }).start();
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

