/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.TemperatureDetector;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedTemperature;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedThermometer
extends TemperatureDetector
implements MockedDevice {
    private static final int MIN = 15;
    private static final int MAX = 35;
    private List<ServiceRegistration> serviceRegistrations;
    private float temp;
    private Temperature temperature;
    private boolean running;
    private int delta;

    public MockedThermometer(String id, String serial, Domain domain, boolean b) {
        super(id, serial, domain);
        this.temperature = new MockedTemperature("temperature_" + id, domain, b, new FloatDataPoint((Identifiers)DatapointType.currentTemperature){

            public Float doGetValue() throws DataPointException {
                return Float.valueOf(MockedThermometer.this.temp);
            }
        });
        this.addModule(this.temperature);
    }

    @Override
    public void registerDevice() {
        this.running = true;
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }

    private class ThermoThread
    extends Thread {
        private ThermoThread() {
        }

        @Override
        public void run() {
            while (MockedThermometer.this.running) {
                try {
                    ThermoThread.sleep(20000L);
                    MockedThermometer mockedThermometer = MockedThermometer.this;
                    mockedThermometer.temp = mockedThermometer.temp + (float)MockedThermometer.this.delta;
                    if (MockedThermometer.this.temp <= 15.0f || MockedThermometer.this.temp >= 35.0f) {
                        MockedThermometer.this.delta = -MockedThermometer.this.delta;
                    }
                    Event evt = new Event("ALARM");
                    evt.addDataPoint(MockedThermometer.this.temperature.getDataPoint("currentTemperature"));
                    evt.setValue((Object)Float.valueOf(MockedThermometer.this.temp));
                    MockedThermometer.this.temperature.addEvent(evt);
                }
                catch (InterruptedException interruptedException) {
                    MockedThermometer.this.running = false;
                }
            }
        }
    }
}

