/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.dal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.MimeMediaType;
import org.eclipse.om2m.commons.obix.Obj;
import org.eclipse.om2m.commons.obix.Str;
import org.eclipse.om2m.commons.obix.io.ObixEncoder;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.ipe.dal.InterworkingServiceImpl;
import org.osgi.service.dal.FunctionData;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FunctionEventHandler
implements EventHandler {
    private static Log LOGGER = LogFactory.getLog(FunctionEventHandler.class);
    private static final String FUNCTION_PROPERTY_VALUE = "dal.function.property.value";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String funcUid = "";
    private String funcResourceId = "";

    public FunctionEventHandler(String funcUid, String funcResourceId) {
        this.funcUid = funcUid;
        this.funcResourceId = funcResourceId;
    }

    public void handleEvent(Event event) {
        LOGGER.info((Object)String.format("Recv Func Event %s (%s) (%s)", event.getTopic(), this.funcUid, event.getProperty("dal.function.UID")));
        ContentInstance cin = new ContentInstance();
        FunctionData data = (FunctionData)event.getProperty(FUNCTION_PROPERTY_VALUE);
        Obj obj = new Obj();
        obj.add((Object)new Str("DateTime", dateFormat.format(new Date(data.getTimestamp()))));
        obj.add((Object)new Str("Class", data.getClass().getName()));
        String[] propertyNames = event.getPropertyNames();
        if (propertyNames != null) {
            String[] stringArray = propertyNames;
            int n = propertyNames.length;
            int n2 = 0;
            while (n2 < n) {
                String properName = stringArray[n2];
                obj.add((Object)new Str(properName, event.getProperty(properName).toString()));
                ++n2;
            }
        }
        obj.add((Object)new Str("Event", data.toString()));
        cin.setContent(ObixEncoder.toString((Obj)obj));
        cin.setContentInfo("application/obix:" + MimeMediaType.ENCOD_PLAIN);
        InterworkingServiceImpl.createResource(this.funcResourceId, (Resource)cin, 4);
    }
}

