/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.driver.Logger;
import org.eclipse.om2m.sdt.home.driver.PersistedDevice;
import org.eclipse.om2m.sdt.home.modules.GenericSensor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;

public class Utils {
    public static final String SERVICE_PID = "service.pid";
    public static final String SERVICE_ID = "service.id";
    public static final String OBJECTCLASS = "objectClass";
    public static final String DEVICE_DESCRIPTION = "DEVICE_DESCRIPTION";
    public static final String DEVICE_SERIAL = "DEVICE_SERIAL";
    public static final String DEVICE_CATEGORY = "DEVICE_CATEGORY";
    public static final String DEVICE_MANUFACTURER = "DEVICE_MANUFACTURER";
    public static final String DEVICE_PRODUCT_CLASS = "DEVICE_PRODUCT_CLASS";
    public static final String DEVICE_FRIENDLY_NAME = "DEVICE_FRIENDLY_NAME";
    private static final String HOME_DEVS_PKG = GenericDevice.class.getPackage().getName();
    private static final String HOME_MODS_PKG = GenericSensor.class.getPackage().getName();
    private static final String SDT = "SDT";
    private static final String SDT_ID = "SDT_ID";
    private static final String DEVICE = "Device";
    private static final String MODULE = "Module";
    private static ConfigurationAdmin cfgAdmin;

    public static List<ServiceRegistration> register(GenericDevice device, BundleContext context) {
        String protocol = device.getProtocol();
        if (protocol == null) {
            protocol = "Unknown";
        }
        Logger log = new Logger(protocol);
        if (Utils.isEmpty(device.getDeviceAliasName())) {
            device.setDeviceAliasName(String.valueOf(device.getDeviceType().getLongName().substring(6)) + " #" + device.getSerialNumber().substring(device.getSerialNumber().length() - 5));
        }
        ArrayList<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
        regs.add(context.registerService(Utils.getSDTNames((Device)device), (Object)device, Utils.getProperties((Element)device, protocol, log)));
        for (Module module : device.getModules()) {
            regs.add(context.registerService(Utils.getSDTNames(module), (Object)module, Utils.getProperties((Element)module, protocol, log)));
        }
        if (Utils.getConfigurationAdmin(context) != null) {
            try {
                PersistedDevice pDev = new PersistedDevice(device);
                Configuration cfg = cfgAdmin.getConfiguration(device.getPid());
                Hashtable<String, String> props = cfg.getProperties();
                if (props != null) {
                    log.info("Already persisted device: " + props);
                    pDev.updateDevice(props);
                } else {
                    log.info("Unpersisted device: " + device);
                    props = new Hashtable<String, String>();
                    for (Property prop : device.getProperties()) {
                        if (prop.getValue() == null) continue;
                        ((Dictionary)props).put(prop.getName(), prop.getValue());
                    }
                    ((Dictionary)props).put(SERVICE_PID, "P_" + device.getPid());
                    log.info("persist: " + props);
                    pDev.setRegistration(context.registerService(ManagedService.class.getName(), (Object)pDev, props));
                    cfg.update(props);
                }
            }
            catch (Exception e) {
                log.warning("", e);
            }
        }
        return regs;
    }

    public static void setProperties(ServiceReference ref, GenericDevice device) {
        String name = null;
        String manuf = null;
        String[] stringArray = ref.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object val;
            String prop = stringArray[n2];
            if (!(prop.equalsIgnoreCase(SERVICE_PID) || prop.equalsIgnoreCase(SERVICE_ID) || prop.equalsIgnoreCase(DEVICE_CATEGORY) || prop.equalsIgnoreCase(OBJECTCLASS) || (val = ref.getProperty(prop)) == null || val.toString().isEmpty())) {
                if (prop.equals(DEVICE_DESCRIPTION)) {
                    device.setDeviceAliasName(val.toString());
                } else if (prop.equals(DEVICE_MANUFACTURER)) {
                    manuf = val.toString();
                } else if (prop.equals(DEVICE_PRODUCT_CLASS)) {
                    device.setDeviceModelName(val.toString());
                } else if (prop.equals(DEVICE_FRIENDLY_NAME)) {
                    name = val.toString();
                }
            }
            ++n2;
        }
        device.setDeviceManufacturer(manuf != null ? manuf : "Unknown");
        device.setDeviceName(name != null ? name : device.getSerialNumber());
    }

    public static final boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private static final boolean isEmpty(String s1) {
        return s1 == null || s1.isEmpty();
    }

    private static final String[] getSDTNames(Device elt) {
        Class<?> clazz = elt.getClass();
        while (!clazz.getPackage().getName().equals(HOME_DEVS_PKG)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return new String[]{Device.class.getName()};
        }
        return new String[]{clazz.getName(), Device.class.getName()};
    }

    private static final String[] getSDTNames(Module elt) {
        Class<?> clazz = elt.getClass();
        while (!clazz.getPackage().getName().equals(HOME_MODS_PKG)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return new String[]{Module.class.getName()};
        }
        return new String[]{clazz.getName(), Module.class.getName()};
    }

    private static Dictionary<String, Object> getProperties(Element elt, String protocol, Logger log) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ArrayList<String> categories = new ArrayList<String>();
        categories.add(SDT);
        categories.add(elt instanceof Device ? DEVICE : MODULE);
        if (protocol != null && !protocol.isEmpty()) {
            categories.add(protocol);
        }
        ((Dictionary)props).put(DEVICE_CATEGORY, categories.toArray(new String[0]));
        Collection sdtProps = null;
        if (elt instanceof Device) {
            ((Dictionary)props).put(SDT_ID, elt.getName());
            ((Dictionary)props).put(SERVICE_PID, ((Device)elt).getPid());
            String desc = null;
            try {
                desc = ((GenericDevice)elt).getDeviceModelName();
                if (desc == null) {
                    desc = ((GenericDevice)elt).getDeviceAliasName();
                }
                if (desc == null) {
                    desc = ((GenericDevice)elt).getDeviceName();
                }
            }
            catch (Exception exception) {}
            if (desc == null) {
                desc = ((GenericDevice)elt).getSerialNumber();
            }
            ((Dictionary)props).put(DEVICE_DESCRIPTION, desc);
            sdtProps = ((Device)elt).getProperties();
        } else if (elt instanceof Module) {
            ((Dictionary)props).put(SERVICE_PID, ((Module)elt).getPid());
            sdtProps = ((Module)elt).getProperties();
        }
        for (Property prop : sdtProps) {
            if (prop.getValue() == null) continue;
            ((Dictionary)props).put(prop.getName(), prop.getValue());
        }
        log.info("Properties: " + props);
        return props;
    }

    private static final ConfigurationAdmin getConfigurationAdmin(BundleContext bc) {
        ServiceReference configAdminServiceReference;
        if (cfgAdmin == null && (configAdminServiceReference = bc.getServiceReference(ConfigurationAdmin.class.getName())) != null) {
            cfgAdmin = (ConfigurationAdmin)bc.getService(configAdminServiceReference);
        }
        return cfgAdmin;
    }
}

