/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.subscription;

import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.NotificationQueue;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.ReceivedNotification;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.events.SDTEventListener;
import org.eclipse.om2m.sdt.events.SDTNotification;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SubscriptionSDTListener
implements SDTEventListener {
    private final NotificationQueue notificationQueue;
    private final BundleContext bundleContext;
    private final Module module;
    private boolean storeNotification = false;
    private ServiceRegistration serviceRegistration;

    public SubscriptionSDTListener(NotificationQueue pNotificationQueue, BundleContext pBundleContext, Module pModule) {
        this.notificationQueue = pNotificationQueue;
        this.bundleContext = pBundleContext;
        this.module = pModule;
    }

    protected void register() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("sdt.modules.names", this.module.getName());
        ((Dictionary)properties).put("sdt.domains.ids", "*");
        ((Dictionary)properties).put("sdt.devices.ids", this.module.getOwner().getId());
        ((Dictionary)properties).put("sdt.datapoints.names", "*");
        ((Dictionary)properties).put("sdt.devices.definitions", "*");
        ((Dictionary)properties).put("sdt.modules.definitions", "*");
        this.serviceRegistration = this.bundleContext.registerService(SDTEventListener.class.getName(), (Object)this, properties);
    }

    protected void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    protected void storeNotification() {
        this.storeNotification = true;
    }

    public void handleNotification(SDTNotification notif) {
        Date currentDate = new Date();
        DataPoint dataPoint = notif.getDataPoint();
        Object value = notif.getValue();
        ReceivedNotification receivedNotification = new ReceivedNotification(dataPoint, value, currentDate);
        if (this.storeNotification) {
            this.notificationQueue.addNotificationFromSDT(receivedNotification);
        }
    }

    public void setAuthenticationThreadGroup(ThreadGroup group) {
    }
}

