/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.eclipse.om2m.sdt.home.netatmo.impl.Activator;
import org.eclipse.om2m.sdt.home.netatmo.model.Event;
import org.eclipse.om2m.sdt.home.netatmo.model.Home;
import org.eclipse.om2m.sdt.home.netatmo.model.Person;
import org.eclipse.om2m.sdt.home.netatmo.model.Token;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStation;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStationModule;
import org.eclipse.om2m.sdt.home.netatmo.model.WelcomeCamera;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Server {
    private static final String CLIENT_ID_NAME = "client_id";
    private static final String CLIENT_SECRET_NAME = "client_secret";
    private static final String GRANT_TYPE_NAME = "grant_type";
    private static final String USERNAME_NAME = "username";
    private static final String PASSWORD_NAME = "password";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String SCOPE_NAME = "scope";
    private static final String HOME_ID = "home_id";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRE_IN = "expire_in";
    private static final String SIZE = "size";
    private static final String BODY = "body";
    private static final String DEVICES = "devices";
    private static final String HOMES = "homes";
    private static final String ON = "on";
    private static final String GRANT_TYPE_VALUE = "password";
    private static final String GRANT_TYPE_REFRESH = "refresh_token";
    private static final String NETATMO_CLOUD_BASE_URL = "https://api.netatmo.com";
    private static final String OAUTH_TOKEN_URL = "/oauth2/token";
    private static final String GET_HOME_DATA = "/api/gethomedata";
    private static final String GET_STATIONS_DATA = "/api/getstationsdata";
    private final String clientId;
    private final String clientSecret;
    private final String grantType;
    private final String username;
    private final String password;
    private Token token;

    public Server(String pClientId, String pClientSecret, String pUsername, String pPassword) {
        this.clientId = pClientId;
        this.clientSecret = pClientSecret;
        this.username = pUsername;
        this.password = pPassword;
        this.grantType = "password";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Token getToken() {
        Server server = this;
        synchronized (server) {
            if (this.token == null) {
                this.token = this.authenticate();
            } else if (!this.token.isValid()) {
                this.token = this.refreshToken(this.token);
            }
        }
        return this.token;
    }

    public List<WeatherStation> getStationsData() {
        ArrayList<WeatherStation> wss = new ArrayList<WeatherStation>();
        Token currentToken = this.getToken();
        if (currentToken == null) {
            Activator.logger.info("current token is null", Server.class);
            return wss;
        }
        try {
            Response resp = this.post("access_token=" + currentToken.getAccessToken(), "https://api.netatmo.com/api/getstationsdata");
            if (resp.code == 200) {
                JSONObject body = (JSONObject)resp.json.get((Object)BODY);
                for (Object deviceObject : (JSONArray)body.get((Object)DEVICES)) {
                    JSONObject device = (JSONObject)deviceObject;
                    WeatherStation ws = (WeatherStation)this.retrieveWeatherStationData(device);
                    JSONArray modules = (JSONArray)device.get((Object)"modules");
                    for (Object module : modules) {
                        ws.addOrUpdateModule(this.retrieveWeatherStationData((JSONObject)module));
                    }
                    wss.add(ws);
                }
            } else {
                Activator.logger.info("bad getstationsdata (code=" + resp.code + ", message=" + resp.message + ")", Server.class);
                if (resp.code == 403) {
                    currentToken.invalidateToken();
                }
            }
        }
        catch (IOException e) {
            Activator.logger.warning("unable to open connection", Server.class, (Throwable)e);
        }
        return wss;
    }

    private WeatherStationModule retrieveWeatherStationData(JSONObject deviceJsonObject) {
        String id = (String)deviceJsonObject.get((Object)"_id");
        String name = (String)deviceJsonObject.get((Object)"module_name");
        WeatherStation ws = new WeatherStation(id, name);
        JSONObject dashboardData = (JSONObject)deviceJsonObject.get((Object)"dashboard_data");
        JSONArray dataTypesJsonArray = (JSONArray)deviceJsonObject.get((Object)"data_type");
        for (Object dataTypeObject : dataTypesJsonArray) {
            ws.addDataType((String)dataTypeObject);
        }
        List<String> dataTypes = ws.getDataTypes();
        if (dataTypes.contains("Pressure")) {
            ws.setAbsolutePressure(Server.getDoubleValue(dashboardData.get((Object)"AbsolutePressure")));
            ws.setPressure(Server.getDoubleValue(dashboardData.get((Object)"Pressure")));
        }
        if (dataTypes.contains("Temperature")) {
            ws.setCurrentTemperature(Server.getDoubleValue(dashboardData.get((Object)"Temperature")));
            ws.setTemperatureTrend((String)dashboardData.get(WeatherStation.TEMPERATURE_TREND));
            ws.setMinTemperature(Server.getDoubleValue(dashboardData.get((Object)"min_temp")));
            ws.setMaxTemperature(Server.getDoubleValue(dashboardData.get((Object)"max_temp")));
        }
        if (dataTypes.contains("Humidity")) {
            ws.setHumidity((Long)dashboardData.get((Object)"Humidity"));
        }
        if (dataTypes.contains("CO2")) {
            ws.setCo2((Long)dashboardData.get((Object)"CO2"));
        }
        if (dataTypes.contains("Noise")) {
            ws.setNoise((Long)dashboardData.get((Object)"Noise"));
        }
        ws.setDate((Long)dashboardData.get((Object)"time_utc"));
        return ws;
    }

    public List<Home> getHomeData(String homeId, Long eventSize) {
        Token currentToken = this.getToken();
        ArrayList<Home> homes = new ArrayList<Home>();
        if (currentToken == null) {
            Activator.logger.info("current token is null");
            return homes;
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(ACCESS_TOKEN).append("=").append(currentToken.getAccessToken());
            if (homeId != null) {
                sb.append("&").append(HOME_ID).append("=").append(homeId);
            }
            if (eventSize != null) {
                sb.append("&").append(SIZE).append("=").append(eventSize);
            }
            Response resp = this.post(sb.toString(), "https://api.netatmo.com/api/gethomedata");
            if (resp.code != 200) {
                Activator.logger.info("bad gethomedata (code=" + resp.code + ", message=" + resp.message + ")", Server.class);
                if (resp.code == 403) {
                    currentToken.invalidateToken();
                }
                return homes;
            }
            JSONObject body = (JSONObject)resp.json.get((Object)BODY);
            JSONArray homesJson = (JSONArray)body.get((Object)HOMES);
            if (homesJson == null || homesJson.isEmpty()) {
                Activator.logger.info("no homes !!!!", Server.class);
                return homes;
            }
            for (Object homeObject : homesJson) {
                JSONObject jsHome = (JSONObject)homeObject;
                Home home = new Home((String)jsHome.get((Object)"id"), (String)jsHome.get((Object)"name"));
                homes.add(home);
                JSONArray personsJsonArray = (JSONArray)jsHome.get((Object)"persons");
                if (personsJsonArray == null || personsJsonArray.isEmpty()) {
                    Activator.logger.info("no persons into " + home, Server.class);
                } else {
                    for (Object personObject : personsJsonArray) {
                        JSONObject jsPerson = (JSONObject)personObject;
                        Person person = new Person((String)jsPerson.get((Object)"id"), (String)jsPerson.get((Object)"pseudo"));
                        person.setLastSeen((Long)jsPerson.get((Object)"last_seen"));
                        person.setOutOfSight((Boolean)jsPerson.get((Object)"out_of_sight"));
                        home.addOrUpdatePerson(person);
                    }
                }
                JSONArray camerasJsonArray = (JSONArray)jsHome.get((Object)"cameras");
                if (camerasJsonArray == null || camerasJsonArray.isEmpty()) {
                    Activator.logger.info("no cameras into " + home, Server.class);
                } else {
                    for (Object cameraObject : camerasJsonArray) {
                        JSONObject jsCam = (JSONObject)cameraObject;
                        WelcomeCamera camera = new WelcomeCamera((String)jsCam.get((Object)"id"), (String)jsCam.get((Object)"type"), (String)jsCam.get((Object)"name"));
                        camera.setAlimOk(ON.equals((String)jsCam.get((Object)"alim_status")));
                        camera.setIsOn(ON.equals((String)jsCam.get((Object)"status")));
                        camera.setSdOk(ON.equals((String)jsCam.get((Object)"sd_status")));
                        camera.setVpnUrl((String)jsCam.get((Object)"vpn_url"));
                        home.addOrUpdateCamera(camera);
                    }
                }
                ArrayList<Event> events = new ArrayList<Event>();
                JSONArray eventsJsonArray = (JSONArray)jsHome.get((Object)"events");
                if (eventsJsonArray == null || eventsJsonArray.isEmpty()) {
                    Activator.logger.info("no events into " + home, Server.class);
                } else {
                    for (Object eventObject : eventsJsonArray) {
                        JSONObject jsEvent = (JSONObject)eventObject;
                        Event event = new Event((String)jsEvent.get((Object)"id"), (String)jsEvent.get((Object)"type"), (Long)jsEvent.get((Object)"time"), (String)jsEvent.get((Object)"camera_id"), (String)jsEvent.get((Object)"person_id"));
                        events.add(event);
                    }
                }
                home.setEvents(events);
            }
        }
        catch (IOException e) {
            Activator.logger.warning("unable to open connection", Server.class, (Throwable)e);
        }
        return homes;
    }

    private Token authenticate() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(CLIENT_ID_NAME).append("=").append(this.clientId);
            sb.append("&").append(CLIENT_SECRET_NAME).append("=").append(this.clientSecret);
            sb.append("&").append(GRANT_TYPE_NAME).append("=").append(this.grantType);
            sb.append("&").append(USERNAME_NAME).append("=").append(this.username);
            sb.append("&").append("password").append("=").append(this.password);
            sb.append("&").append(SCOPE_NAME).append("=").append("read_camera+access_camera+read_station");
            Response resp = this.post(sb.toString(), "https://api.netatmo.com/oauth2/token");
            if (resp.code == 200) {
                Token token = new Token((String)resp.json.get((Object)ACCESS_TOKEN), (String)resp.json.get((Object)"refresh_token"), (Long)resp.json.get((Object)EXPIRE_IN));
                Activator.logger.info("received token=" + token.toString());
                return token;
            }
            Activator.logger.info("bad auth (code=" + resp.code + ", message=" + resp.message + ")", Server.class);
        }
        catch (IOException e) {
            Activator.logger.warning("unable to open connection: " + e.getMessage(), Server.class);
        }
        return null;
    }

    private Token refreshToken(Token toBeRefreshed) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(CLIENT_ID_NAME).append("=").append(this.clientId);
            sb.append("&").append(CLIENT_SECRET_NAME).append("=").append(this.clientSecret);
            sb.append("&").append(GRANT_TYPE_NAME).append("=").append("refresh_token");
            sb.append("&").append("refresh_token").append("=").append(this.token.getRefreshToken());
            Response resp = this.post(sb.toString(), "https://api.netatmo.com/oauth2/token");
            if (resp.code == 200) {
                Token token = new Token((String)resp.json.get((Object)ACCESS_TOKEN), (String)resp.json.get((Object)"refresh_token"), (Long)resp.json.get((Object)EXPIRE_IN));
                Activator.logger.info("received token=" + token.toString());
                return token;
            }
            Activator.logger.info("bad auth (code=" + resp.code + ", message=" + resp.message + ")", Server.class);
        }
        catch (IOException e) {
            Activator.logger.warning("unable to open connection", Server.class, (Throwable)e);
        }
        return null;
    }

    private static final Double getDoubleValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        return object instanceof Double ? (Double)object : null;
    }

    private Response post(String data, String url) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        connection.getOutputStream().write(data.getBytes());
        connection.connect();
        Response resp = new Response();
        resp.code = connection.getResponseCode();
        if (resp.code == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            try {
                resp.json = (JSONObject)new JSONParser().parse((Reader)br);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        } else {
            resp.message = connection.getResponseMessage();
        }
        connection.disconnect();
        return resp;
    }

    static class Response {
        int code;
        JSONObject json;
        String message;

        Response() {
        }
    }
}

