/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStationModule;

public class WeatherStation
extends WeatherStationModule {
    public static final String MODULES = "modules";
    private final Map<String, WeatherStationModule> modules = new HashMap<String, WeatherStationModule>();

    public WeatherStation(String id, String name) {
        super(id, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateModule(WeatherStationModule module) {
        Map<String, WeatherStationModule> map = this.modules;
        synchronized (map) {
            WeatherStationModule existingModule = this.modules.get(module.getId());
            if (existingModule != null) {
                existingModule.updateData(module);
            } else {
                this.modules.put(module.getId(), module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WeatherStationModule> getModules() {
        HashMap<String, WeatherStationModule> toBeReturned = new HashMap<String, WeatherStationModule>();
        Map<String, WeatherStationModule> map = this.modules;
        synchronized (map) {
            toBeReturned.putAll(this.modules);
        }
        return toBeReturned;
    }

    @Override
    public String toString() {
        String ret = "WeatherStation(mainModule=" + super.toString() + ", modules=[\"";
        boolean first = true;
        for (WeatherStationModule module : this.getModules().values()) {
            if (first) {
                first = false;
            } else {
                ret = String.valueOf(ret) + ", ";
            }
            ret = String.valueOf(ret) + module;
        }
        return String.valueOf(ret) + "])";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WeatherStation)) {
            return false;
        }
        WeatherStation other = (WeatherStation)obj;
        return other.getId().equals(this.getId());
    }
}

