/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Element;

public class Event
extends Element {
    private boolean optional = false;
    private long timestamp;
    private Map<String, DataPoint> dataPoints = new HashMap<String, DataPoint>();
    private Object value;

    public Event(String name) {
        super(name);
    }

    void setTimeStamp() {
        this.timestamp = System.currentTimeMillis();
    }

    public Date getTimeStamp() {
        return new Date(this.timestamp);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Collection<String> getDataPointNames() {
        return this.dataPoints.keySet();
    }

    public Collection<DataPoint> getDataPoints() {
        return this.dataPoints.values();
    }

    public DataPoint getDataPoint(String name) {
        return this.dataPoints.get(name);
    }

    public void addDataPoint(DataPoint dataPoint) {
        if (this.dataPoints.get(dataPoint.getName()) != null) {
            throw new IllegalArgumentException();
        }
        this.dataPoints.put(dataPoint.getName(), dataPoint);
    }

    public void removeDataPoint(String name) {
        this.dataPoints.remove(name);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    protected String prettyPrint(String t1) {
        String t2 = String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer(t1).append("<Event name=\"").append(this.getName()).append("\" timestamp=\"").append(this.getTimeStamp()).append("\">");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        this.prettyPrint(ret, this.dataPoints.values(), "Data", t2);
        return ret.append("\n").append(t1).append("</Event>").toString();
    }
}

