/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AlarmSpeakerModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.BinarySwitchModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.ColourModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.ColourSaturationModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.FaultDetectionModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.RunModeModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.SmokeSensorModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.WaterLevelModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.WaterSensorModuleTest;
import org.eclipse.om2m.sdt.Module;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SDTModuleTestSuite {
    private final BundleContext bundleContext;
    private final CseService cseService;
    private final ServiceTracker sdtModuleServiceTracker;
    private final List<TestReport> testReports = new ArrayList<TestReport>();

    public SDTModuleTestSuite(BundleContext pBundleContext, CseService pCseService) {
        this.bundleContext = pBundleContext;
        this.cseService = pCseService;
        this.sdtModuleServiceTracker = new ServiceTracker(this.bundleContext, Module.class.getName(), new ServiceTrackerCustomizer(){

            public void removedService(ServiceReference reference, Object service) {
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public Object addingService(ServiceReference reference) {
                Module module = (Module)SDTModuleTestSuite.this.bundleContext.getService(reference);
                SDTModuleTestSuite.this.launchModuleTest(module);
                return null;
            }
        });
        this.sdtModuleServiceTracker.open();
    }

    private void launchModuleTest(Module module) {
        String moduleDefinition = module.getDefinition();
        AbstractModuleTest amt = null;
        switch (moduleDefinition) {
            case "org.onem2m.home.moduleclass.binarySwitch": {
                amt = new BinarySwitchModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.smokeSensor": {
                amt = new SmokeSensorModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.colourSaturation": {
                amt = new ColourSaturationModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.colour": {
                amt = new ColourModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.faultDetection": {
                amt = new FaultDetectionModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.waterSensor": {
                amt = new WaterSensorModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.runMode": {
                amt = new RunModeModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.alarmSpeaker": {
                amt = new AlarmSpeakerModuleTest(this.cseService, module);
                break;
            }
            case "org.onem2m.home.moduleclass.waterLevel": {
                amt = new WaterLevelModuleTest(this.cseService, module);
                break;
            }
        }
        if (amt == null) {
            return;
        }
        List<TestReport> tests = amt.launchTests();
        this.testReports.addAll(tests);
        System.out.println("\n");
        System.out.println("\n");
        System.out.println("------------------------------------------------------------");
        for (TestReport tr : this.testReports) {
            System.out.println(tr.toString());
            Exception e = tr.getException();
            if (e == null) continue;
            e.printStackTrace();
        }
        System.out.println("------------------------------------------------------------");
        System.out.println("\n");
        System.out.println("\n");
    }
}

