/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.subscription;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.NotificationContentType;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.resource.URIList;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.datamapping.service.DataMapperService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.NotificationQueue;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.ReceivedNotification;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.SubscriptionHttpServlet;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.SubscriptionSDTListener;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Module;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class SubscriptionTestSuite
extends HttpServlet {
    private static final String SERVLET_PATH = "/notification";
    private final BundleContext bundleContext;
    private final CseService cseService;
    private final HttpService httpService;
    private final DataMapperService dataMapperService;
    private ServiceTracker sdtModuleTracker;
    private List<TestReport> reports = new ArrayList<TestReport>();
    private boolean toBeStopped = false;

    public SubscriptionTestSuite(BundleContext pBundleContext, CseService pCseService) {
        this.bundleContext = pBundleContext;
        this.cseService = pCseService;
        ServiceReference httpServiceReference = this.bundleContext.getServiceReference(HttpService.class.getName());
        this.httpService = httpServiceReference != null ? (HttpService)this.bundleContext.getService(httpServiceReference) : null;
        ServiceReference dataMapperServiceReference = this.bundleContext.getServiceReference(DataMapperService.class.getName());
        this.dataMapperService = dataMapperServiceReference != null ? (DataMapperService)this.bundleContext.getService(dataMapperServiceReference) : null;
        if (this.httpService != null && this.dataMapperService != null) {
            this.sdtModuleTracker = new ServiceTracker(this.bundleContext, Module.class.getName(), null){

                public Object addingService(ServiceReference reference) {
                    Module module = (Module)super.addingService(reference);
                    SubscriptionTestSuite.this.testSubscriptionForModule(module);
                    return null;
                }

                public void removedService(ServiceReference reference, Object service) {
                    super.removedService(reference, service);
                }
            };
            this.sdtModuleTracker.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTests() {
        SubscriptionTestSuite subscriptionTestSuite = this;
        synchronized (subscriptionTestSuite) {
            this.toBeStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testsHaveToBeStopped() {
        boolean answer;
        SubscriptionTestSuite subscriptionTestSuite = this;
        synchronized (subscriptionTestSuite) {
            answer = this.toBeStopped;
        }
        return answer;
    }

    private void testSubscriptionForModule(final Module pModule) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Module module = pModule;
                if (module == null) {
                    TestReport report = new TestReport("Test susbcription - module null");
                    report.setErrorMessage("module null");
                    report.setState(TestReport.State.KO);
                    SubscriptionTestSuite.this.addTestReport(report);
                    return;
                }
                TestReport report = new TestReport("Test subscription for module " + module.getName());
                NotificationQueue notificationQueue = new NotificationQueue();
                SubscriptionHttpServlet servlet = new SubscriptionHttpServlet(SubscriptionTestSuite.this.httpService, SubscriptionTestSuite.this.dataMapperService, notificationQueue, module.getName());
                servlet.register();
                String subscriptionUrl = SubscriptionTestSuite.this.createSubscription(module, servlet.getServletPath());
                if (subscriptionUrl == null) {
                    return;
                }
                SubscriptionSDTListener sdtListener = new SubscriptionSDTListener(notificationQueue, SubscriptionTestSuite.this.bundleContext, module);
                sdtListener.register();
                servlet.storeNotification();
                sdtListener.storeNotification();
                while (!SubscriptionTestSuite.this.testsHaveToBeStopped()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                SubscriptionTestSuite.this.deleteSusbcription(subscriptionUrl);
                sdtListener.unregister();
                servlet.unregister();
                List<ReceivedNotification> notificationsFromOM2M = notificationQueue.getNotificationsFromOM2M();
                List<ReceivedNotification> notificationsFromSDT = notificationQueue.getNotificationsFromSDT();
                System.out.println("number of notifs(FlexContainer) for module " + module.getName() + ":" + notificationsFromOM2M.size());
                System.out.println("number of notifs(SDT) for module " + module.getName() + ":" + notificationsFromSDT.size());
                if (notificationsFromOM2M.size() != notificationsFromSDT.size()) {
                    report.setErrorMessage("received " + notificationsFromOM2M.size() + " from OM2M and received " + notificationsFromSDT.size() + " from SDT");
                    report.setState(TestReport.State.KO);
                    SubscriptionTestSuite.this.addTestReport(report);
                    return;
                }
                int i = 0;
                while (i < notificationsFromOM2M.size()) {
                    ReceivedNotification receivedNotificationOM2M = notificationsFromOM2M.get(i);
                    ReceivedNotification receivedNotificationSDT = notificationsFromSDT.get(i);
                    DataPoint dp = receivedNotificationSDT.getDataPoint();
                    Date dateSDT = receivedNotificationSDT.getDate();
                    Object value = receivedNotificationSDT.getValue();
                    AbstractFlexContainer fc = receivedNotificationOM2M.getFlexContainer();
                    Date dateOM2M = receivedNotificationOM2M.getDate();
                    CustomAttribute ca = fc.getCustomAttribute(dp.getName());
                    if (ca == null) {
                        report.setErrorMessage("No customAttribute for datapoint " + dp.getName());
                        report.setState(TestReport.State.KO);
                        SubscriptionTestSuite.this.addTestReport(report);
                        return;
                    }
                    String valueFromOM2M = ca.getCustomAttributeValue();
                    if (!valueFromOM2M.equals(value.toString())) {
                        report.setErrorMessage("value from OM2M (" + valueFromOM2M + ") is different of the value from SDT (" + value.toString() + ")");
                        report.setState(TestReport.State.KO);
                        SubscriptionTestSuite.this.addTestReport(report);
                        return;
                    }
                    long elapsedTime = Math.abs(dateOM2M.getTime() - dateSDT.getTime());
                    if (elapsedTime > 2000L) {
                        report.setErrorMessage("Delay between SDT notif and OM2M notification is over 2s");
                        report.setState(TestReport.State.KO);
                        SubscriptionTestSuite.this.addTestReport(report);
                        return;
                    }
                    ++i;
                }
                report.setState(TestReport.State.OK);
                report.setErrorMessage("nb of message:" + notificationsFromOM2M.size());
                SubscriptionTestSuite.this.addTestReport(report);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public String createSubscription(Module pModule, String servletPath) {
        String subscriptionName = "subscription_" + System.currentTimeMillis();
        Subscription subscription = new Subscription();
        subscription.setName(subscriptionName);
        subscription.getNotificationURI().add("http://127.0.0.1:" + Constants.CSE_PORT + servletPath);
        subscription.setNotificationContentType(NotificationContentType.WHOLE_RESOURCE);
        String moduleFlexContainerUrl = null;
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("name/" + pModule.getName());
        ResponsePrimitive responsePrimitive = CSEUtil.discovery(this.cseService, labels, "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        if (responsePrimitive.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            URIList discoveryResult = (URIList)responsePrimitive.getContent();
            if (discoveryResult.getListOfUri().size() == 1) {
                moduleFlexContainerUrl = (String)discoveryResult.getListOfUri().get(0);
            } else {
                System.out.println("too much discoveryResult = " + discoveryResult.getListOfUri().size());
            }
        }
        if (moduleFlexContainerUrl != null) {
            ResponsePrimitive response = CSEUtil.createSubscription(this.cseService, subscription, moduleFlexContainerUrl);
            if (!ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
                System.out.println("unable to create subscription");
            } else {
                Subscription cfr_ignored_0 = (Subscription)response.getContent();
                return String.valueOf(moduleFlexContainerUrl) + "/" + subscriptionName;
            }
        }
        return null;
    }

    public void deleteSusbcription(String subscriptionUrl) {
        ResponsePrimitive response = CSEUtil.deleteResource(this.cseService, subscriptionUrl);
        if (!ResponseStatusCode.DELETED.equals(response.getResponseStatusCode())) {
            System.out.println("unable to delete subscription: " + response.getContent());
        } else {
            System.out.println("susbcription " + subscriptionUrl + " successfully deleted");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("################################################################################");
        System.out.println("receive a POST");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTestReport(TestReport report) {
        List<TestReport> list = this.reports;
        synchronized (list) {
            this.reports.add(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TestReport> getTestReports() {
        ArrayList<TestReport> list = new ArrayList<TestReport>();
        List<TestReport> list2 = this.reports;
        synchronized (list2) {
            list.addAll(this.reports);
        }
        return list;
    }

    public void printTestReports() {
        System.out.println("################################################################################");
        List<TestReport> list = this.getTestReports();
        for (TestReport report : list) {
            System.out.println(report.toString());
        }
        System.out.println("################################################################################");
    }
}

