/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.constants;

import java.math.BigInteger;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;

public class AccessControl {
    public static final String ORIGINATOR_ALL = "*";
    public static final BigInteger CREATE = BigInteger.valueOf(1L);
    public static final BigInteger RETRIEVE = BigInteger.valueOf(2L);
    public static final BigInteger UPDATE = BigInteger.valueOf(4L);
    public static final BigInteger DELETE = BigInteger.valueOf(8L);
    public static final BigInteger NOTIFY = BigInteger.valueOf(16L);
    public static final BigInteger DISCOVERY = BigInteger.valueOf(32L);
    public static final BigInteger ALL = BigInteger.valueOf(63L);

    private AccessControl() {
    }

    public static BigInteger getOperationFromACR(AccessControlRuleEntity ruleEntity) {
        int result = 0;
        if (ruleEntity.isCreate()) {
            result += CREATE.intValue();
        }
        if (ruleEntity.isRetrieve()) {
            result += RETRIEVE.intValue();
        }
        if (ruleEntity.isUpdate()) {
            result += UPDATE.intValue();
        }
        if (ruleEntity.isDelete()) {
            result += DELETE.intValue();
        }
        if (ruleEntity.isDiscovery()) {
            result += DISCOVERY.intValue();
        }
        if (ruleEntity.isNotify()) {
            result += NOTIFY.intValue();
        }
        return BigInteger.valueOf(result);
    }

    public static AccessControlRuleEntity getARCFromOperation(BigInteger operations) {
        AccessControlRuleEntity ruleEntity = new AccessControlRuleEntity();
        int flags = operations.intValue();
        if ((flags & CREATE.intValue()) == CREATE.intValue()) {
            ruleEntity.setCreate(true);
        }
        if ((flags & RETRIEVE.intValue()) == RETRIEVE.intValue()) {
            ruleEntity.setRetrieve(true);
        }
        if ((flags & UPDATE.intValue()) == UPDATE.intValue()) {
            ruleEntity.setUpdate(true);
        }
        if ((flags & DELETE.intValue()) == DELETE.intValue()) {
            ruleEntity.setDelete(true);
        }
        if ((flags & DISCOVERY.intValue()) == DISCOVERY.intValue()) {
            ruleEntity.setDiscovery(true);
        }
        if ((flags & NOTIFY.intValue()) == NOTIFY.intValue()) {
            ruleEntity.setNotify(true);
        }
        return ruleEntity;
    }
}

