/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.internal.ui.ToggleSwitchButton;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.ui.AgentManagerDialog;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.installer.AboutDialog;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.InstallerUI;
import org.eclipse.oomph.setup.internal.installer.ProductCatalogsDialog;
import org.eclipse.oomph.setup.internal.installer.SelfUpdate;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallationLogPage;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerMenu;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerMenuButton;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.setup.internal.installer.SimpleKeepInstallerPage;
import org.eclipse.oomph.setup.internal.installer.SimpleMessageOverlay;
import org.eclipse.oomph.setup.internal.installer.SimpleProductPage;
import org.eclipse.oomph.setup.internal.installer.SimpleReadmePage;
import org.eclipse.oomph.setup.internal.installer.SimpleVariablePage;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ExceptionHandler;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public final class SimpleInstallerDialog
extends AbstractSimpleDialog
implements InstallerUI {
    private static final String CATALOGS_MENU_ITEM_TEXT = String.valueOf("Product Catalogs".toUpperCase()) + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String BUNDLE_POOLS_MENU_ITEM_TEXT = "BUNDLE POOLS" + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String UPDATE_MENU_ITEM_TEXT = "UPDATE";
    private static final String ADVANCED_MENU_ITEM_TEXT = "ADVANCED MODE...";
    private static final String ABOUT_MENU_ITEM_TEXT = "ABOUT";
    private static final String EXIT_MENU_ITEM_TEXT = "EXIT";
    private static final OomphPlugin.Preference PREF_POOL_ENABLED = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("poolEnabled");
    private static Font defaultFont;
    private static Point defaultSize;
    private static String css;
    private static String pageTemplate;
    private static String productTemplate;
    private static String productTemplateLarge;
    private final SetupWizard.Installer installer;
    private final CatalogManager catalogManager;
    private final Stack<SimpleInstallerPage> pageStack = new Stack();
    private Composite stack;
    private StackLayout stackLayout;
    private SimpleProductPage productPage;
    private SimpleVariablePage variablePage;
    private SimpleReadmePage readmePage;
    private SimpleInstallationLogPage installationLogPage;
    private SimpleKeepInstallerPage keepInstallerPage;
    private SimpleInstallerMenu installerMenu;
    private SimpleInstallerMenuButton menuButton;
    private boolean poolEnabled;
    private BundlePool pool;
    private ProfileTransaction.Resolution updateResolution;
    private SimpleMessageOverlay currentMessage;
    private ToggleSwitchButton bundlePoolSwitch;

    public SimpleInstallerDialog(Display display, SetupWizard.Installer installer) {
        super(display, OS.INSTANCE.isMac() ? 4 : 8, SimpleInstallerDialog.getDefaultSize((Drawable)display).x, SimpleInstallerDialog.getDefaultSize((Drawable)display).y);
        this.setMinimumSize(385, 75);
        this.installer = installer;
        this.catalogManager = installer.getCatalogManager();
    }

    protected void createUI(Composite titleComposite) {
        Composite exitMenuButtonContainer = new Composite(titleComposite, 0);
        exitMenuButtonContainer.setLayout((Layout)UIUtil.createGridLayout((int)1));
        exitMenuButtonContainer.setLayoutData((Object)GridDataFactory.swtDefaults().grab(false, true).align(0x1000000, 4).create());
        ImageHoverButton exitButton = new ImageHoverButton(exitMenuButtonContainer, 8, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exit.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exit_hover.png"));
        exitButton.setShowButtonDownState(false);
        exitButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 1).create());
        exitButton.setToolTipText("Exit");
        exitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.exitSelected();
            }
        });
        this.menuButton = new SimpleInstallerMenuButton(exitMenuButtonContainer);
        this.menuButton.setLayoutData(GridDataFactory.swtDefaults().grab(false, true).align(0x1000000, 1).indent(11, 0).create());
        this.menuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.toggleMenu();
            }
        });
        this.stackLayout = new StackLayout();
        this.stack = new Composite((Composite)this, 0);
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stack.setLayout((Layout)this.stackLayout);
        this.productPage = new SimpleProductPage(this.stack, this);
        this.variablePage = new SimpleVariablePage(this.stack, this);
        if (UIUtil.isBrowserAvailable()) {
            this.readmePage = new SimpleReadmePage(this.stack, this);
        }
        this.installationLogPage = new SimpleInstallationLogPage(this.stack, this);
        this.keepInstallerPage = new SimpleKeepInstallerPage(this.stack, this);
        this.switchToPage(this.productPage);
        Display display = this.getDisplay();
        UpdateSearcher updateSearcher = new UpdateSearcher(display);
        updateSearcher.start();
        display.timerExec(500, new Runnable(){

            public void run() {
                SimpleInstallerDialog.this.installer.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                SimpleInstallerDialog.this.installer.loadIndex();
            }
        });
        this.getInstallerMenu();
        final PropertyChangeListener catalogManagerListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("PROPERTY_INDEX".equals(evt.getPropertyName())) {
                    SimpleInstallerDialog.this.indexLoaded((Index)evt.getNewValue());
                }
            }
        };
        this.catalogManager.addPropertyChangeListener(catalogManagerListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SimpleInstallerDialog.this.catalogManager.removePropertyChangeListener(catalogManagerListener);
            }
        });
        this.enablePool(PREF_POOL_ENABLED.get(true));
        this.updateAvailable(false);
    }

    private void indexLoaded(Index index) {
        List productCatalogs = this.catalogManager.getCatalogs(true);
        int count = 0;
        if (productCatalogs != null) {
            for (ProductCatalog productCatalog : productCatalogs) {
                if (!SimpleProductPage.isIncluded(productCatalog)) continue;
                ++count;
            }
        }
        boolean showProductCatalogsItem = count > 1;
        this.installerMenu.findMenuItemByName(CATALOGS_MENU_ITEM_TEXT).setVisible(showProductCatalogsItem);
        this.installerMenu.layout();
    }

    private void toggleMenu() {
        this.getInstallerMenu().setVisible(!this.getInstallerMenu().isVisible());
    }

    public SetupWizard.Installer getInstaller() {
        return this.installer;
    }

    public void setButtonsEnabled(boolean enabled) {
        this.menuButton.setEnabled(enabled);
    }

    private void enablePool(boolean poolEnabled) {
        if (this.poolEnabled != poolEnabled) {
            this.poolEnabled = poolEnabled;
            PREF_POOL_ENABLED.set(poolEnabled);
        }
        this.pool = poolEnabled ? P2Util.getAgentManager().getDefaultBundlePool(SetupUIPlugin.INSTANCE.getSymbolicName()) : null;
        this.bundlePoolSwitch.setSelected(poolEnabled);
    }

    public BundlePool getPool() {
        return this.pool;
    }

    private SimpleInstallerMenu getInstallerMenu() {
        if (this.installerMenu == null) {
            this.installerMenu = this.createInstallerMenu();
        }
        return this.installerMenu;
    }

    private SimpleInstallerMenu createInstallerMenu() {
        SimpleInstallerMenu menu = new SimpleInstallerMenu(this);
        SimpleInstallerMenu.InstallerMenuItem updateInstallerItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        updateInstallerItem.setDefaultImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exclamation_circle.png"));
        updateInstallerItem.setHoverImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exclamation_circle_hover.png"));
        updateInstallerItem.setText(UPDATE_MENU_ITEM_TEXT);
        updateInstallerItem.setToolTipText("Install available updates");
        updateInstallerItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Runnable successRunnable = new Runnable(){

                    public void run() {
                        SimpleInstallerDialog.this.setReturnCode(-4);
                        SimpleInstallerDialog.this.exitSelected();
                    }
                };
                ExceptionHandler<CoreException> exceptionHandler = new ExceptionHandler<CoreException>(){

                    public void handleException(CoreException ex) {
                        ErrorDialog.open((Throwable)ex);
                    }
                };
                SelfUpdate.update(SimpleInstallerDialog.this.getShell(), SimpleInstallerDialog.this.updateResolution, successRunnable, exceptionHandler, null);
            }
        });
        SimpleInstallerMenu.InstallerMenuItem catalogsItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        catalogsItem.setText(CATALOGS_MENU_ITEM_TEXT);
        catalogsItem.setToolTipText("Select the product catalogs to use");
        catalogsItem.setVisible(false);
        catalogsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductCatalogsDialog productCatalogsDialog = new ProductCatalogsDialog(SimpleInstallerDialog.this, SimpleInstallerDialog.this.catalogManager, true);
                if (productCatalogsDialog.open() == 0) {
                    SimpleInstallerDialog.this.productPage.handleFilter("");
                }
            }
        });
        AccessUtil.setKey((Widget)catalogsItem, (Object)"catalogs");
        SimpleInstallerMenu.InstallerMenuItem advancedModeItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        advancedModeItem.setText(ADVANCED_MENU_ITEM_TEXT);
        advancedModeItem.setToolTipText("Switch to advanced mode");
        advancedModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.switchToAdvancedMode();
            }
        });
        SimpleInstallerMenu.InstallerMenuItemWithToggle bundlePoolsItem = new SimpleInstallerMenu.InstallerMenuItemWithToggle(menu);
        bundlePoolsItem.setText(BUNDLE_POOLS_MENU_ITEM_TEXT);
        bundlePoolsItem.setToolTipText("Manage your p2 agents and bundle pools");
        bundlePoolsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.manageBundlePools();
            }
        });
        this.bundlePoolSwitch = bundlePoolsItem.getToggleSwitch();
        this.bundlePoolSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.enablePool(SimpleInstallerDialog.this.bundlePoolSwitch.isSelected());
            }
        });
        SimpleInstallerMenu.InstallerMenuItem aboutItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        aboutItem.setText(ABOUT_MENU_ITEM_TEXT);
        aboutItem.setToolTipText("Show information about this installer");
        aboutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.showAbout();
            }
        });
        SimpleInstallerMenu.InstallerMenuItem exitItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        exitItem.setText(EXIT_MENU_ITEM_TEXT);
        exitItem.setDividerVisible(false);
        exitItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.exitSelected();
            }
        });
        return menu;
    }

    private void updateAvailable(boolean available) {
        this.menuButton.setNotificationVisible(available);
        this.installerMenu.findMenuItemByName(UPDATE_MENU_ITEM_TEXT).setVisible(available);
        this.installerMenu.layout();
    }

    private void manageBundlePools() {
        final boolean[] enabled = new boolean[]{this.poolEnabled};
        AgentManagerDialog dialog = new AgentManagerDialog(this.getShell()){

            protected void createUI(Composite parent) {
                final Button enabledButton = new Button(parent, 32);
                enabledButton.setText("Enable shared bundle pool");
                enabledButton.setSelection(SimpleInstallerDialog.this.poolEnabled);
                enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        enabled[0] = enabledButton.getSelection();
                        this.getComposite().setEnabled(enabled[0]);
                    }
                });
                new Label(parent, 0);
                super.createUI(parent);
                this.getComposite().setEnabled(SimpleInstallerDialog.this.poolEnabled);
            }

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(false);
                }
            }

            protected void elementChanged(Object element) {
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(element instanceof BundlePool);
                }
            }
        };
        if (this.pool != null) {
            dialog.setSelectedElement((Object)this.pool);
        }
        if (dialog.open() == 0) {
            this.enablePool(enabled[0]);
            this.pool = (BundlePool)dialog.getSelectedElement();
        }
    }

    public boolean refreshJREs() {
        if (this.variablePage != null) {
            return this.variablePage.refreshJREs();
        }
        return false;
    }

    public void showAbout() {
        String version = SelfUpdate.getProductVersion();
        new AboutDialog(this.getShell(), version).open();
    }

    public void productSelected(Product product) {
        this.variablePage.setProduct(product);
        this.switchToPage(this.variablePage);
    }

    public SimpleInstallerPage getTopPage() {
        return (SimpleInstallerPage)this.stackLayout.topControl;
    }

    private void doSwitch(SimpleInstallerPage oldPage, SimpleInstallerPage newPage) {
        if (oldPage != null) {
            oldPage.aboutToHide();
        }
        this.stackLayout.topControl = newPage;
        this.stack.layout();
        this.clearMessage();
        newPage.aboutToShow();
        newPage.setFocus();
    }

    private void switchToPage(SimpleInstallerPage newPage) {
        if (newPage != null) {
            SimpleInstallerPage oldPage;
            SimpleInstallerPage simpleInstallerPage = oldPage = !this.pageStack.isEmpty() ? this.pageStack.peek() : null;
            if (oldPage == null || oldPage != newPage) {
                this.pageStack.push(newPage);
                this.doSwitch(oldPage, newPage);
            }
        }
    }

    public void switchToAdvancedMode() {
        this.setReturnCode(3);
        this.exitSelected();
    }

    protected void exitQuiet() {
        super.exitSelected();
    }

    protected void exitSelected() {
        for (SimpleInstallerPage page : this.pageStack) {
            if (!(page instanceof SimpleVariablePage)) continue;
            SimpleVariablePage variablePage = (SimpleVariablePage)page;
            if (variablePage.promptLaunchProduct("You're about to exit the installer")) break;
            return;
        }
        this.exitQuiet();
    }

    public void backSelected() {
        if (this.pageStack.size() <= 1) {
            return;
        }
        SimpleInstallerPage oldPage = this.pageStack.pop();
        SimpleInstallerPage newPage = this.pageStack.peek();
        this.doSwitch(oldPage, newPage);
    }

    public void showMessage(String message, SimpleMessageOverlay.Type type, boolean dismissAutomatically) {
        this.showMessage(message, type, dismissAutomatically, null);
    }

    public void showMessage(String message, SimpleMessageOverlay.Type type, boolean dismissAutomatically, Runnable action) {
        if (this.currentMessage == null || this.currentMessage.getType() != type || this.currentMessage.isDismissAutomatically() != dismissAutomatically || this.currentMessage.getAction() != action) {
            this.clearMessage();
            this.currentMessage = new SimpleMessageOverlay(this, type, new SimpleMessageOverlay.ControlRelocator(){

                public void relocate(Control control) {
                    Rectangle bounds = SimpleInstallerDialog.this.getBounds();
                    int x = bounds.x + 5;
                    int y = bounds.y + 24;
                    int width = bounds.width - 9;
                    int height = SimpleInstallerDialog.this.pageStack.peek() instanceof SimpleProductPage ? 87 : 70;
                    control.setBounds(x, y, width, height);
                }
            }, dismissAutomatically, action);
        }
        this.currentMessage.setMessage(message);
        this.currentMessage.setVisible(true);
    }

    public void clearMessage() {
        if (this.currentMessage != null) {
            if (!this.currentMessage.isDisposed()) {
                this.currentMessage.close();
            }
            this.currentMessage = null;
        }
    }

    public void showReadme(java.net.URI readmeURI) {
        if (this.readmePage != null) {
            this.readmePage.setReadmeURI(readmeURI);
            this.switchToPage(this.readmePage);
        } else {
            OS.INSTANCE.openSystemBrowser(readmeURI.toString());
        }
    }

    public void showInstallationLog(File installationLogFile) {
        this.installationLogPage.setInstallationLogFile(installationLogFile);
        this.switchToPage(this.installationLogPage);
    }

    public void showKeepInstaller() {
        this.switchToPage(this.keepInstallerPage);
    }

    public void dispose() {
        this.menuButton.setFocus();
        super.dispose();
    }

    public static Font getFont(int relativeHeight, String style) {
        String height = relativeHeight == 0 ? "" : (relativeHeight > 0 ? "+" + relativeHeight : Integer.toString(relativeHeight));
        return SetupInstallerPlugin.getFont((Font)SimpleInstallerDialog.getDefaultFont(), (Object)URI.createURI((String)("font:///" + height + "/" + style)));
    }

    static Font getDefaultFont() {
        if (defaultFont == null && (defaultFont = JFaceResources.getFont((String)"font-open-sans.label-default")) == null) {
            defaultFont = UIUtil.getDisplay().getSystemFont();
        }
        return defaultFont;
    }

    static Point getDefaultSize(Drawable drawable) {
        if (defaultSize == null) {
            defaultSize = SimpleInstallerDialog.computeSize(drawable, SimpleInstallerDialog.getDefaultFont(), 37, 38);
        }
        return defaultSize;
    }

    static Point computeSize(Drawable drawable, Font font, int x, int y) {
        GC gc = new GC(drawable);
        gc.setFont(font);
        try {
            int height = gc.getFontMetrics().getHeight();
            int totalWidth = height * x;
            int totalHeight = height * y;
            Point point = new Point(totalWidth, totalHeight);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    static String getCSS() {
        if (css == null) {
            try {
                css = SimpleInstallerDialog.readBundleResource("html/css/simpleInstaller.css");
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return css;
    }

    static String getPageTemplate() {
        if (pageTemplate == null) {
            try {
                pageTemplate = SimpleInstallerDialog.readBundleResource("html/PageTemplate.html");
                pageTemplate = pageTemplate.replace("%INSTALLER_CSS%", SimpleInstallerDialog.getCSS());
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return pageTemplate;
    }

    static String getProductTemplate() {
        if (productTemplate == null) {
            try {
                productTemplate = SimpleInstallerDialog.readBundleResource("html/ProductTemplate.html");
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return productTemplate;
    }

    static String getProductTemplateLarge() {
        if (productTemplateLarge == null) {
            try {
                productTemplateLarge = SimpleInstallerDialog.readBundleResource("html/ProductTemplateLarge.html");
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return productTemplateLarge;
    }

    private static String readBundleResource(String name) throws IOException {
        try {
            OomphPlugin.BundleFile root = SetupInstallerPlugin.INSTANCE.getRootFile();
            OomphPlugin.BundleFile child = root.getChild(name);
            return child.getContentsString();
        }
        catch (Exception ex) {
            throw new IOExceptionWithCause((Throwable)ex);
        }
    }

    private final class UpdateSearcher
    extends Thread {
        private Display display;

        public UpdateSearcher(Display display) {
            super("Simple Update Searcher");
            this.display = display;
        }

        public void run() {
            try {
                User user = SimpleInstallerDialog.this.getInstaller().getUser();
                SimpleInstallerDialog.this.updateResolution = SelfUpdate.resolve(user, null);
                if (SimpleInstallerDialog.this.updateResolution != null && !this.display.isDisposed()) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            SimpleInstallerDialog.this.updateAvailable(true);
                        }
                    });
                }
            }
            catch (CoreException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
    }
}

