/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public abstract class AbstractWorkspaceOperation
extends AbstractOperation
implements IAdvancedUndoableOperation,
IAdvancedUndoableOperation2 {
    private static String ELLIPSIS = "...";
    protected static int EXECUTE = 1;
    protected static int UNDO = 2;
    protected static int REDO = 3;
    protected IResource[] resources;
    private boolean isValid = true;
    protected boolean quietCompute = false;
    String[] modelProviderIds;

    AbstractWorkspaceOperation(String name) {
        super(Action.removeMnemonics((String)name));
        String label = this.getLabel();
        if (label.endsWith(ELLIPSIS)) {
            this.setLabel(label.substring(0, label.length() - ELLIPSIS.length()));
        }
    }

    public void setModelProviderIds(String[] ids) {
        this.modelProviderIds = ids;
    }

    protected void setTargetResources(IResource[] resources) {
        this.resources = resources;
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected IResourceRuleFactory getWorkspaceRuleFactory() {
        return this.getWorkspace().getRuleFactory();
    }

    protected void markInvalid() {
        this.isValid = false;
    }

    public boolean canExecute() {
        return this.isValid();
    }

    public boolean canUndo() {
        return this.isValid();
    }

    public boolean canRedo() {
        return this.isValid();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
        try {
            this.getWorkspace().run(monitor1 -> this.doExecute(monitor1, uiInfo), this.getExecuteSchedulingRule(), 1, monitor);
        }
        catch (CoreException e) {
            throw new ExecutionException(NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_ExecuteErrorTitle, (Object)this.getLabel()), (Throwable)e);
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
        try {
            this.getWorkspace().run(monitor1 -> this.doExecute(monitor1, uiInfo), this.getRedoSchedulingRule(), 1, monitor);
        }
        catch (CoreException e) {
            throw new ExecutionException(NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_RedoErrorTitle, (Object)this.getLabel()), (Throwable)e);
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
        try {
            this.getWorkspace().run(monitor1 -> this.doUndo(monitor1, uiInfo), this.getUndoSchedulingRule(), 1, monitor);
        }
        catch (CoreException e) {
            throw new ExecutionException(NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_UndoErrorTitle, (Object)this.getLabel()), (Throwable)e);
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    protected abstract void doUndo(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected abstract void doExecute(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected boolean isValid() {
        return this.isValid;
    }

    public void aboutToNotify(OperationHistoryEvent event) {
    }

    public Object[] getAffectedObjects() {
        return this.resources;
    }

    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        boolean proceed;
        IStatus status = Status.OK_STATUS;
        if (this.quietCompute) {
            return status;
        }
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(factory, EXECUTE) && !(proceed = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_ExecuteSideEffectsWarningMessage, (Object)this.getLabel()), factory.getDelta(), this.modelProviderIds, true))) {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        boolean proceed;
        IStatus status = Status.OK_STATUS;
        if (this.quietCompute) {
            return status;
        }
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(factory, UNDO) && !(proceed = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_UndoSideEffectsWarningMessage, (Object)this.getLabel()), factory.getDelta(), this.modelProviderIds, true))) {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        boolean proceed;
        IStatus status = Status.OK_STATUS;
        if (this.quietCompute) {
            return status;
        }
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(factory, REDO) && !(proceed = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_RedoSideEffectsWarningMessage, (Object)this.getLabel()), factory.getDelta(), this.modelProviderIds, true))) {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        return false;
    }

    protected IStatus getErrorStatus(String message) {
        String statusMessage = message;
        if (statusMessage == null) {
            statusMessage = NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_ErrorInvalidMessage, (Object)this.getLabel());
        }
        return new Status(4, "org.eclipse.ui.ide", 3, statusMessage, null);
    }

    protected IStatus getWarningStatus(String message, int code) {
        String statusMessage = message;
        if (statusMessage == null) {
            statusMessage = NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_GenericWarningMessage, (Object)this.getLabel());
        }
        return new Status(2, "org.eclipse.ui.ide", code, statusMessage, null);
    }

    protected boolean resourcesExist() {
        if (this.resources == null || this.resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.resources.length) {
            if (this.resources[i] == null || !this.resources[i].exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean resourcesIncludesProjects() {
        if (this.resources == null || this.resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.resources.length) {
            if (this.resources[i].getType() == 4) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ISchedulingRule getExecuteSchedulingRule() {
        return this.getWorkspace().getRoot();
    }

    protected ISchedulingRule getUndoSchedulingRule() {
        return this.getWorkspace().getRoot();
    }

    protected ISchedulingRule getRedoSchedulingRule() {
        return this.getExecuteSchedulingRule();
    }

    public void setQuietCompute(boolean quiet) {
        this.quietCompute = quiet;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append("\n");
        text.append(((Object)((Object)this)).getClass().getName());
        this.appendDescriptiveText(text);
        return text.toString();
    }

    protected void appendDescriptiveText(StringBuffer text) {
        text.append(" resources: ");
        text.append(this.resources);
        text.append('\'');
    }

    protected Shell getShell(IAdaptable uiInfo) {
        Shell shell;
        if (uiInfo != null && (shell = (Shell)uiInfo.getAdapter(Shell.class)) != null) {
            return shell;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public boolean runInBackground() {
        return true;
    }
}

