/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import java.io.IOException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.setup.internal.sync.SynchronizerCredentials;
import org.eclipse.oomph.setup.internal.sync.SynchronizerService;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerLoginComposite;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SynchronizerLoginDialog
extends AbstractSetupDialog
implements ModifyListener {
    private SynchronizerService service;
    private SynchronizerCredentials credentials;
    private SynchronizerLoginComposite loginComposite;
    private Button okButton;

    public SynchronizerLoginDialog(Shell parentShell, SynchronizerService service) {
        super(parentShell, "Configure Synchronizer", 400, 280, SetupUIPlugin.INSTANCE, false);
        this.service = service;
    }

    public SynchronizerService getService() {
        return this.service;
    }

    public SynchronizerCredentials getCredentials() {
        return this.credentials;
    }

    protected String getShellText() {
        return "Oomph Preference Synchronizer";
    }

    protected String getDefaultMessage() {
        return "Connect your local workstation to your Eclipse.org account.  Press 'F1' for details.";
    }

    protected String getImagePath() {
        return "sync/LoginBanner.png";
    }

    protected void createUI(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.loginComposite = new SynchronizerLoginComposite(parent, 0, 10, 10){

            protected void validate() {
                SynchronizerLoginDialog.this.validatePage();
            }
        };
        this.loginComposite.setLayoutData(new GridData(4, 4, true, true));
        this.loginComposite.setService(this.service);
        Dialog.applyDialogFont((Control)this.loginComposite);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.validatePage();
    }

    public void modifyText(ModifyEvent e) {
        this.validatePage();
    }

    protected void okPressed() {
        SynchronizerCredentials credentials = this.loginComposite.getCredentials();
        try {
            if (!this.service.validateCredentials(credentials)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Authorization Failed", (String)"You could not be authorized with the specified credentials.");
                return;
            }
        }
        catch (IOException ex) {
            ErrorDialog.open((Throwable)ex);
            return;
        }
        this.credentials = credentials;
        super.okPressed();
    }

    private void validatePage() {
        if (this.okButton != null) {
            SynchronizerCredentials credentials = this.loginComposite.getCredentials();
            this.okButton.setEnabled(credentials != null);
        }
    }
}

