/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.IncrementUpdateJob;
import org.eclipse.ui.internal.views.markers.MarkerComparator;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.MarkerUpdate;
import org.eclipse.ui.internal.views.markers.MarkerUpdateJob;
import org.eclipse.ui.internal.views.markers.MarkerUpdateScheduler;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.internal.views.markers.MarkersChangeListener;
import org.eclipse.ui.internal.views.markers.SortingJob;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerGroup;

public class CachedMarkerBuilder {
    private static final String TAG_CATEGORY_GROUP = "categoryGroup";
    private static final String VALUE_NONE = "none";
    private MarkerContentGenerator generator;
    private MarkerUpdateJob updateJob;
    private MarkersChangeListener markerListener;
    private MarkerUpdateScheduler scheduler;
    private Markers markers;
    private Markers markersClone;
    final Object MARKER_INCREMENTAL_UPDATE_FAMILY = new Object();
    final Object CACHE_UPDATE_FAMILY = new Object();
    final Object MARKERSVIEW_UPDATE_JOB_FAMILY;
    private IWorkbenchSiteProgressService progressService;
    private MarkerGroup categoryGroup;
    private MarkerComparator comparator;
    private boolean[] changeFlags;
    private IPropertyChangeListener workingSetListener;
    private boolean active = false;
    private boolean building;
    private IMemento memento;
    private IncrementUpdateJob incrementJob;

    public CachedMarkerBuilder(ExtendedMarkersView view) {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        this.changeFlags = blArray;
        this.MARKERSVIEW_UPDATE_JOB_FAMILY = view.MARKERSVIEW_UPDATE_JOB_FAMILY;
        this.markers = new Markers(this);
        this.markerListener = new MarkersChangeListener(view, this);
        this.scheduler = new MarkerUpdateScheduler(view, this);
    }

    void restoreState(IMemento m) {
        if (m == null) {
            this.setDefaultCategoryGroup(this.getGenerator());
        } else {
            String categoryGroupID = m.getString(TAG_CATEGORY_GROUP);
            if (categoryGroupID == null) {
                this.setDefaultCategoryGroup(this.getGenerator());
            } else if (categoryGroupID.equals(VALUE_NONE)) {
                this.categoryGroup = null;
            } else {
                MarkerGroup newGroup = this.getGenerator().getMarkerGroup(categoryGroupID);
                if (newGroup == null) {
                    this.setDefaultCategoryGroup(this.getGenerator());
                } else {
                    this.categoryGroup = newGroup;
                }
            }
        }
        this.memento = m;
    }

    void start() {
        this.active = true;
        this.registerTypesToListener();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.getWorkingSetListener());
        this.markerListener.start();
        this.scheduleUpdate();
    }

    void dispose() {
        this.markerListener.stop();
        this.active = false;
        Job.getJobManager().cancel(this.MARKERSVIEW_UPDATE_JOB_FAMILY);
        if (this.workingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.getWorkingSetListener());
        }
        if (this.isIncremental() && this.incrementJob != null) {
            this.incrementJob.clearEntries();
        }
    }

    MarkerGroup getCategoryGroup() {
        return this.categoryGroup;
    }

    MarkerComparator getComparator() {
        if (this.comparator == null) {
            MarkerField field = null;
            if (this.getCategoryGroup() != null) {
                field = this.getCategoryGroup().getMarkerField();
            }
            this.comparator = new MarkerComparator(field, this.generator.getAllFields());
            if (this.memento != null) {
                this.comparator.restore(this.memento);
            }
        }
        return this.comparator;
    }

    MarkerContentGenerator getGenerator() {
        return this.generator;
    }

    MarkerField getPrimarySortField() {
        return this.getComparator().getPrimarySortField();
    }

    int getSortDirection(MarkerField field) {
        if (this.getComparator().descendingFields.contains(field)) {
            return -1;
        }
        return 1;
    }

    int getTotalMarkerCount() {
        return CachedMarkerBuilder.getTotalMarkerCount(this.getMarkers());
    }

    static int getTotalMarkerCount(Markers markers) {
        MarkerSupportItem[] elements = markers.getElements();
        if (elements.length == 0 || elements[0].isConcrete()) {
            return elements.length;
        }
        int length = 0;
        int i = 0;
        while (i < elements.length) {
            length += elements[i].getChildren().length;
            ++i;
        }
        return length;
    }

    boolean isBuilding() {
        return this.building || this.markerListener.isReceivingChange();
    }

    void setBuilding(boolean building) {
        this.building = building;
    }

    boolean isShowingHierarchy() {
        return this.categoryGroup != null;
    }

    void refreshContents(IWorkbenchSiteProgressService service) {
        try {
            service.busyCursorWhile(monitor -> {
                SortingJob job = new SortingJob(this);
                job.run(monitor);
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    void refreshContents() {
        SortingJob job = new SortingJob(this);
        job.setPriority(10);
        job.setSystem(true);
        if (this.progressService != null) {
            this.progressService.schedule((Job)job, 150L);
        } else {
            job.schedule(150L);
        }
    }

    void saveState(IMemento m) {
        this.getComparator().saveState(m);
        if (this.categoryGroup == null) {
            m.putString(TAG_CATEGORY_GROUP, VALUE_NONE);
        } else {
            m.putString(TAG_CATEGORY_GROUP, this.getCategoryGroup().getId());
        }
    }

    void scheduleUpdate() {
        if (this.active) {
            this.scheduler.scheduleUpdate(150L, true);
        }
    }

    void scheduleUpdate(long delay) {
        if (this.active) {
            this.scheduler.scheduleUpdate(delay, true);
        }
    }

    boolean updatesPending() {
        if (this.active) {
            return this.scheduler.updatesPending();
        }
        return false;
    }

    void speedUpPendingUpdates() {
        if (this.active) {
            this.scheduler.speedUpPendingUpdates();
        }
    }

    void setCategoryGroup(MarkerGroup group) {
        this.categoryGroup = group;
        if (group == null) {
            this.getComparator().setCategory(null);
        } else {
            this.getComparator().setCategory(group.getMarkerField());
        }
        this.scheduleUpdate();
    }

    private void setDefaultCategoryGroup(MarkerContentGenerator contentGenerator) {
        MarkerGroup group;
        String categoryName = contentGenerator.getCategoryName();
        if (categoryName != null && (group = contentGenerator.getMarkerGroup(categoryName)) != null) {
            this.categoryGroup = group;
        }
    }

    void setGenerator(MarkerContentGenerator newGenerator) {
        this.generator = newGenerator;
        if (this.generator.getBuilder() != this) {
            this.generator.setBuilder(this);
        }
        this.setDefaultCategoryGroup(this.generator);
        this.scheduleUpdate();
    }

    void setPrimarySortField(MarkerField field) {
        this.getComparator().setPrimarySortField(field);
    }

    MarkerUpdateScheduler getUpdateScheduler() {
        return this.scheduler;
    }

    void setProgressService(IWorkbenchSiteProgressService service) {
        this.progressService = service;
        if (service != null) {
            service.showBusyForFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            service.showBusyForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
            service.showBusyForFamily(this.CACHE_UPDATE_FAMILY);
            service.showBusyForFamily(this.MARKERSVIEW_UPDATE_JOB_FAMILY);
        }
    }

    IWorkbenchSiteProgressService getProgressService() {
        return this.progressService;
    }

    MarkerUpdateJob scheduleUpdateJob(long delay) {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        return this.scheduleUpdateJob(delay, false, blArray);
    }

    MarkerUpdateJob scheduleUpdateJob(long delay, boolean clean) {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        return this.scheduleUpdateJob(delay, clean, blArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MarkerUpdateJob scheduleUpdateJob(long delay, boolean clean, boolean[] newChangeFlags) {
        this.setBuilding(true);
        this.updateChangeFlags(newChangeFlags);
        Object object = this.getUpdateScheduler().getSchedulingLock();
        synchronized (object) {
            block8: {
                if (this.generator != null && this.active) break block8;
                return null;
            }
            if (this.updateJob == null) {
                this.updateJob = new MarkerUpdateJob(this);
                this.updateJob.setPriority(30);
                this.updateJob.setSystem(true);
            }
            if (clean) {
                this.updateJob.setClean();
            }
            if (this.progressService != null) {
                this.progressService.schedule((Job)this.updateJob, delay);
            } else {
                this.updateJob.schedule(delay);
            }
            return this.updateJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelUpdate() {
        Object object = this.getUpdateScheduler().getSchedulingLock();
        synchronized (object) {
            if (this.updateJob != null) {
                this.updateJob.cancel();
            }
        }
    }

    MarkersChangeListener getMarkerListener() {
        return this.markerListener;
    }

    void setMarkerListener(MarkersChangeListener markerListener) {
        this.markerListener = markerListener;
    }

    boolean includeMarkerSubTypes() {
        return true;
    }

    void registerTypesToListener() {
        MarkerContentGenerator gen = this.getGenerator();
        if (gen == null) {
            return;
        }
        this.getMarkerListener().listenToTypes(gen.getTypes(), this.includeMarkerSubTypes());
    }

    Markers getMarkers() {
        return this.markers;
    }

    private IPropertyChangeListener getWorkingSetListener() {
        if (this.workingSetListener == null) {
            this.workingSetListener = new WorkingSetListener();
        }
        return this.workingSetListener;
    }

    static String getMementoPreferenceName(String viewId) {
        return String.valueOf(CachedMarkerBuilder.class.getName()) + viewId;
    }

    boolean isActive() {
        return this.active;
    }

    long getLastUpdateTime() {
        if (this.updateJob != null) {
            return this.updateJob.getLastUpdateTime();
        }
        return -1L;
    }

    Markers getClonedMarkers() {
        if (this.markersClone == null) {
            this.markersClone = this.markers.getClone();
        }
        return this.markersClone;
    }

    Markers createMarkersClone() {
        if (this.markers.isInChange()) {
            return null;
        }
        this.markersClone = this.markers.getClone();
        return this.markersClone;
    }

    boolean isIncremental() {
        return false;
    }

    boolean[] readChangeFlags() {
        boolean[] changes = new boolean[this.changeFlags.length];
        int i = 0;
        while (i < changes.length) {
            changes[i] = this.changeFlags[i];
            this.changeFlags[i] = false;
            ++i;
        }
        return changes;
    }

    void updateChangeFlags(boolean[] newChangeFlags) {
        int i = 0;
        while (i < newChangeFlags.length) {
            this.changeFlags[i] = this.changeFlags[i] | newChangeFlags[i];
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementalUpdate(MarkerUpdate update) {
        Object object = this.getUpdateScheduler().getSchedulingLock();
        synchronized (object) {
            if (this.incrementJob == null) {
                this.scheduleUpdateJob(150L, true);
            }
        }
        this.incrementJob.addUpdate(update);
    }

    private class WorkingSetListener
    implements IPropertyChangeListener {
        private WorkingSetListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet wSet;
            boolean needsUpdate = false;
            if (event.getProperty().equals("workingSetContentChange")) {
                for (MarkerFieldFilterGroup group : CachedMarkerBuilder.this.generator.getEnabledFilters()) {
                    if (group.getScope() != 4 || (wSet = group.getWorkingSet()) == null || !wSet.equals(event.getNewValue())) continue;
                    group.refresh();
                    needsUpdate = true;
                }
            }
            if (event.getProperty().equals("workingSetRemove")) {
                for (MarkerFieldFilterGroup group : CachedMarkerBuilder.this.generator.getAllFilters()) {
                    if (group.getScope() != 4 || (wSet = group.getWorkingSet()) == null || !wSet.equals(event.getOldValue())) continue;
                    group.setWorkingSet(null);
                    group.refresh();
                    needsUpdate = true;
                }
            }
            if (needsUpdate) {
                CachedMarkerBuilder.this.scheduleUpdate();
            }
        }
    }
}

