/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;

public class SetupArchiver
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        long finalLastModified;
        URI outputLocation;
        String[] arguments = (String[])context.getArguments().get("application.args");
        File file = new File(System.getProperty("java.io.tmpdir"), "setups.zip");
        int i = 0;
        while (i < arguments.length) {
            if ("-target".equals(arguments[i])) {
                file = new File(arguments[++i]);
            }
            ++i;
        }
        HashSet<String> entryNames = new HashSet<String>();
        long lastModified = file.lastModified();
        File temp = new File(String.valueOf(file.toString()) + ".tmp");
        if (lastModified == 0L) {
            outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/"));
        } else {
            try {
                IOUtil.copyFile((File)file, (File)temp);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (!temp.setLastModified(lastModified)) {
                System.err.println("Count not set timestamp of " + temp);
            }
            outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)temp.toString()) + "!/"));
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(temp);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    String name = zipEntry.getName();
                    entryNames.add(name);
                    URI path = URI.createURI((String)name);
                    URI uri = URI.createURI((String)(String.valueOf(path.segment(0)) + ":" + "//" + path.segment(1)));
                    int i2 = 2;
                    int length = path.segmentCount();
                    while (i2 < length) {
                        uri = uri.appendSegment(path.segment(i2));
                        ++i2;
                    }
                    URI archiveEntry = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/" + path));
                    System.out.println("Previously mirrored " + uri + " -> " + archiveEntry);
                }
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        final ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
        SetupWizard.IndexLoader.ResourceMirrorWithProductImages resourceMirror = new SetupWizard.IndexLoader.ResourceMirrorWithProductImages(resourceSet){

            protected void visit(EObject eObject) {
                URI imageURI;
                EClass eClass;
                if (eObject instanceof EClass && !(eClass = (EClass)eObject).isAbstract() && (imageURI = EAnnotations.getImageURI((EClass)eClass)) != null && resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().containsKey(imageURI.fileExtension())) {
                    this.schedule(imageURI, true);
                }
                super.visit(eObject);
            }
        };
        resourceMirror.perform((Object)SetupContext.INDEX_SETUP_URI);
        resourceMirror.dispose();
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        ECFURIHandlerImpl.clearExpectedETags();
        URIConverter uriConverter = resourceSet.getURIConverter();
        Map uriMap = uriConverter.getURIMap();
        HashMap<String, String> options = new HashMap<String, String>();
        if (lastModified != 0L) {
            options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        }
        uriMap.remove(SetupContext.INDEX_SETUP_LOCATION_URI.trimSegments(1).appendSegment(""));
        for (Resource resource : resourceSet.getResources()) {
            URI uri = resource.getURI();
            URI normalizedURI = uriConverter.normalize(uri);
            String scheme = normalizedURI.scheme();
            if (normalizedURI.query() == null && ("http".equals(scheme) || "https".equals(scheme))) {
                URI path = URI.createURI((String)scheme);
                path = path.appendSegment(normalizedURI.authority());
                path = path.appendSegments(normalizedURI.segments());
                System.out.println("Mirroring " + normalizedURI);
                if (resource.getContents().isEmpty()) {
                    System.err.println("Failed to load " + normalizedURI);
                    continue;
                }
                URI output = path.resolve(outputLocation);
                entryNames.remove(path.toString());
                uriMap.put(uri, output);
                try {
                    long before = resource.getTimeStamp();
                    resource.save(options);
                    long after = resource.getTimeStamp();
                    if (after - before <= 0L) continue;
                    System.err.println("changed! " + normalizedURI);
                }
                catch (IOException ex) {
                    System.err.println("Failed to save " + normalizedURI);
                    ex.printStackTrace();
                }
                continue;
            }
            System.out.println("Ignoring  " + normalizedURI);
        }
        for (String entryName : entryNames) {
            URI archiveEntry = URI.createURI((String)(outputLocation + entryName));
            uriConverter.delete(archiveEntry, null);
        }
        long l = finalLastModified = lastModified == 0L ? file.lastModified() : temp.lastModified();
        if (lastModified != finalLastModified) {
            if (OS.INSTANCE.isWin() && lastModified != 0L && !file.delete()) {
                System.err.println("Could not delete " + file);
            }
            if (lastModified == 0L) {
                System.out.println("Successfully created " + file);
            } else if (temp.renameTo(file)) {
                System.out.println("Successful updates for " + file);
            } else {
                System.err.println("Could not rename " + temp + " to " + file);
            }
        } else {
            System.out.println("No updates for " + file);
            if (!temp.delete()) {
                System.err.println("Could not delete " + temp);
            }
        }
        return null;
    }

    public void stop() {
    }
}

