/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.sync.Snapshot;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerService;
import org.eclipse.oomph.setup.provider.PreferenceTaskItemProvider;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.AbstractRecorderDialog;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizerDialog
extends AbstractRecorderDialog {
    private static final int ICON = 16;
    private static final int SPACE = 5;
    private static final int H_INDENT = 10;
    private static final int V_INDENT = 1;
    private final PaintHandler paintHandler = new PaintHandler();
    private final MouseHandler mouseHandler = new MouseHandler();
    private final ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
    private final URIConverter uriConverter = this.resourceSet.getURIConverter();
    private final ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
    private final Map<SetupTask, TaskItem> taskItems = new HashMap<SetupTask, TaskItem>();
    private final Mode mode;
    private final RecorderTransaction recorderTransaction;
    private final Map<URI, String> recorderValues;
    private final Set<URI> recorderValuesToRemove = new HashSet<URI>();
    private final Scope recorderTarget;
    private final Image recorderTargetImage;
    private final String recorderTargetText;
    private final Synchronization synchronization;
    private Tree tree;
    private TreeColumn labelColumn;
    private TreeColumn localColumn;
    private TreeColumn remoteColumn;
    private ControlAdapter columnResizer;
    private final ColumnManager[] columnManagers = new ColumnManager[3];
    private LocalColumnManager localColumnManager;
    private RemoteColumnManager remoteColumnManager;
    private Text valueText;
    private Button enableRecorderButton;

    public SynchronizerDialog(Shell parentShell) {
        this(parentShell, null, null, null);
    }

    public SynchronizerDialog(Shell parentShell, RecorderTransaction transaction, Map<URI, String> preferences, Synchronization sync) {
        super(parentShell, SynchronizerDialog.getTitle(transaction), 800, 600);
        PreferenceTaskItemProvider.setShortenLabelText((AdapterFactory)this.adapterFactory);
        if (transaction != null) {
            URI uri = RecorderManager.normalize(this.uriConverter, RecorderManager.INSTANCE.getRecorderTarget());
            this.recorderTarget = (Scope)this.resourceSet.getEObject(uri, true);
            ItemProviderAdapter itemProvider = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)this.recorderTarget, IItemLabelProvider.class);
            this.recorderTargetImage = SetupUIPlugin.INSTANCE.getSWTImage(SetupLabelProvider.getImageDescriptor(itemProvider, (EObject)this.recorderTarget));
            this.recorderTargetText = SetupLabelProvider.getText(itemProvider, (EObject)this.recorderTarget);
            if (sync != null) {
                this.mode = Mode.RECORD_AND_SYNC;
                this.recorderTransaction = transaction;
                this.recorderValues = preferences;
                this.synchronization = sync;
            } else {
                this.mode = Mode.RECORD;
                this.recorderTransaction = transaction;
                this.recorderValues = preferences;
                this.synchronization = null;
            }
        } else {
            this.mode = Mode.SYNC;
            this.recorderTransaction = null;
            this.recorderValues = null;
            this.recorderTarget = null;
            this.recorderTargetImage = null;
            this.recorderTargetText = null;
            this.synchronization = sync;
        }
    }

    public String getHelpPath() {
        return String.valueOf(SetupUIPlugin.INSTANCE.getSymbolicName()) + "/html/RecorderHelp.html";
    }

    @Override
    protected String getShellText() {
        return "Oomph " + SynchronizerDialog.getTitle(this.recorderTransaction);
    }

    protected String getDefaultMessage() {
        switch (this.mode) {
            case RECORD: {
                if (this.recorderTarget instanceof User) {
                    return "Select what to record for reuse across all workspaces.";
                }
                if (this.recorderTarget instanceof Installation) {
                    return "Select what to record for reuse across all workspaces of the current installation.";
                }
                if (this.recorderTarget instanceof Workspace) {
                    return "Select what to record for the use of just this workspace.";
                }
                return "Select what to record into " + this.recorderTargetText + ".";
            }
            case SYNC: {
                return "Select what to synchronize with " + SynchronizerManager.INSTANCE.getService().getLabel() + " for reuse across all machines.";
            }
            case RECORD_AND_SYNC: {
                return "Select what to record for reuse across all workspaces on this machine and what to synchronize with " + SynchronizerManager.INSTANCE.getService().getLabel() + " for reuse across all your other machines.";
            }
        }
        return null;
    }

    protected void createUI(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SynchronizerDialog.this.adapterFactory.dispose();
            }
        });
        this.initializeDialogUnits((Control)parent);
        SashForm sashForm = new SashForm(parent, 66048);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree = new Tree((Composite)sashForm, 65536);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.addListener(41, (Listener)this.paintHandler);
        this.tree.addListener(42, (Listener)this.paintHandler);
        this.tree.addListener(3, (Listener)this.mouseHandler);
        this.tree.setFocus();
        this.labelColumn = new TreeColumn(this.tree, 0);
        this.labelColumn.setText("Preference");
        this.labelColumn.setWidth(200);
        this.labelColumn.setResizable(true);
        if (this.mode.isRecord()) {
            this.localColumn = new TreeColumn(this.tree, 0);
            this.localColumn.setText("Local Policy");
            this.localColumn.setWidth(200);
            this.localColumn.setResizable(true);
            this.localColumnManager = new LocalColumnManager(this);
        }
        if (this.mode.isSync()) {
            SynchronizerService service = SynchronizerManager.INSTANCE.getService();
            this.remoteColumnManager = new RemoteColumnManager(this, service.getLabel());
        }
        this.populateTree();
        this.initColumnResizer();
        this.valueText = new Text((Composite)sashForm, 776);
        this.valueText.setBackground(this.getShell().getDisplay().getSystemColor(1));
        Listener scrollBarListener = new Listener(){
            protected boolean changing;

            public void handleEvent(Event event) {
                if (!this.changing) {
                    this.changing = true;
                    Rectangle clientArea = SynchronizerDialog.this.valueText.getClientArea();
                    Rectangle trimArea = SynchronizerDialog.this.valueText.computeTrim(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                    Point size = SynchronizerDialog.this.valueText.computeSize(-1, -1, true);
                    SynchronizerDialog.this.valueText.getHorizontalBar().setVisible(trimArea.width <= size.x);
                    SynchronizerDialog.this.valueText.getVerticalBar().setVisible(trimArea.height <= size.y);
                    this.changing = false;
                }
            }
        };
        this.valueText.addListener(11, scrollBarListener);
        this.valueText.addListener(24, scrollBarListener);
        sashForm.setWeights(new int[]{4, 1});
        Dialog.applyDialogFont((Control)sashForm);
        SynchronizerDialog.showFirstTimeHelp((TrayDialog)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.enableRecorderButton = this.createCheckbox(parent, "Recorder enabled");
        this.enableRecorderButton.setToolTipText("The enablement can be changed later on the preference page Oomph | Setup | Preference Recorder");
        this.enableRecorderButton.setSelection(this.isEnableRecorder());
        this.enableRecorderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizerDialog.this.validatePage();
            }
        });
        super.createButtonsForButtonBar(parent);
        this.validatePage();
    }

    protected void validatePage() {
        boolean enableRecorder = this.enableRecorderButton != null && this.enableRecorderButton.getSelection();
        this.setEnableRecorder(enableRecorder);
        this.tree.setEnabled(enableRecorder);
        this.updateColumns();
        if (this.valueText != null) {
            this.valueText.setVisible(enableRecorder);
        }
    }

    protected void okPressed() {
        this.recorderValues.keySet().removeAll(this.recorderValuesToRemove);
        super.okPressed();
    }

    private ColumnManager getColumnManager(int column) {
        if (column < this.columnManagers.length) {
            return this.columnManagers[column];
        }
        return null;
    }

    private void updateColumns() {
        int remoteColumnIndex;
        if (this.localColumn != null) {
            this.columnManagers[1] = this.localColumnManager;
            remoteColumnIndex = 2;
        } else {
            this.columnManagers[1] = null;
            remoteColumnIndex = 1;
        }
        if (this.mode.isSync()) {
            if (this.remoteColumn == null) {
                this.remoteColumn = new TreeColumn(this.tree, 0, 2);
                this.remoteColumn.setText("Remote Policy");
                this.remoteColumn.setWidth(200);
                this.remoteColumn.setResizable(true);
                this.remoteColumn.addControlListener((ControlListener)this.columnResizer);
                this.columnManagers[remoteColumnIndex] = this.remoteColumnManager;
                this.resizeColumns();
            }
        } else if (this.remoteColumn != null) {
            this.remoteColumn.dispose();
            this.remoteColumn = null;
            this.columnManagers[remoteColumnIndex] = null;
            this.resizeColumns();
        }
    }

    private void resizeColumns() {
        this.columnResizer.controlResized(null);
    }

    private void initColumnResizer() {
        this.columnResizer = new ControlAdapter(){
            private int clientWidth = 0;
            private int labelWidth = 0;
            private int recorderWidth = 0;
            private int synchronizerWidth = 0;
            private boolean resizing;

            public void controlResized(ControlEvent e) {
                boolean inputChanged;
                if (this.resizing) {
                    return;
                }
                Rectangle clientArea = SynchronizerDialog.this.tree.getClientArea();
                int clientWidth = clientArea.width - clientArea.x;
                int labelWidth = SynchronizerDialog.this.labelColumn.getWidth();
                int recorderWidth = SynchronizerDialog.this.localColumn == null ? 0 : SynchronizerDialog.this.localColumn.getWidth();
                int synchronizerWidth = SynchronizerDialog.this.remoteColumn == null ? 0 : SynchronizerDialog.this.remoteColumn.getWidth();
                boolean bl = inputChanged = e == null;
                if (inputChanged || clientWidth != this.clientWidth || labelWidth != this.labelWidth || recorderWidth != this.recorderWidth || synchronizerWidth != this.synchronizerWidth) {
                    try {
                        this.resizing = true;
                        SynchronizerDialog.this.tree.setRedraw(false);
                        TreeItem[] items = SynchronizerDialog.this.tree.getItems();
                        if (items.length == 0) {
                            recorderWidth = clientWidth / 2;
                            SynchronizerDialog.this.labelColumn.setWidth(clientWidth - recorderWidth - synchronizerWidth);
                            if (SynchronizerDialog.this.localColumn != null) {
                                SynchronizerDialog.this.localColumn.setWidth(recorderWidth);
                            }
                            if (SynchronizerDialog.this.remoteColumn != null) {
                                SynchronizerDialog.this.remoteColumn.setWidth(synchronizerWidth);
                            }
                        } else {
                            if (SynchronizerDialog.this.localColumn != null) {
                                SynchronizerDialog.this.localColumn.pack();
                                recorderWidth = SynchronizerDialog.this.localColumn.getWidth() + 10;
                                SynchronizerDialog.this.localColumn.setWidth(recorderWidth);
                            }
                            if (SynchronizerDialog.this.remoteColumn != null) {
                                SynchronizerDialog.this.remoteColumn.pack();
                                synchronizerWidth = SynchronizerDialog.this.remoteColumn.getWidth() + 10;
                                SynchronizerDialog.this.remoteColumn.setWidth(synchronizerWidth);
                            }
                            labelWidth = clientWidth - recorderWidth - synchronizerWidth;
                            SynchronizerDialog.this.labelColumn.setWidth(labelWidth);
                        }
                    }
                    finally {
                        this.clientWidth = clientWidth;
                        this.labelWidth = labelWidth;
                        this.recorderWidth = recorderWidth;
                        this.synchronizerWidth = synchronizerWidth;
                        SynchronizerDialog.this.tree.setRedraw(true);
                        this.resizing = false;
                    }
                }
            }
        };
        this.tree.addControlListener((ControlListener)this.columnResizer);
        this.labelColumn.addControlListener((ControlListener)this.columnResizer);
        if (this.localColumn != null) {
            this.localColumn.addControlListener((ControlListener)this.columnResizer);
        }
    }

    private void populateTree() {
        HashMap<String, Set<SetupTask>> tasks = new HashMap<String, Set<SetupTask>>();
        HashMap<SetupTask, String> labels = new HashMap<SetupTask, String>();
        HashMap<SetupTask, Image> images = new HashMap<SetupTask, Image>();
        if (this.mode.isRecord()) {
            HashMap compounds = new HashMap();
            Map<String, Boolean> policies = this.recorderTransaction.getPolicies(false);
            for (Map.Entry<URI, String> entry : this.recorderValues.entrySet()) {
                URI uri = entry.getKey();
                String key = PreferencesFactory.eINSTANCE.convertURI(uri);
                if (!policies.containsKey(key)) continue;
                String pluginID = uri.segment(0);
                String value = entry.getValue();
                PreferenceTask task = SetupFactory.eINSTANCE.createPreferenceTask();
                task.setKey(key);
                task.setValue(value);
                CollectionUtil.add(tasks, (Object)pluginID, (Object)task);
                CompoundTask compound = (CompoundTask)compounds.get(pluginID);
                if (compound == null) {
                    compound = SetupFactory.eINSTANCE.createCompoundTask(pluginID);
                }
                compound.getSetupTasks().add((Object)task);
                ItemProviderAdapter itemProvider = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)task, IItemLabelProvider.class);
                labels.put((SetupTask)task, SetupLabelProvider.getText(itemProvider, (EObject)task));
                images.put((SetupTask)task, SetupUIPlugin.INSTANCE.getSWTImage(SetupLabelProvider.getImageDescriptor(itemProvider, (EObject)task)));
            }
            if (this.mode.isSync()) {
                this.synchronizeLocal(false);
            }
        }
        this.populateTree(tasks, labels, images);
    }

    private void populateTree(Map<String, Set<SetupTask>> tasks, final Map<SetupTask, String> labels, Map<SetupTask, Image> images) {
        ArrayList<String> nodes = new ArrayList<String>(tasks.keySet());
        Collections.sort(nodes);
        Comparator<SetupTask> comparator = new Comparator<SetupTask>(){

            @Override
            public int compare(SetupTask t1, SetupTask t2) {
                String l1 = (String)labels.get(t1);
                String l2 = (String)labels.get(t2);
                return l1.compareTo(l2);
            }
        };
        for (String node : nodes) {
            NodeItem nodeItem = new NodeItem(this.tree, this.adapterFactory, node);
            ArrayList list = new ArrayList(tasks.get(node));
            Collections.sort(list, comparator);
            for (SetupTask task : list) {
                Choice[] choices;
                Image image = images.get(task);
                String text = labels.get(task);
                TaskItem taskItem = new TaskItem(nodeItem, task, false, image, text);
                this.taskItems.put(task, taskItem);
                if (this.localColumnManager != null) {
                    choices = this.localColumnManager.getChoices(taskItem);
                    taskItem.setLocalChoice(choices[0]);
                }
                if (this.remoteColumnManager == null) continue;
                choices = this.remoteColumnManager.getChoices(taskItem);
                taskItem.setRemoteChoice(choices[0]);
            }
            nodeItem.setExpanded(true);
        }
    }

    private void synchronizeLocal(boolean resynchronize) {
        try {
            if (resynchronize) {
                Synchronizer synchronizer = this.synchronization.getSynchronizer();
                Snapshot localSnapshot = synchronizer.getLocalSnapshot();
                SyncUtil.deleteFile((File)localSnapshot.getNewFile());
                RecorderManager.copyRecorderTarget(this.recorderTarget, localSnapshot.getFolder());
            }
            this.synchronization.synchronizeLocal();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static String getTitle(RecorderTransaction recorderTransaction) {
        return recorderTransaction != null ? "Preference Recorder" : "Preference Synchronizer";
    }

    private static abstract class Choice {
        private final Image image;
        private final Image imageDisabled;
        private final String text;

        public Choice(Image image, String text) {
            this.image = image;
            this.text = text;
            this.imageDisabled = new Image(image.getDevice(), image, 1);
        }

        public Image getImage() {
            return this.image;
        }

        public String getText() {
            return this.text;
        }

        public int paintItem(GC gc, int x, int y, TaskItem taskItem) {
            boolean enabled = taskItem.getParent().isEnabled();
            gc.drawImage(enabled ? this.image : this.imageDisabled, x, y);
            return x + 16 + 5;
        }

        public boolean isRecord() {
            return false;
        }

        public boolean hasTarget() {
            return this.isRecord();
        }

        private static final class RecordAlways
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Right");

            public RecordAlways(String targetText) {
                super(IMAGE, "Always record into " + targetText);
            }

            public boolean isRecord() {
                return true;
            }
        }

        private static final class RecordNever
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Exclude");

            public RecordNever(String targetText) {
                super(IMAGE, "Never record into " + targetText);
            }
        }

        private static final class RecordSkip
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Skip");

            public RecordSkip() {
                super(IMAGE, "Skip this time");
            }
        }

        private static final class SyncAlways
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Right");

            public SyncAlways(String serviceLabel) {
                super(IMAGE, "Always synchronize with " + serviceLabel);
            }

            public boolean hasTarget() {
                return true;
            }
        }

        private static final class SyncConflict
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Conflict");

            public SyncConflict(String serviceLabel) {
                super(IMAGE, "Conflict between local and " + serviceLabel + " values");
            }

            public boolean hasTarget() {
                return true;
            }
        }

        private static final class SyncLocal
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Right");

            public SyncLocal() {
                super(IMAGE, "Resolve with local value");
            }

            public boolean hasTarget() {
                return true;
            }
        }

        private static final class SyncNever
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Exclude");

            public SyncNever(String serviceLabel) {
                super(IMAGE, "Never synchronize with " + serviceLabel);
            }
        }

        private static final class SyncRemote
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Left");

            public SyncRemote(String serviceLabel) {
                super(IMAGE, "Resolve with " + serviceLabel + " value");
            }

            public boolean hasTarget() {
                return true;
            }
        }

        private static final class SyncSkip
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Skip");

            public SyncSkip() {
                super(IMAGE, "Skip this time");
            }
        }
    }

    private static abstract class ColumnManager {
        protected static final Image CHEVRON_IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Chevron");
        protected static final Image CHEVRON_IMAGE_DISABLED = new Image(CHEVRON_IMAGE.getDevice(), CHEVRON_IMAGE, 1);
        private static final int CHEVRON_WIDTH = ColumnManager.CHEVRON_IMAGE.getBounds().width;
        private static final int WIDTH = 52 + CHEVRON_WIDTH + 10;
        private static final int HEIGHT = 18;
        private final SynchronizerDialog dialog;
        private final Image targetImage;
        private final Image targetImageDisabled;

        public ColumnManager(SynchronizerDialog dialog, Image targetImage) {
            this.dialog = dialog;
            this.targetImage = targetImage;
            this.targetImageDisabled = new Image(targetImage.getDevice(), targetImage, 1);
        }

        public SynchronizerDialog getDialog() {
            return this.dialog;
        }

        public abstract Choice[] getChoices(TaskItem var1);

        public abstract Choice getChoice(TaskItem var1);

        public abstract void setChoice(TaskItem var1, Choice var2);

        public void measureItem(Event event) {
            if (event.item instanceof TaskItem) {
                event.width = Math.max(event.width, WIDTH);
                event.height = Math.max(event.height, 18);
            }
        }

        public void paintItem(Event event) {
            if (event.item instanceof TaskItem) {
                TaskItem taskItem = (TaskItem)event.item;
                int x = event.x + event.width + 10;
                int y = event.y + 1;
                GC gc = event.gc;
                Choice choice = this.getChoice(taskItem);
                x = choice.paintItem(gc, x, y, taskItem);
                boolean enabled = taskItem.getParent().isEnabled();
                gc.drawImage(enabled && choice.hasTarget() ? this.targetImage : this.targetImageDisabled, x, y);
                gc.drawImage(enabled ? CHEVRON_IMAGE : CHEVRON_IMAGE_DISABLED, x + 16 + 5, y);
            }
        }

        public boolean handleClick(final TaskItem taskItem, boolean close, final int column, Rectangle itemBounds, Point eventPoint, Point point) {
            final Tree tree = taskItem.getParent();
            Menu menu = tree.getMenu();
            if (menu != null) {
                menu.dispose();
            }
            if (close) {
                return false;
            }
            menu = new Menu((Control)tree);
            Choice[] choiceArray = this.getChoices(taskItem);
            int n = choiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Choice choice = choiceArray[n2];
                if (!(choice instanceof Choice.SyncConflict)) {
                    MenuItem menuItem = new MenuItem(menu, 8);
                    menuItem.setImage(choice.getImage());
                    menuItem.setText(choice.getText());
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ColumnManager.this.handleMenu(taskItem, column, choice, tree);
                        }
                    });
                }
                ++n2;
            }
            Point location = tree.toDisplay(itemBounds.x, itemBounds.y);
            location.x += 4;
            location.y += itemBounds.height;
            menu.setLocation(location);
            menu.setVisible(true);
            return true;
        }

        public void handleMenu(TaskItem taskItem, int column, Choice choice, Tree tree) {
            this.dialog.mouseHandler.reset();
            this.setChoice(taskItem, choice);
            Rectangle bounds = taskItem.getBounds(column);
            tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    private static final class LocalColumnManager
    extends ColumnManager {
        private final Choice[] choices = new Choice[3];

        public LocalColumnManager(SynchronizerDialog dialog) {
            super(dialog, dialog.recorderTargetImage);
            this.choices[0] = new Choice.RecordAlways(dialog.recorderTargetText);
            this.choices[1] = new Choice.RecordNever(dialog.recorderTargetText);
            this.choices[2] = new Choice.RecordSkip();
        }

        public Choice[] getChoices(TaskItem taskItem) {
            return this.choices;
        }

        public Choice getChoice(TaskItem taskItem) {
            return taskItem.getLocalChoice();
        }

        public void setChoice(TaskItem taskItem, Choice choice) {
            taskItem.setLocalChoice(choice);
            PreferenceTask task = (PreferenceTask)taskItem.getTask();
            String key = task.getKey();
            URI uri = PreferencesFactory.eINSTANCE.createURI(key);
            SynchronizerDialog dialog = this.getDialog();
            RecorderTransaction transaction = dialog.recorderTransaction;
            if (choice instanceof Choice.RecordAlways) {
                transaction.setPolicy(key, true);
                dialog.recorderValuesToRemove.remove(uri);
            } else if (choice instanceof Choice.RecordNever) {
                transaction.setPolicy(key, false);
                dialog.recorderValuesToRemove.remove(uri);
            } else if (choice instanceof Choice.RecordSkip) {
                transaction.removePolicy(key);
                dialog.recorderValuesToRemove.add(uri);
            }
        }

        public void handleMenu(TaskItem taskItem, int column, Choice choice, Tree tree) {
            super.handleMenu(taskItem, column, choice, tree);
            int nextColumn = column + 1;
            if (nextColumn < tree.getColumnCount()) {
                SynchronizerDialog dialog = this.getDialog();
                dialog.synchronizeLocal(true);
                Rectangle bounds = taskItem.getBounds(nextColumn);
                tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        RECORD_AND_SYNC(true, true),
        RECORD(true, false),
        SYNC(false, true);

        private final boolean record;
        private final boolean sync;

        private Mode(boolean record, boolean sync) {
            this.record = record;
            this.sync = sync;
        }

        public boolean isRecord() {
            return this.record;
        }

        public boolean isSync() {
            return this.sync;
        }
    }

    private final class MouseHandler
    implements Listener {
        private boolean lastOpen;
        private TaskItem lastTaskItem;
        private int lastColumn;

        private MouseHandler() {
        }

        public void reset() {
            this.lastOpen = false;
            this.lastTaskItem = null;
            this.lastColumn = 0;
        }

        public void handleEvent(Event event) {
            Point eventPoint = new Point(event.x, event.y);
            TreeItem treeItem = SynchronizerDialog.this.tree.getItem(eventPoint);
            if (treeItem instanceof TaskItem) {
                TaskItem taskItem = (TaskItem)treeItem;
                int columns = SynchronizerDialog.this.tree.getColumnCount();
                int column = 1;
                while (column < columns) {
                    Rectangle itemBounds = taskItem.getBounds(column);
                    if (itemBounds.contains(eventPoint)) {
                        int x = eventPoint.x - itemBounds.x;
                        int y = eventPoint.y - itemBounds.y;
                        boolean close = this.lastOpen && taskItem == this.lastTaskItem && column == this.lastColumn;
                        this.lastOpen = this.handleClick(taskItem, close, column, itemBounds, eventPoint, new Point(x, y));
                        this.lastTaskItem = taskItem;
                        this.lastColumn = column;
                        return;
                    }
                    ++column;
                }
            }
            this.reset();
        }

        private boolean handleClick(TaskItem taskItem, boolean close, int column, Rectangle itemBounds, Point eventPoint, Point point) {
            ColumnManager manager = SynchronizerDialog.this.getColumnManager(column);
            if (manager != null) {
                return manager.handleClick(taskItem, close, column, itemBounds, eventPoint, point);
            }
            return false;
        }
    }

    private static final class NodeItem
    extends TreeItem {
        private static Image compoundImage;

        public NodeItem(Tree tree, ComposedAdapterFactory adapterFactory, String text) {
            super(tree, 0);
            if (compoundImage == null) {
                CompoundTask compoundTask = SetupFactory.eINSTANCE.createCompoundTask();
                ItemProviderAdapter compoundItemProvider = (ItemProviderAdapter)adapterFactory.adapt((Notifier)compoundTask, IItemLabelProvider.class);
                compoundImage = SetupUIPlugin.INSTANCE.getSWTImage(SetupLabelProvider.getImageDescriptor(compoundItemProvider, (EObject)compoundTask));
            }
            this.setImage(compoundImage);
            this.setText(text);
        }

        protected void checkSubclass() {
        }
    }

    private final class PaintHandler
    implements Listener {
        private PaintHandler() {
        }

        public void handleEvent(Event event) {
            ColumnManager manager = SynchronizerDialog.this.getColumnManager(event.index);
            if (manager != null) {
                switch (event.type) {
                    case 41: {
                        manager.measureItem(event);
                        break;
                    }
                    case 42: {
                        manager.paintItem(event);
                    }
                }
            }
        }
    }

    private static final class RemoteColumnManager
    extends ColumnManager {
        private static final Image TARGET_IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Remote");
        private final Choice[] normalChoices = new Choice[3];
        private final Choice[] conflictChoices = new Choice[5];

        public RemoteColumnManager(SynchronizerDialog dialog, String serviceLabel) {
            super(dialog, TARGET_IMAGE);
            this.normalChoices[0] = new Choice.SyncAlways(serviceLabel);
            this.normalChoices[1] = new Choice.SyncNever(serviceLabel);
            this.normalChoices[2] = new Choice.SyncSkip();
            this.conflictChoices[0] = new Choice.SyncConflict(serviceLabel);
            this.conflictChoices[1] = new Choice.SyncLocal();
            this.conflictChoices[2] = new Choice.SyncRemote(serviceLabel);
            this.conflictChoices[3] = new Choice.SyncNever(serviceLabel);
            this.conflictChoices[4] = new Choice.SyncSkip();
        }

        public Choice[] getChoices(TaskItem taskItem) {
            return taskItem.isConflict() ? this.conflictChoices : this.normalChoices;
        }

        public Choice getChoice(TaskItem taskItem) {
            return taskItem.getRemoteChoice();
        }

        public void setChoice(TaskItem taskItem, Choice choice) {
            taskItem.setRemoteChoice(choice);
        }

        public void measureItem(Event event) {
            if (this.isApplicable(event.item)) {
                super.measureItem(event);
            }
        }

        public void paintItem(Event event) {
            if (this.isApplicable(event.item)) {
                super.paintItem(event);
            }
        }

        public boolean handleClick(TaskItem taskItem, boolean close, int column, Rectangle itemBounds, Point eventPoint, Point point) {
            if (this.isApplicable((Widget)taskItem)) {
                return super.handleClick(taskItem, close, column, itemBounds, eventPoint, point);
            }
            return false;
        }

        private boolean isApplicable(Widget item) {
            TaskItem taskItem;
            Choice localChoice;
            return !(item instanceof TaskItem) || (localChoice = (taskItem = (TaskItem)item).getLocalChoice()) == null || localChoice.isRecord();
        }
    }

    private static final class TaskItem
    extends TreeItem {
        private final SetupTask task;
        private final boolean conflict;
        private Choice localChoice;
        private Choice remoteChoice;

        public TaskItem(NodeItem nodeItem, SetupTask task, boolean conflict, Image image, String text) {
            super((TreeItem)nodeItem, 0);
            this.task = task;
            this.conflict = conflict;
            this.setImage(image);
            this.setText(text);
        }

        public SetupTask getTask() {
            return this.task;
        }

        public boolean isConflict() {
            return this.conflict;
        }

        public Choice getLocalChoice() {
            return this.localChoice;
        }

        public void setLocalChoice(Choice choice) {
            this.localChoice = choice;
        }

        public Choice getRemoteChoice() {
            return this.remoteChoice;
        }

        public void setRemoteChoice(Choice choice) {
            this.remoteChoice = choice;
        }

        protected void checkSubclass() {
        }
    }
}

