/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.FieldCategory;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.Util;

public class TypeMarkerGroup
extends MarkerGroup {
    private Map<String, TypesMarkerGroupingEntry> entries = new HashMap<String, TypesMarkerGroupingEntry>();
    private String name;

    public TypeMarkerGroup(String name) {
        super(null);
        this.name = name;
    }

    @Override
    protected void createFields() {
        this.field = new FieldCategory();
        this.markerField = new TypeMarkerField();
    }

    @Override
    public MarkerGroupingEntry findGroupValue(String typeId, IMarker marker) {
        TypesMarkerGroupingEntry entry = this.entries.get(typeId);
        if (entry == null) {
            String groupName = MarkerSupportRegistry.getInstance().getCategory(marker);
            if (groupName == null) {
                MarkerType mkType = MarkerTypesModel.getInstance().getType(typeId);
                groupName = mkType.getLabel();
            }
            entry = new TypesMarkerGroupingEntry(groupName);
            entry.setGroup(this);
            this.entries.put(typeId, entry);
        }
        return entry;
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.ide.type";
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public Comparator<MarkerGroupingEntry> getEntriesComparator() {
        return new Comparator<MarkerGroupingEntry>(){

            @Override
            public int compare(MarkerGroupingEntry o1, MarkerGroupingEntry o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        };
    }

    class TypeMarkerField
    extends MarkerGroup.GroupMarkerField {
        TypeMarkerField() {
            super(TypeMarkerGroup.this);
        }

        @Override
        public String getValue(MarkerItem item) {
            if (item.getMarker() != null) {
                IMarker marker = item.getMarker();
                if (marker == null || !marker.exists()) {
                    return MarkerMessages.FieldCategory_Uncategorized;
                }
                String groupName = MarkerSupportRegistry.getInstance().getCategory(marker);
                if (groupName == null) {
                    String typeId;
                    try {
                        typeId = marker.getType();
                    }
                    catch (CoreException e) {
                        Policy.handle(e);
                        return MarkerMessages.FieldCategory_Uncategorized;
                    }
                    MarkerType type = MarkerTypesModel.getInstance().getType(typeId);
                    groupName = type.getLabel();
                }
                return groupName;
            }
            return Util.EMPTY_STRING;
        }

        @Override
        public int compare(MarkerItem item1, MarkerItem item2) {
            return this.getValue(item1).compareTo(this.getValue(item2));
        }
    }

    private class TypesMarkerGroupingEntry
    extends MarkerGroupingEntry {
        public TypesMarkerGroupingEntry(String label) {
            super(label);
        }
    }
}

