/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.NAry;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;

final class Or
extends NAry {
    public Or(Expression[] operands) {
        super(Or.assertLength(operands, 2, "||"));
    }

    @Override
    public Object evaluate(IEvaluationContext context) {
        Expression[] expressionArray = this.operands;
        int n = this.operands.length;
        int n2 = 0;
        while (n2 < n) {
            Expression operand = expressionArray[n2];
            if (operand.evaluate(context) == Boolean.TRUE) {
                return Boolean.TRUE;
            }
            ++n2;
        }
        return Boolean.FALSE;
    }

    @Override
    public int getExpressionType() {
        return 16;
    }

    @Override
    public String getOperator() {
        return "||";
    }

    @Override
    public int getPriority() {
        return 8;
    }

    @Override
    public void toLDAPString(StringBuffer buf) {
        buf.append("(|");
        Expression[] expressionArray = this.operands;
        int n = this.operands.length;
        int n2 = 0;
        while (n2 < n) {
            Expression operand = expressionArray[n2];
            operand.toLDAPString(buf);
            ++n2;
        }
        buf.append(')');
    }
}

