/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;

public class SetupArchiver
implements IApplication {
    public Object start(IApplicationContext context) {
        long finalLastModified;
        URI outputLocation;
        File temp;
        long lastModified;
        HashSet<String> entryNames;
        File file;
        block47: {
            String[] arguments = (String[])context.getArguments().get("application.args");
            file = new File(System.getProperty("java.io.tmpdir"), "setups.zip");
            int i = 0;
            while (i < arguments.length) {
                if ("-target".equals(arguments[i])) {
                    file = new File(arguments[++i]);
                }
                ++i;
            }
            entryNames = new HashSet<String>();
            lastModified = file.lastModified();
            temp = new File(String.valueOf(file.toString()) + ".tmp");
            if (lastModified == 0L) {
                outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/"));
            } else {
                IOUtil.copyFile((File)file, (File)temp);
                if (!temp.setLastModified(lastModified)) {
                    throw new IORuntimeException("Could not set timestamp of " + temp);
                }
                outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)temp.toString()) + "!/"));
                ZipFile zipFile = null;
                try {
                    try {
                        zipFile = new ZipFile(temp);
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry zipEntry = entries.nextElement();
                            String name = zipEntry.getName();
                            entryNames.add(name);
                            URI path = URI.createURI((String)name);
                            URI uri = URI.createURI((String)(String.valueOf(path.segment(0)) + ":" + "//" + path.segment(1)));
                            int i2 = 2;
                            int length = path.segmentCount();
                            while (i2 < length) {
                                uri = uri.appendSegment(path.segment(i2));
                                ++i2;
                            }
                            URI archiveEntry = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/" + path));
                            System.out.println("Previously mirrored " + uri + " -> " + archiveEntry);
                        }
                    }
                    catch (IOException iOException) {
                        if (!file.delete()) {
                            throw new IORuntimeException("Could delete bad version of " + file);
                        }
                        lastModified = 0L;
                        outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/"));
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                            break block47;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        break block47;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        final ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
        SetupWizard.IndexLoader.ResourceMirrorWithProductImages resourceMirror = new SetupWizard.IndexLoader.ResourceMirrorWithProductImages(resourceSet){

            protected void visit(EObject eObject) {
                URI imageURI;
                EClass eClass;
                if (eObject instanceof EClass && !(eClass = (EClass)eObject).isAbstract() && (imageURI = EAnnotations.getImageURI((EClass)eClass)) != null && resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().containsKey(imageURI.fileExtension())) {
                    this.schedule(imageURI, true);
                }
                super.visit(eObject);
            }
        };
        resourceMirror.perform((Object)SetupContext.INDEX_SETUP_URI);
        resourceMirror.dispose();
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        ECFURIHandlerImpl.clearExpectedETags();
        URIConverter uriConverter = resourceSet.getURIConverter();
        Map uriMap = uriConverter.getURIMap();
        HashMap<String, String> options = new HashMap<String, String>();
        if (lastModified != 0L) {
            options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        }
        uriMap.remove(SetupContext.INDEX_SETUP_LOCATION_URI.trimSegments(1).appendSegment(""));
        boolean hasFailures = false;
        for (Resource resource : resourceSet.getResources()) {
            URI uri = resource.getURI();
            URI normalizedURI = uriConverter.normalize(uri);
            String scheme = normalizedURI.scheme();
            if (normalizedURI.query() == null && ("http".equals(scheme) || "https".equals(scheme))) {
                URI path = URI.createURI((String)scheme);
                path = path.appendSegment(normalizedURI.authority());
                path = path.appendSegments(normalizedURI.segments());
                System.out.println("Mirroring " + normalizedURI);
                URI output = path.resolve(outputLocation);
                entryNames.remove(path.toString());
                uriMap.put(uri, output);
                if (resource.getContents().isEmpty()) {
                    System.err.println("Failed to load " + normalizedURI);
                    hasFailures = true;
                    continue;
                }
                try {
                    long before = resource.getTimeStamp();
                    resource.save(options);
                    long after = resource.getTimeStamp();
                    if (after - before <= 0L) continue;
                    System.err.println("changed! " + normalizedURI);
                }
                catch (IOException ex) {
                    System.err.println("Failed to save " + normalizedURI);
                    ex.printStackTrace();
                }
                continue;
            }
            System.out.println("Ignoring  " + normalizedURI);
        }
        if (hasFailures) {
            System.err.println("There were failures so no entries will be deleted from the archive");
        } else {
            for (String entryName : entryNames) {
                URI archiveEntry = URI.createURI((String)(outputLocation + entryName));
                try {
                    uriConverter.delete(archiveEntry, null);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        long l = finalLastModified = lastModified == 0L ? file.lastModified() : temp.lastModified();
        if (lastModified != finalLastModified) {
            if (OS.INSTANCE.isWin() && lastModified != 0L && !file.delete()) {
                System.err.println("Could not delete " + file);
            }
            if (lastModified == 0L) {
                if (this.isDamaged(file)) {
                    System.err.println("The resulting archive is damaged. Deleting " + file);
                    file.delete();
                } else {
                    System.out.println("Successfully created " + file);
                }
            } else if (this.isDamaged(temp)) {
                System.err.println("The resulting archive is damaged so the old one will be retained. Deleting " + file);
                temp.delete();
            } else {
                File backup = new File(file.getParentFile(), String.valueOf(file.getName()) + ".bak");
                try {
                    IOUtil.copyFile((File)temp, (File)backup);
                }
                catch (Throwable throwable) {
                    System.err.println("Could not create backup " + backup);
                }
                if (temp.renameTo(file)) {
                    System.out.println("Successful updates for " + file);
                } else {
                    System.err.println("Could not rename " + temp + " to " + file);
                }
            }
        } else {
            System.out.println("No updates for " + file);
            if (!temp.delete()) {
                System.err.println("Could not delete " + temp);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean isDamaged(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
    }
}

