/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerElementImpl;
import org.eclipse.oomph.p2.internal.core.PersistentMap;
import org.eclipse.oomph.p2.internal.core.ProfileTransactionImpl;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileImpl
extends AgentManagerElementImpl
implements Profile,
PersistentMap.ExtraInfoProvider {
    private static final Method INTERNAL_GET_PROFILE_METHOD;
    private static final Map<Object, Object> XML_OPTIONS;
    private final Agent agent;
    private final BundlePool bundlePool;
    private final String id;
    private final String type;
    private final File installFolder;
    private final File referencer;
    private IProfile delegate;
    private ProfileDefinition definition;

    static {
        Method method = null;
        try {
            method = ReflectUtil.getMethod(SimpleProfileRegistry.class, (String)"internalGetProfile", (Class[])new Class[]{String.class});
        }
        catch (Throwable throwable) {}
        if (method != null) {
            INTERNAL_GET_PROFILE_METHOD = method;
            INTERNAL_GET_PROFILE_METHOD.setAccessible(true);
        } else {
            INTERNAL_GET_PROFILE_METHOD = null;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("DECLARE_XML", Boolean.FALSE);
        options.put("EXTENDED_META_DATA", new BasicExtendedMetaData(){

            public EStructuralFeature getElement(EClass eClass, String namespace, String name) {
                EStructuralFeature eStructuralFeature = super.getElement(eClass, namespace, name);
                if (eStructuralFeature == null) {
                    eStructuralFeature = super.getElement(eClass, namespace, name.substring(0, name.length() - 1));
                }
                if (eStructuralFeature == null) {
                    eStructuralFeature = eClass.getEStructuralFeature(name);
                }
                return eStructuralFeature;
            }

            protected boolean isFeatureKindSpecific() {
                return false;
            }
        });
        XML_OPTIONS = Collections.unmodifiableMap(options);
    }

    public ProfileImpl(Agent agent, BundlePool bundlePool, String id, String type, File installFolder, File referencer) {
        this.agent = agent;
        this.bundlePool = bundlePool;
        this.id = id;
        this.type = type;
        this.installFolder = installFolder;
        this.referencer = referencer;
    }

    @Override
    public String getElementType() {
        return "profile";
    }

    @Override
    public AgentManager getAgentManager() {
        return this.agent.getAgentManager();
    }

    @Override
    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public BundlePool getBundlePool() {
        return this.bundlePool;
    }

    public String getProfileId() {
        return this.id;
    }

    @Override
    public boolean isSelfHosting() {
        return "SelfHostingProfile".equals(this.id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public File getLocation() {
        File engineLocation = new File(this.agent.getLocation(), "org.eclipse.equinox.p2.engine");
        File registryLocation = new File(engineLocation, "profileRegistry");
        return new File(registryLocation, String.valueOf(this.id) + ".profile");
    }

    @Override
    public File getInstallFolder() {
        return this.installFolder;
    }

    public File getReferencer() {
        return this.referencer;
    }

    @Override
    public String getExtraInfo() {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(this.type);
        tokens.add(this.bundlePool != null ? this.bundlePool.getLocation().getAbsolutePath() : "");
        tokens.add(this.installFolder != null ? this.installFolder.getAbsolutePath() : "");
        tokens.add(this.referencer != null ? this.referencer.getAbsolutePath() : "");
        return StringUtil.implode(tokens, (char)'|');
    }

    public synchronized IProfile getDelegate() {
        return this.getDelegate(true);
    }

    public synchronized IProfile getDelegate(boolean loadOnDemand) {
        IProfileRegistry profileRegistry = null;
        if (this.delegate == null && loadOnDemand) {
            profileRegistry = this.getAgent().getProfileRegistry();
            this.doSetDelegate(profileRegistry);
        }
        if (this.delegate != null) {
            if (profileRegistry == null) {
                profileRegistry = this.getAgent().getProfileRegistry();
            }
            IProfile internalProfile = null;
            if (INTERNAL_GET_PROFILE_METHOD != null) {
                try {
                    internalProfile = (IProfile)INTERNAL_GET_PROFILE_METHOD.invoke((Object)profileRegistry, this.id);
                }
                catch (Throwable throwable) {}
            }
            if (internalProfile == null) {
                internalProfile = this.getProfileSafe(profileRegistry);
            }
            if (this.delegate.getTimestamp() != internalProfile.getTimestamp()) {
                this.doSetDelegate(profileRegistry);
            }
        }
        return this.delegate;
    }

    private void doSetDelegate(IProfileRegistry profileRegistry) {
        this.delegate = this.getProfileSafe(profileRegistry);
    }

    private IProfile getProfileSafe(IProfileRegistry profileRegistry) {
        IProfile profile = profileRegistry.getProfile(this.id);
        if (profile == null) {
            throw new P2Exception("Profile does not exist: " + this.id);
        }
        return profile;
    }

    public void setDelegate(IProfile delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized ProfileDefinition getDefinition() {
        if (this.definition == null) {
            String xml = this.getDelegate().getProperty("org.eclipse.oomph.p2.profile.definition");
            this.definition = xml == null ? ProfileImpl.definitionFromRootIUs(this, VersionSegment.MINOR) : ProfileImpl.definitionFromXML(xml);
        }
        return this.definition;
    }

    public void setDefinition(ProfileDefinition definition) {
        this.definition = definition;
    }

    @Override
    public boolean isValid() {
        return this.getLocation().isDirectory();
    }

    @Override
    public boolean isCurrent() {
        return this.agent.getCurrentProfile() == this;
    }

    @Override
    public boolean isUsed() {
        String workspace;
        File referencer = this.referencer;
        if (referencer == null && "Targlet".equals(this.type) && (workspace = this.getProperty("targlet.container.workspace")) != null) {
            referencer = new File(workspace, ".metadata/.plugins/org.eclipse.oomph.targlets.core/profiles.txt");
        }
        if (referencer != null) {
            List lines;
            if (!referencer.exists()) {
                return false;
            }
            return !referencer.isFile() || (lines = IOUtil.readLines((File)referencer, null)).contains(this.id);
        }
        return this.installFolder == null || this.installFolder.isDirectory();
    }

    @Override
    protected void doDelete() {
        ((AgentImpl)this.agent).deleteProfile(this);
    }

    @Override
    public ProfileTransaction change() {
        return new ProfileTransactionImpl(this);
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return this.getDelegate().query(query, monitor);
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.getDelegate().getProvisioningAgent();
    }

    public String getProperty(String key) {
        return this.getDelegate().getProperty(key);
    }

    public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
        return this.getDelegate().getInstallableUnitProperty(iu, key);
    }

    public Map<String, String> getProperties() {
        return this.getDelegate().getProperties();
    }

    public Map<String, String> getInstallableUnitProperties(IInstallableUnit iu) {
        return this.getDelegate().getInstallableUnitProperties(iu);
    }

    public long getTimestamp() {
        return this.getDelegate().getTimestamp();
    }

    public IQueryResult<IInstallableUnit> available(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return this.getDelegate().available(query, monitor);
    }

    public String toString() {
        return this.id;
    }

    public static String definitionToXML(ProfileDefinition definition) {
        try {
            StringWriter writer = new StringWriter();
            XMLResourceImpl resource = new XMLResourceImpl();
            resource.getContents().add((Object)definition);
            resource.save((Writer)writer, XML_OPTIONS);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new P2Exception((Throwable)ex);
        }
    }

    public static ProfileDefinition definitionFromXML(String xml) {
        try {
            XMLResourceImpl resource = new XMLResourceImpl();
            resource.load(new InputSource(new StringReader(xml)), XML_OPTIONS);
            return (ProfileDefinition)resource.getContents().get(0);
        }
        catch (IOException ex) {
            throw new P2Exception((Throwable)ex);
        }
    }

    public static ProfileDefinition definitionFromRootIUs(Profile profile, VersionSegment compatibility) {
        ProfileDefinition definition = P2Factory.eINSTANCE.createProfileDefinition();
        EList requirements = definition.getRequirements();
        IQueryResult query = profile.query(QueryUtil.createIUAnyQuery(), null);
        for (IInstallableUnit iu : P2Util.asIterable(query)) {
            if (!"true".equals(profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.root"))) continue;
            VersionSegment iuCompatibility = null;
            String iuProperty = profile.getInstallableUnitProperty(iu, "org.eclipse.oomph.p2.iu.compatibility");
            if (iuProperty != null) {
                iuCompatibility = VersionSegment.get((String)iuProperty);
            }
            if (iuCompatibility == null && (iuProperty = iu.getProperty("org.eclipse.oomph.p2.iu.compatibility")) != null) {
                iuCompatibility = VersionSegment.get((String)iuProperty);
            }
            if (iuCompatibility == null) {
                iuCompatibility = compatibility;
            }
            VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(iu.getVersion(), iuCompatibility);
            Requirement requirement = P2Factory.eINSTANCE.createRequirement(iu.getId());
            requirement.setVersionRange(versionRange);
            requirement.setMatchExpression(iu.getFilter());
            requirements.add((Object)requirement);
        }
        IMetadataRepositoryManager metadataRepositoryManager = profile.getAgent().getMetadataRepositoryManager();
        URI[] knownRepositories = metadataRepositoryManager.getKnownRepositories(2);
        if (knownRepositories.length > 0) {
            EList repositories = definition.getRepositories();
            URI[] uRIArray = knownRepositories;
            int n = knownRepositories.length;
            int n2 = 0;
            while (n2 < n) {
                URI knownRepository = uRIArray[n2];
                if (metadataRepositoryManager.isEnabled(knownRepository)) {
                    File file;
                    if (URIUtil.isFileURI((URI)knownRepository) && !(file = URIUtil.toFile((URI)knownRepository)).isDirectory()) {
                        metadataRepositoryManager.setEnabled(knownRepository, false);
                    } else {
                        Repository repository = P2Factory.eINSTANCE.createRepository(knownRepository.toString());
                        repositories.add((Object)repository);
                    }
                }
                ++n2;
            }
        }
        return definition;
    }
}

