/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ProgressBarDrawData
extends RangeDrawData {
    public ProgressBarDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gc, Rectangle bounds) {
        long progressHandle = theme.progressHandle;
        long gtkStyle = this.gtk_widget_get_style(progressHandle);
        long drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        byte[] detail = Converter.wcsToMbcs(null, "trough", true);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        this.gtk_render_box(gtkStyle, drawable, this.getStateType(0), 1, null, progressHandle, detail, x, y, width, height);
        int xthichness = OS.gtk_style_get_xthickness(gtkStyle);
        int ythichness = OS.gtk_style_get_ythickness(gtkStyle);
        if ((this.style & 0x200) != 0) {
            this.gtk_orientable_set_orientation(progressHandle, 2);
            x += xthichness;
            width -= xthichness * 2;
            height -= ythichness * 2;
            height = (int)((float)height * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
            y += bounds.height - ythichness - height;
        } else {
            this.gtk_orientable_set_orientation(progressHandle, 0);
            x += xthichness;
            y += ythichness;
            width -= xthichness * 2;
            height -= ythichness * 2;
            width = (int)((float)width * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
        }
        detail = Converter.wcsToMbcs(null, "bar", true);
        this.gtk_render_box(gtkStyle, drawable, 2, 2, null, progressHandle, detail, x, y, width, height);
    }

    @Override
    int getStateType(int part) {
        return 0;
    }

    @Override
    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }

    void gtk_orientable_set_orientation(long pbar, int orientation) {
        if (OS.GTK3) {
            switch (orientation) {
                case 2: {
                    OS.gtk_orientable_set_orientation(pbar, 1);
                    OS.gtk_progress_bar_set_inverted(pbar, true);
                    break;
                }
                case 0: {
                    OS.gtk_orientable_set_orientation(pbar, 0);
                    OS.gtk_progress_bar_set_inverted(pbar, false);
                }
            }
        } else {
            OS.gtk_progress_bar_set_orientation(pbar, orientation);
        }
    }
}

