/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class LazyResourceManager
extends ResourceManager {
    private final ResourceManager parent;
    private final LruMap unreferenced;
    private final Map<DeviceResourceDescriptor, Integer> refCount;

    public LazyResourceManager(int cacheSize, ResourceManager parent) {
        this.parent = parent;
        this.unreferenced = new LruMap(cacheSize);
        this.refCount = new HashMap<DeviceResourceDescriptor, Integer>();
    }

    @Override
    public Device getDevice() {
        return this.parent.getDevice();
    }

    private boolean shouldBeCached(DeviceResourceDescriptor descriptor) {
        return descriptor != null && descriptor.shouldBeCached();
    }

    @Override
    protected Image getDefaultImage() {
        return this.parent.getDefaultImage();
    }

    private static Integer createOrIncrease(DeviceResourceDescriptor key, Integer refs) {
        return refs == null ? 1 : refs + 1;
    }

    private static Integer decreaseOrRemove(DeviceResourceDescriptor key, Integer refs) {
        return refs == 1 ? null : Integer.valueOf(refs - 1);
    }

    @Override
    public Object create(DeviceResourceDescriptor descriptor) {
        if (!this.shouldBeCached(descriptor)) {
            return this.parent.create(descriptor);
        }
        int updatedRefs = this.refCount.compute(descriptor, LazyResourceManager::createOrIncrease);
        if (updatedRefs == 1) {
            ResourceManager cached = (ResourceManager)this.unreferenced.remove(descriptor);
            if (cached == null) {
                return this.parent.create(descriptor);
            }
        } else assert (!this.unreferenced.containsKey(descriptor));
        return this.parent.find(descriptor);
    }

    @Override
    public void destroy(DeviceResourceDescriptor descriptor) {
        if (!this.shouldBeCached(descriptor)) {
            this.parent.destroy(descriptor);
            return;
        }
        Integer refsLeft = this.refCount.computeIfPresent(descriptor, LazyResourceManager::decreaseOrRemove);
        if (refsLeft == null) {
            ResourceManager old = this.unreferenced.put(descriptor, this.parent);
            assert (old == null);
        }
    }

    @Override
    public Object find(DeviceResourceDescriptor descriptor) {
        if (!this.shouldBeCached(descriptor)) {
            return this.parent.find(descriptor);
        }
        if (this.refCount.containsKey(descriptor)) {
            return this.parent.find(descriptor);
        }
        return null;
    }

    private static class LruMap
    extends LinkedHashMap<DeviceResourceDescriptor, ResourceManager> {
        private static final long serialVersionUID = 1L;
        int cacheSize;

        LruMap(int cacheSize) {
            super(cacheSize, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<DeviceResourceDescriptor, ResourceManager> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > this.cacheSize;
            if (remove) {
                eldest.getValue().destroy(eldest.getKey());
            }
            return remove;
        }
    }
}

