/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public final class AboutDialog
extends AbstractSetupDialog {
    private static final int ECLIPSE_VERSION_COLUMN_INDEX = 1;
    private static final String SHOW_ALL_PLUGINS = "SHOW_ALL_PLUGINS";
    private static final int DND_OPERATIONS = 7;
    private static final List<? extends OomphTransferDelegate> DND_DELEGATES = Collections.singletonList(new OomphTransferDelegate.TextTransferDelegate());
    private static final Transfer[] DND_TRANSFERS = new Transfer[]{DND_DELEGATES.get(0).getTransfer()};
    private final IDialogSettings dialogSettings = this.getDialogSettings();
    private final String version;
    private boolean showAllPlugins;
    private Profile profile;
    private Table table;
    private TableColumn idColumn;
    private TableColumn versionColumn;
    private Color gray;

    public AboutDialog(Shell parentShell, String theVersion) {
        super(parentShell, NLS.bind((String)Messages.AboutDialog_title, (Object)parentShell.getText()), 700, 500, (OomphUIPlugin)SetupInstallerPlugin.INSTANCE, false);
        this.version = theVersion;
        this.showAllPlugins = this.dialogSettings.getBoolean(SHOW_ALL_PLUGINS);
    }

    protected String getDefaultMessage() {
        return NLS.bind((String)Messages.AboutDialog_InstallerVersion_message, (Object)this.version, (Object)SetupUtil.INSTALLER_UPDATE_URL);
    }

    protected void createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        TableColumnLayout tableColumnLayout = new TableColumnLayout(true);
        composite.setLayout((Layout)tableColumnLayout);
        this.table = new Table(composite, 66066);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.idColumn = new TableColumn(this.table, 0);
        this.idColumn.setText(Messages.AboutDialog_PluginColumn_label);
        this.idColumn.setResizable(false);
        this.idColumn.setMoveable(false);
        tableColumnLayout.setColumnData((Widget)this.idColumn, (ColumnLayoutData)new ColumnWeightData(80));
        this.versionColumn = new TableColumn(this.table, 0);
        this.versionColumn.setText(Messages.AboutDialog_VersionColumn_label);
        this.versionColumn.setResizable(false);
        this.versionColumn.setMoveable(false);
        tableColumnLayout.setColumnData((Widget)this.versionColumn, (ColumnLayoutData)new ColumnWeightData(20));
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        this.profile = agent.getCurrentProfile();
        this.gray = this.getShell().getDisplay().getSystemColor(10);
        this.fillTable();
        TableViewer tableViewer = new TableViewer(this.table);
        GeneralDragAdapter generalDragAdapter = new GeneralDragAdapter((Viewer)tableViewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IInstallableUnit) {
                        IInstallableUnit iu = (IInstallableUnit)object;
                        result.add(P2Factory.eINSTANCE.createRequirement(iu.getId(), new VersionRange(iu.getVersion().toString())));
                    }
                    ++n2;
                }
                return result;
            }
        }, DND_DELEGATES);
        tableViewer.addDragSupport(7, DND_TRANSFERS, (DragSourceListener)generalDragAdapter);
    }

    private void fillTable() {
        List<IInstallableUnit> plugins = this.getPlugins();
        Collections.sort(plugins);
        for (IInstallableUnit plugin : plugins) {
            String version;
            TableItem item;
            block7: {
                item = new TableItem(this.table, 0);
                item.setData((Object)plugin);
                String id = plugin.getId();
                item.setText(0, id);
                version = plugin.getVersion().toString();
                if (id.startsWith("org.eclipse.oomph")) {
                    try {
                        Bundle[] bundles = Platform.getBundles((String)id, (String)version);
                        if (bundles == null) break block7;
                        Bundle[] bundleArray = bundles;
                        int n = bundles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Bundle bundle = bundleArray[n2];
                            String buildID = OomphPlugin.getBuildID((Bundle)bundle);
                            if (buildID != null) {
                                version = String.valueOf(version) + NLS.bind((String)Messages.AboutDialog_Build_label, (Object)buildID);
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        SetupInstallerPlugin.INSTANCE.log(ex);
                    }
                } else {
                    item.setForeground(this.gray);
                }
            }
            item.setText(1, version);
        }
        this.versionColumn.pack();
    }

    private List<IInstallableUnit> getPlugins() {
        if (this.profile == null) {
            return Collections.emptyList();
        }
        ArrayList<IInstallableUnit> plugins = new ArrayList<IInstallableUnit>();
        block0: for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)this.profile.query(QueryUtil.createIUAnyQuery(), null))) {
            if (!this.showAllPlugins && !iu.getId().startsWith("org.eclipse.oomph")) continue;
            for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
                if (!"osgi.bundle".equals(capability.getNamespace())) continue;
                plugins.add(iu);
                continue block0;
            }
        }
        return plugins;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        final Button showAllPluginsButton = this.createCheckbox(parent, Messages.AboutDialog_ShowAllPlugins_label);
        showAllPluginsButton.setSelection(this.showAllPlugins);
        showAllPluginsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AboutDialog.this.showAllPlugins = showAllPluginsButton.getSelection();
                AboutDialog.this.dialogSettings.put(AboutDialog.SHOW_ALL_PLUGINS, AboutDialog.this.showAllPlugins);
                AboutDialog.this.table.removeAll();
                AboutDialog.this.fillTable();
            }
        });
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected String getShellText() {
        return PropertiesUtil.getProductName();
    }
}

