/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IStyledLabelDecorator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.internal.core.P2Index;
import org.eclipse.oomph.p2.internal.ui.Messages;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.RepositoryExplorer;
import org.eclipse.oomph.p2.provider.P2EditPlugin;
import org.eclipse.oomph.ui.DockableDialog;
import org.eclipse.oomph.ui.FilteredTreeWithoutWorkbench;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class SearchEclipseDialog
extends OomphDialog {
    protected static final int APPLY_ID = 1024;
    protected final WorkbenchWindowSelectionTracker workbenchWindowSelectionTracker;
    private final DockableDialog.Dockable dockable;
    private TreeViewer capabilitiesViewer;
    protected TreeViewer detailsViewer;
    private Job detailsLoadJob;
    private Text filterText;
    private String initialFilterString;

    protected SearchEclipseDialog(IWorkbenchWindow workbenchWindow, String title) {
        super(workbenchWindow.getShell(), title, 700, 500, (OomphUIPlugin)P2UIPlugin.INSTANCE, true);
        this.setShellStyle(this.getShellStyle() ^ 0x10000 | 0x10 | 0x400 | (OS.INSTANCE.isWin() ? 128 : 0));
        this.setBlockOnOpen(false);
        this.dockable = new DockableDialog.Dockable((Dialog)this);
        this.workbenchWindowSelectionTracker = new WorkbenchWindowSelectionTracker(workbenchWindow){

            @Override
            protected void selectionChanged(IWorkbenchPart part, ISelection selection) {
                SearchEclipseDialog.this.selectionChanged(part, selection);
            }
        };
    }

    public DockableDialog.Dockable getDockable() {
        return this.dockable;
    }

    public void setFilterString(Requirement requirement) {
        this.setFilterString(this.getFilterString(requirement));
    }

    public void setFilterString(final String filterString) {
        if (this.initialFilterString == null) {
            this.initialFilterString = filterString;
        } else if (filterString != null) {
            UIUtil.asyncExec((Control)this.capabilitiesViewer.getControl(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    SearchEclipseDialog.this.filterText.setText(filterString);
                    SearchEclipseDialog.this.filterText.setSelection(filterString.length());
                }
            });
        }
    }

    protected abstract void setSelected(Item var1);

    protected abstract void handleDetailsLoad(Item var1);

    protected abstract void handleDetailsDoubleClick();

    protected abstract int getDetailsAutoExpandLevel();

    protected abstract void selectionChanged(IWorkbenchPart var1, ISelection var2);

    protected abstract Image getShellImage();

    protected String getImagePath() {
        return "wizban/AgentManager.png";
    }

    protected int getContainerMargin() {
        return 10;
    }

    protected String getFilterString(Requirement requirement) {
        String namespace = requirement.getNamespace();
        String name = requirement.getName();
        StringBuilder filterString = new StringBuilder();
        if (!StringUtil.isEmpty((String)namespace)) {
            filterString.append(namespace).append('/');
        }
        if (!StringUtil.isEmpty((String)name)) {
            filterString.append(name);
        }
        return filterString.toString();
    }

    protected void createUI(Composite composite) {
        this.getShell().setImage(this.getShellImage());
        SashForm sashForm = new SashForm(composite, 66048);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite treeComposite = new Composite((Composite)sashForm, 0);
        treeComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        Composite filterComposite = new Composite(treeComposite, 0);
        filterComposite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        filterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterPlaceholder = new Composite(filterComposite, 0);
        filterPlaceholder.setLayout((Layout)UIUtil.createGridLayout((int)1));
        filterPlaceholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar filterToolBar = new ToolBar(filterComposite, 0x820000);
        ToolItem collapseAllButton = new ToolItem(filterToolBar, 0);
        collapseAllButton.setToolTipText(Messages.SearchEclipseDialog_collapseAllButton_tooltip);
        collapseAllButton.setImage(P2UIPlugin.INSTANCE.getSWTImage("collapse-all"));
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchEclipseDialog.this.capabilitiesViewer.collapseAll();
            }
        });
        final ItemFilter filter = new ItemFilter();
        filter.setIncludeLeadingWildcard(true);
        FilteredTreeWithoutWorkbench filteredTree = new FilteredTreeWithoutWorkbench(treeComposite, 2048, (PatternFilter)filter, (FilteredTreeWithoutWorkbench.ExpansionFilter)filter);
        filteredTree.setExpansionCount(100);
        Control filterControl = filteredTree.getChildren()[0];
        filterControl.setParent(filterPlaceholder);
        this.filterText = filteredTree.getFilterControl();
        DropTarget dropTarget = new DropTarget((Control)this.filterText, 1);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
                event.feedback = 0;
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
                event.feedback = 0;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = 1;
                event.feedback = 0;
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
                    AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, null);
                    String text = (String)event.data;
                    Collection values = new OomphTransferDelegate.TextTransferDelegate().getValue((EditingDomain)domain, (Object)text);
                    if (!values.isEmpty()) {
                        text = null;
                        for (Object value : values) {
                            if (!(value instanceof Requirement)) continue;
                            text = SearchEclipseDialog.this.getFilterString((Requirement)value);
                            break;
                        }
                    }
                    if (!StringUtil.isEmpty((String)text)) {
                        SearchEclipseDialog.this.filterText.setText(text);
                        SearchEclipseDialog.this.filterText.setSelection(SearchEclipseDialog.this.filterText.getText().length());
                    }
                }
            }
        });
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        this.capabilitiesViewer = filteredTree.getViewer();
        this.capabilitiesViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ToolTipLabelProvider((AdapterFactory)adapterFactory, (Viewer)this.capabilitiesViewer, filter)));
        this.capabilitiesViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.capabilitiesViewer.setUseHashlookup(true);
        new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.capabilitiesViewer, null);
        Tree capabilitiesTree = this.capabilitiesViewer.getTree();
        capabilitiesTree.setLayoutData((Object)new GridData(1808));
        this.capabilitiesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SearchEclipseDialog.this.capabilitiesViewer.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                boolean expanded = SearchEclipseDialog.this.capabilitiesViewer.getExpandedState((Object)item);
                SearchEclipseDialog.this.capabilitiesViewer.setExpandedState((Object)item, !expanded);
                if (!item.isConcrete()) {
                    block0: while (item != null) {
                        for (Item child : item.getItems()) {
                            if (!filter.isElementVisible((Viewer)SearchEclipseDialog.this.capabilitiesViewer, (Object)child)) continue;
                            if (child.isConcrete()) {
                                SearchEclipseDialog.this.capabilitiesViewer.setSelection((ISelection)new StructuredSelection((Object)child), true);
                                item = null;
                                continue block0;
                            }
                            SearchEclipseDialog.this.capabilitiesViewer.setExpandedState((Object)child, true);
                            item = child;
                            continue block0;
                        }
                    }
                }
            }
        });
        this.capabilitiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                if (item != null && item.isCapability()) {
                    String namespace = item.getNamespace();
                    String name = item.getName();
                    SearchEclipseDialog.this.loadDetails(namespace, name);
                } else {
                    SearchEclipseDialog.this.detailsViewer.setInput(null);
                }
                SearchEclipseDialog.this.setSelected(item);
            }
        });
        this.capabilitiesViewer.addDragSupport(7, RepositoryExplorer.DND_TRANSFERS, (DragSourceListener)new GeneralDragAdapter((Viewer)this.capabilitiesViewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item;
                    Object object = objectArray[n2];
                    if (object instanceof Item && (item = (Item)((Object)object)).isCapability()) {
                        result.add(this.createRequirement(item));
                    }
                    ++n2;
                }
                return result;
            }

            private Requirement createRequirement(Item item) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement(item.getName());
                requirement.setNamespace(item.getNamespace());
                return requirement;
            }
        }, RepositoryExplorer.DND_DELEGATES));
        Composite detailsComposite = new Composite((Composite)sashForm, 0);
        detailsComposite.setLayout((Layout)new FillLayout());
        detailsComposite.setForeground(capabilitiesTree.getForeground());
        detailsComposite.setBackground(capabilitiesTree.getBackground());
        this.detailsViewer = new TreeViewer(detailsComposite);
        this.detailsViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ToolTipLabelProvider((AdapterFactory)adapterFactory, (Viewer)this.detailsViewer, null)));
        this.detailsViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.detailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                SearchEclipseDialog.this.setSelected(item);
            }
        });
        this.detailsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SearchEclipseDialog.this.handleDetailsDoubleClick();
            }
        });
        this.detailsViewer.addDragSupport(7, RepositoryExplorer.DND_TRANSFERS, (DragSourceListener)new GeneralDragAdapter((Viewer)this.detailsViewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof Item) {
                        Item item = (Item)((Object)object);
                        if (item.isRepository()) {
                            result.add(P2Factory.eINSTANCE.createRepository(item.getText()));
                        } else if (item.isCapability()) {
                            result.add(this.createRequirement(item));
                        } else {
                            try {
                                if (item.isVersionRange()) {
                                    Item parent = item.getParent();
                                    while (parent.isVersionRange()) {
                                        parent = parent.getParent();
                                    }
                                    Requirement requirement = P2Factory.eINSTANCE.createRequirement(parent.getName());
                                    requirement.setNamespace(parent.getNamespace());
                                    requirement.setVersionRange(item.versionRange);
                                    result.add(requirement);
                                } else {
                                    Requirement requirement = this.createRequirement(item.getParent());
                                    Version version = Version.create((String)item.getText());
                                    if (!Version.emptyVersion.equals(version)) {
                                        requirement.setVersionRange(new VersionRange(version, true, version, true));
                                    }
                                    result.add(requirement);
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                    }
                    ++n2;
                }
                return result;
            }

            private Requirement createRequirement(Item item) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement(item.getName());
                requirement.setNamespace(item.getNamespace());
                return requirement;
            }
        }, RepositoryExplorer.DND_DELEGATES));
        sashForm.setWeights(new int[]{14, 5});
        UIUtil.asyncExec((Control)composite, (Runnable)new Runnable(){

            @Override
            public void run() {
                SearchEclipseDialog.this.setSelected(null);
            }
        });
        this.loadModel();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button applyButton = this.createButton(parent, 1024, Messages.SearchEclipseDialog_applyButton_text, true);
        applyButton.setEnabled(false);
        applyButton.setImage(this.getDefaultApplyImage());
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setText(Messages.SearchEclipseDialog_okButton_text);
    }

    protected void updateButtons(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            ApplyHandler applyHandler = this.getApplyHandler();
            okButton.setEnabled(enabled && applyHandler != null);
            Button applyButton = this.getButton(1024);
            applyButton.setEnabled(enabled && applyHandler != null);
            if (applyHandler == null) {
                applyButton.setImage(this.getDefaultApplyImage());
            } else {
                okButton.setToolTipText(applyHandler.getToolTipText());
                applyButton.setImage(applyHandler.getImage());
                applyButton.setToolTipText(applyHandler.getToolTipText());
            }
        }
    }

    protected void loadModel() {
        Item root = Item.createItem();
        root.getChildren().add((Object)Item.createNamespaceItem(Messages.SearchEclipseDialog_loadingItem_namespace));
        this.capabilitiesViewer.setInput((Object)root);
        Job job = new Job(Messages.SearchEclipseDialog_capabilityLoaderJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                final Item root = Item.createItem();
                EList children = root.getChildren();
                LinkedHashMap capabilities = new LinkedHashMap(P2Index.INSTANCE.getCapabilities());
                if (capabilities.isEmpty()) {
                    children.add((Object)Item.createNamespaceItem(Messages.SearchEclipseDialog_indexUnavailableItem_namespace));
                } else {
                    Set flavors = (Set)capabilities.get("org.eclipse.equinox.p2.flavor");
                    Set<String> capabilityKeys = capabilities.keySet();
                    RepositoryExplorer.minimizeNamespaces(flavors, capabilityKeys);
                    capabilityKeys.remove("org.eclipse.equinox.p2.flavor");
                    capabilityKeys.remove("A.PDE.Target.Platform");
                    for (Map.Entry entry : capabilities.entrySet()) {
                        String namespace = (String)entry.getKey();
                        Item namespaceItem = Item.createNamespaceItem(namespace);
                        children.add((Object)namespaceItem);
                        LinkedHashMap<SegmentSequence, Item> hierarchicalChildren = new LinkedHashMap<SegmentSequence, Item>();
                        SegmentSequence baseName = SegmentSequence.create((String)".");
                        hierarchicalChildren.put(baseName, namespaceItem);
                        for (String value : (Set)entry.getValue()) {
                            SegmentSequence qualifiedName = SegmentSequence.create((String)".", (String)value);
                            SegmentSequence partialName = baseName;
                            Item parent = namespaceItem;
                            String[] stringArray = qualifiedName.segments();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String segment = stringArray[n2];
                                Item itemProvider = (Item)((Object)hierarchicalChildren.get(partialName = partialName.append(segment)));
                                if (itemProvider == null) {
                                    itemProvider = Item.create(namespace, partialName);
                                    hierarchicalChildren.put(partialName, itemProvider);
                                    parent.getChildren().add((Object)itemProvider);
                                }
                                parent = itemProvider;
                                ++n2;
                            }
                            parent.setConcrete();
                        }
                    }
                    root.sort();
                }
                UIUtil.asyncExec((Control)SearchEclipseDialog.this.capabilitiesViewer.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).SearchEclipseDialog.this.capabilitiesViewer.setInput((Object)root);
                        if ((this).SearchEclipseDialog.this.initialFilterString != null) {
                            (this).SearchEclipseDialog.this.filterText.setText((this).SearchEclipseDialog.this.initialFilterString);
                            (this).SearchEclipseDialog.this.filterText.setSelection((this).SearchEclipseDialog.this.initialFilterString.length());
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void loadDetails(final String namespace, final String name) {
        if (this.detailsLoadJob != null) {
            this.detailsLoadJob.cancel();
        }
        Item root = Item.createItem();
        root.getChildren().add((Object)Item.createNamespaceItem(Messages.SearchEclipseDialog_loadingItem_namespace));
        this.detailsViewer.setInput((Object)root);
        this.detailsLoadJob = new Job(Messages.SearchEclipseDialog_detailsLoadJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                final Item input = Item.createItem();
                Item capabilityItem = Item.create(namespace, name);
                input.getChildren().add((Object)capabilityItem);
                SearchEclipseDialog.this.handleDetailsLoad(capabilityItem);
                if (!monitor.isCanceled()) {
                    UIUtil.asyncExec((Control)SearchEclipseDialog.this.detailsViewer.getControl(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).SearchEclipseDialog.this.detailsViewer.setInput((Object)input);
                            (this).SearchEclipseDialog.this.detailsViewer.expandToLevel(SearchEclipseDialog.this.getDetailsAutoExpandLevel());
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        this.detailsLoadJob.setSystem(true);
        this.detailsLoadJob.schedule();
    }

    public boolean close() {
        this.workbenchWindowSelectionTracker.dispose();
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            ApplyHandler applyHandler = this.getApplyHandler();
            if (applyHandler != null) {
                applyHandler.apply();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.buttonPressed(1024);
        super.okPressed();
    }

    protected ApplyHandler getApplyHandler() {
        Object firstElement;
        EditingDomain domain;
        IWorkbenchPart activePart = this.workbenchWindowSelectionTracker.getActivePart();
        if (activePart instanceof RepositoryExplorer) {
            return this.getApplyHandler((RepositoryExplorer)activePart);
        }
        ISelection selection = this.workbenchWindowSelectionTracker.getSelection();
        if (selection instanceof IStructuredSelection && (domain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)(firstElement = ((IStructuredSelection)selection).getFirstElement()))) != null && firstElement != null) {
            return this.getApplyHandler(domain, firstElement);
        }
        return null;
    }

    protected Image getDefaultApplyImage() {
        Object firstElement;
        EditingDomain domain;
        IWorkbenchPart activePart = this.workbenchWindowSelectionTracker.getActivePart();
        ISelection selection = this.workbenchWindowSelectionTracker.getSelection();
        if (selection instanceof IStructuredSelection && (domain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)(firstElement = ((IStructuredSelection)selection).getFirstElement()))) != null && firstElement != null) {
            return new ApplyHandler(domain, firstElement, Messages.SearchEclipseDialog_applyHandler_tooltipPrefix){

                @Override
                public void apply() {
                }
            }.getImage();
        }
        return new ApplyHandler(activePart){

            @Override
            public void apply() {
            }
        }.getImage();
    }

    protected ApplyHandler getApplyHandler(RepositoryExplorer repositoryExplorer) {
        return null;
    }

    protected ApplyHandler getApplyHandler(EditingDomain domain, Object target) {
        return null;
    }

    protected static abstract class ApplyHandler {
        private final Image image;
        private final String toolTipText;

        public ApplyHandler(IWorkbenchPart workbenchPart) {
            this.image = workbenchPart.getTitleImage();
            this.toolTipText = NLS.bind((String)Messages.SearchEclipseDialog_workbenchPathApplyHandler_tooltip, (Object)workbenchPart.getTitle());
        }

        public ApplyHandler(EditingDomain domain, Object target, String toolTipPrefix) {
            AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(((AdapterFactoryEditingDomain)domain).getAdapterFactory());
            this.image = adapterFactoryLabelProvider.getImage(target);
            this.toolTipText = toolTipPrefix + " " + adapterFactoryLabelProvider.getText(target);
            adapterFactoryLabelProvider.dispose();
        }

        public Image getImage() {
            return this.image;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public abstract void apply();
    }

    private static final class CapabilityComposedImage
    extends ComposedImage {
        private static final Image CONCRETE_CAPABILITY_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("ovr16/concrete_capability");

        private CapabilityComposedImage(Object image) {
            super(Arrays.asList(image, CONCRETE_CAPABILITY_IMAGE));
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List result = super.getDrawPoints(size);
            if (result.size() > 1) {
                ((ComposedImage.Point)result.get((int)1)).x += 9;
                ((ComposedImage.Point)result.get((int)1)).y += 9;
            }
            return result;
        }
    }

    private static class Item
    extends ItemProvider {
        private static final Comparator<String> STRING_COMPARATOR = CommonPlugin.INSTANCE.getComparator();
        private static final Comparator<Item> COMPARATOR = new Comparator<Item>(){

            @Override
            public int compare(Item item1, Item item2) {
                if (item1.versionRange != null && item2.versionRange != null) {
                    boolean qualifier2;
                    Version minimum1 = item1.versionRange.getMinimum();
                    Version minimum2 = item2.versionRange.getMinimum();
                    boolean qualifier1 = minimum1.getSegmentCount() >= 4 && !"".equals(minimum1.getSegment(3));
                    boolean bl = qualifier2 = minimum2.getSegmentCount() >= 4 && !"".equals(minimum2.getSegment(3));
                    if (qualifier1 && !qualifier2) {
                        return 1;
                    }
                    if (qualifier2 && !qualifier1) {
                        return -1;
                    }
                    int result = minimum1.compareTo((Object)minimum2);
                    if (result == 0) {
                        return -item1.versionRange.getMaximum().compareTo((Object)item2.versionRange.getMaximum());
                    }
                    return -result;
                }
                String text1 = item1.getText();
                String text2 = item2.getText();
                if (text1.length() >= 1 && text2.length() >= 1) {
                    boolean isDigit1 = Character.isDigit(text1.charAt(0));
                    boolean isDigit2 = Character.isDigit(text2.charAt(0));
                    if (isDigit1 && !isDigit2) {
                        return 1;
                    }
                    if (!isDigit1 && isDigit2) {
                        return -1;
                    }
                }
                return STRING_COMPARATOR.compare(text1, text2);
            }
        };
        private static final Image VERSION_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/version");
        private static final Image NAMESPACE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/folder");
        private static final Image CAPABILITY_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/capability");
        private static final Image REPOSITORY_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/repository");
        private static final Image JAVA_PACKAGE_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(P2EditPlugin.INSTANCE.getImage("full/obj16/Requirement_Package"));
        private static final Image BUNDLE_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(P2EditPlugin.INSTANCE.getImage("full/obj16/Requirement_Plugin"));
        private static final Image FEATURE_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(P2EditPlugin.INSTANCE.getImage("full/obj16/Requirement_Feature"));
        private String namespace;
        private String name;
        private String decoration;
        private boolean concrete;
        private boolean repository;
        private VersionRange versionRange;

        private Item() {
        }

        private Item(String namespace) {
            super(namespace, (Object)NAMESPACE_IMAGE);
            this.namespace = namespace;
        }

        private Item(String namespace, SegmentSequence partialName) {
            super(URI.decode((String)partialName.lastSegment()), (Object)Item.getImage(namespace, partialName.toString()));
            this.namespace = namespace;
            this.name = partialName.toString();
        }

        private Item(String namespace, String name) {
            super(namespace + "/" + URI.decode((String)name), (Object)Item.getImage(namespace, name));
            this.namespace = namespace;
            this.name = name;
        }

        private Item(Version version) {
            super(version.toString(), (Object)VERSION_IMAGE);
        }

        private Item(VersionRange versionRange) {
            super(versionRange.toString(), (Object)VERSION_IMAGE);
            this.versionRange = versionRange;
        }

        private Item(P2Index.Repository repository) {
            super(repository.getLocation().toString(), (Object)REPOSITORY_IMAGE);
            int capabilityCount = repository.getCapabilityCount();
            this.decoration = " " + (capabilityCount == 1 ? Messages.SearchEclipseDialog_capability : NLS.bind((String)Messages.SearchEclipseDialog_capabilities, (Object)capabilityCount));
            this.repository = true;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            StringBuilder result = new StringBuilder();
            if (this.namespace != null) {
                result.append(this.namespace);
            }
            if (this.name != null) {
                if (this.namespace != null) {
                    result.append('/');
                }
                result.append(URI.decode((String)this.name));
            }
            return result.toString();
        }

        public boolean isCapability() {
            return this.namespace != null && this.name != null;
        }

        public boolean isRepository() {
            return this.repository;
        }

        public void setConcrete() {
            this.setImage(ExtendedImageRegistry.INSTANCE.getImage((Object)new CapabilityComposedImage(this.getImage())));
            this.concrete = true;
        }

        public boolean isConcrete() {
            return this.concrete;
        }

        public boolean isVersionRange() {
            return this.versionRange != null;
        }

        public static Item createRepository(P2Index.Repository repository) {
            Item item = new Item(repository);
            EList children = item.getChildren();
            P2Index.Repository[] repositoryArray = repository.getChildren();
            int n = repositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                P2Index.Repository child = repositoryArray[n2];
                children.add((Object)Item.createRepository(child));
                ++n2;
            }
            return item;
        }

        public static Item createVersionRange(VersionRange versionRange) {
            return new Item(versionRange);
        }

        public static Item createVersion(Version version) {
            return new Item(version);
        }

        public static Item create(String namespace, SegmentSequence partialName) {
            return new Item(namespace, partialName);
        }

        public static Item create(String namespace, String name) {
            return new Item(namespace, name);
        }

        public static Item createItem() {
            return new Item();
        }

        public static Item createNamespaceItem(String namespace) {
            return new Item(namespace);
        }

        public Object getStyledText(Object object) {
            if (this.decoration != null) {
                StyledString styledLabel = new StyledString();
                styledLabel.append(this.getText());
                styledLabel.append(" ");
                styledLabel.append(this.decoration, StyledString.Style.DECORATIONS_STYLER);
                return styledLabel;
            }
            return super.getStyledText(object);
        }

        public Item getParent() {
            return (Item)((Object)super.getParent());
        }

        public EList<Item> getItems() {
            EList children = this.getChildren();
            return children;
        }

        public void sort() {
            EList<Item> children = this.getItems();
            ECollections.sort(children, COMPARATOR);
            for (Item child : children) {
                child.sort();
            }
        }

        private static Image getImage(String namespace, String name) {
            if ("java.package".equals(namespace)) {
                return JAVA_PACKAGE_IMAGE;
            }
            if ("org.eclipse.equinox.p2.iu".equals(namespace)) {
                if (name.endsWith(".feature.group")) {
                    return FEATURE_IMAGE;
                }
                return BUNDLE_IMAGE;
            }
            if ("org.eclipse.update.feature".equals(namespace)) {
                return FEATURE_IMAGE;
            }
            if ("osgi.fragment".equals(namespace) || "osgi.bundle".equals(namespace)) {
                return BUNDLE_IMAGE;
            }
            return CAPABILITY_IMAGE;
        }
    }

    private static final class ItemFilter
    extends PatternFilter
    implements FilteredTreeWithoutWorkbench.ExpansionFilter {
        private static final Pattern WILDCARD_FILTER_PATTERN = Pattern.compile("(\\\\.|[*?/.])");
        private Pattern filterPattern;
        private List<Pattern> prefixFilterPatterns;

        private ItemFilter() {
        }

        public List<Pattern> getPrefixFilterPatterns() {
            return this.prefixFilterPatterns;
        }

        public void setPattern(String patternString) {
            super.setPattern((String)patternString);
            if (patternString == null) {
                this.filterPattern = null;
                this.prefixFilterPatterns = Collections.emptyList();
            } else {
                this.prefixFilterPatterns = new ArrayList<Pattern>();
                StringBuffer pattern = new StringBuffer("(\\Q");
                if (((String)patternString).indexOf(47) == -1) {
                    patternString = "/" + (String)patternString;
                }
                Matcher matcher = WILDCARD_FILTER_PATTERN.matcher((CharSequence)patternString);
                while (matcher.find()) {
                    String tail;
                    String separator = matcher.group(1);
                    if (separator.length() == 2) {
                        matcher.appendReplacement(pattern, "");
                        if ("\\E".equals(separator)) {
                            pattern.append("\\E\\\\E\\Q");
                            continue;
                        }
                        if ("\\\\".equals(separator)) {
                            pattern.append("\\E\\\\\\Q");
                            continue;
                        }
                        pattern.append(separator.charAt(1));
                        continue;
                    }
                    char separatorChar = separator.charAt(0);
                    switch (separatorChar) {
                        case '*': {
                            tail = ".*?";
                            break;
                        }
                        case '?': {
                            tail = ".";
                            break;
                        }
                        case '/': {
                            if (matcher.start(1) == 0) {
                                tail = "/.*?";
                                break;
                            }
                            tail = ".*?/.*?";
                            break;
                        }
                        case '.': {
                            tail = "(\\.)";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Pattern " + String.valueOf(WILDCARD_FILTER_PATTERN) + " should match a single character");
                        }
                    }
                    matcher.appendReplacement(pattern, "\\\\E)");
                    this.prefixFilterPatterns.add(Pattern.compile(pattern.toString(), 2));
                    pattern.append(tail).append("(\\Q");
                }
                matcher.appendTail(pattern);
                pattern.append("\\E)");
                this.filterPattern = Pattern.compile(pattern.toString(), 2);
                this.prefixFilterPatterns.add(this.filterPattern);
                Collections.reverse(this.prefixFilterPatterns);
            }
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element == null) {
                return false;
            }
            Item item = (Item)((Object)element);
            String text = item.getQualifiedName();
            return this.wordMatches(text);
        }

        protected boolean wordMatches(String text) {
            if (this.filterPattern == null) {
                return true;
            }
            if (text == null) {
                return false;
            }
            return this.filterPattern.matcher(text).find();
        }

        public boolean shouldExpand(Object element) {
            Item item = (Item)((Object)element);
            return !this.isLeafMatch(null, element) || !item.isCapability();
        }
    }

    public static class Repositories
    extends SearchEclipseDialog {
        public static final String MESSAGE = Messages.SearchEclipseDialog_repositoriesDialog_message;
        public static final String TITLE = Messages.SearchEclipseDialog_repositoriesDialog_title;
        private String selectedRepository;

        public Repositories(IWorkbenchWindow workbenchWindow) {
            super(workbenchWindow, TITLE);
        }

        public String getHelpPath() {
            return P2UIPlugin.INSTANCE.getSymbolicName() + "/html/SearchEclipseRepositoriesHelp.html";
        }

        public String getSelectedRepository() {
            return this.selectedRepository;
        }

        public void setSelectedRepository(String selectedRepository) {
            this.selectedRepository = selectedRepository;
            this.updateButtons(selectedRepository != null);
        }

        @Override
        protected void selectionChanged(IWorkbenchPart part, ISelection selection) {
            this.setSelectedRepository(this.selectedRepository);
        }

        @Override
        protected void setSelected(Item item) {
            this.setSelectedRepository(item != null && item.isRepository() ? item.getText() : null);
        }

        @Override
        protected Image getShellImage() {
            return P2UIPlugin.INSTANCE.getSWTImage("tool16/search_repository.png");
        }

        protected String getShellText() {
            return TITLE;
        }

        protected String getDefaultMessage() {
            return MESSAGE + ".";
        }

        @Override
        protected void handleDetailsDoubleClick() {
            if (this.selectedRepository != null) {
                this.okPressed();
            } else {
                Item item;
                IStructuredSelection selection = (IStructuredSelection)this.detailsViewer.getSelection();
                boolean expanded = this.detailsViewer.getExpandedState((Object)(item = (Item)((Object)selection.getFirstElement())));
                this.detailsViewer.setExpandedState((Object)item, !expanded);
            }
        }

        @Override
        protected void handleDetailsLoad(Item capabilityItem) {
            Map capabilitiesFromSimpleRepositories = P2Index.INSTANCE.lookupCapabilities(capabilityItem.getNamespace(), capabilityItem.getName());
            Map capabilitiesFromComposedRepositories = P2Index.INSTANCE.generateCapabilitiesFromComposedRepositories(capabilitiesFromSimpleRepositories);
            CollectionUtil.addAll((Map)capabilitiesFromComposedRepositories, (Map)capabilitiesFromSimpleRepositories);
            TreeMap<Version, Item> versionItems = new TreeMap<Version, Item>();
            for (Map.Entry entry : capabilitiesFromComposedRepositories.entrySet()) {
                P2Index.Repository key = (P2Index.Repository)entry.getKey();
                for (Version version : (Set)entry.getValue()) {
                    Item versionItem = (Item)((Object)versionItems.get(version));
                    if (versionItem == null) {
                        versionItem = Item.createVersion(version);
                        versionItems.put(version, versionItem);
                    }
                    versionItem.getChildren().add((Object)Item.createRepository(key));
                }
            }
            for (Item versionItem : versionItems.values()) {
                versionItem.sort();
            }
            capabilityItem.getChildren().addAll(versionItems.values());
            ECollections.reverse((EList)capabilityItem.getChildren());
        }

        @Override
        protected int getDetailsAutoExpandLevel() {
            return 2;
        }

        @Override
        protected ApplyHandler getApplyHandler(final EditingDomain domain, final Object target) {
            if (target instanceof Repository) {
                return new ApplyHandler(domain, target, Messages.SearchEclipseDialog_repositoryApplyHandler_tooltipPrefix){

                    @Override
                    public void apply() {
                        Command setCommand = SetCommand.create((EditingDomain)domain, (Object)target, (Object)P2Package.Literals.REPOSITORY__URL, (Object)selectedRepository);
                        domain.getCommandStack().execute(setCommand);
                    }
                };
            }
            if (target instanceof EObject) {
                EClass eClass = ((EObject)target).eClass();
                for (final EReference eReference : eClass.getEAllContainments()) {
                    if (eReference.getEType() != P2Package.Literals.REPOSITORY || !eReference.isContainment() || !eReference.isMany()) continue;
                    return new ApplyHandler(domain, target, Messages.SearchEclipseDialog_eObjectApplyHandler_tooltipPrefix){

                        @Override
                        public void apply() {
                            Repository repository = P2Factory.eINSTANCE.createRepository();
                            repository.setURL(selectedRepository);
                            Command addCommand = AddCommand.create((EditingDomain)domain, (Object)target, (Object)eReference, (Object)repository);
                            domain.getCommandStack().execute(addCommand);
                        }
                    };
                }
            }
            return null;
        }

        @Override
        protected ApplyHandler getApplyHandler(final RepositoryExplorer repositoryExplorer) {
            return new ApplyHandler((IWorkbenchPart)repositoryExplorer){

                @Override
                public void apply() {
                    repositoryExplorer.activateAndLoadRepository(selectedRepository);
                }
            };
        }

        public static Repositories getFor(IWorkbenchWindow workbenchWindow) {
            return (Repositories)DockableDialog.getFor(Repositories.class, (IWorkbenchWindow)workbenchWindow);
        }

        public static void closeFor(IWorkbenchWindow workbenchWindow) {
            DockableDialog.closeFor(Repositories.class, (IWorkbenchWindow)workbenchWindow);
        }

        public static Repositories openFor(IWorkbenchWindow workbenchWindow) {
            DockableDialog.Factory<Repositories> factory = new DockableDialog.Factory<Repositories>(){

                public Repositories create(IWorkbenchWindow workbenchWindow) {
                    return new Repositories(workbenchWindow);
                }
            };
            return (Repositories)DockableDialog.openFor(Repositories.class, (DockableDialog.Factory)factory, (IWorkbenchWindow)workbenchWindow);
        }
    }

    public static class Requirements
    extends SearchEclipseDialog {
        public static final String TITLE = Messages.SearchEclipseDialog_requirementsDialog_title;
        public static final String MESSAGE = Messages.SearchEclipseDialog_requirementsDialog_message;
        private Requirement selectedRequirement;

        public Requirements(IWorkbenchWindow workbenchWindow) {
            super(workbenchWindow, TITLE);
        }

        public String getHelpPath() {
            return P2UIPlugin.INSTANCE.getSymbolicName() + "/html/SearchEclipseRequirementsHelp.html";
        }

        public Requirement getSelectedRequirement() {
            return this.selectedRequirement;
        }

        public void setSelectedRequirement(Requirement selectedRequirement) {
            this.selectedRequirement = selectedRequirement;
            this.updateButtons(selectedRequirement != null);
        }

        @Override
        protected void selectionChanged(IWorkbenchPart part, ISelection selection) {
            this.setSelectedRequirement(this.selectedRequirement);
        }

        @Override
        protected void setSelected(Item item) {
            Requirement requirement = null;
            if (item != null) {
                if (item.isConcrete()) {
                    requirement = P2Factory.eINSTANCE.createRequirement(item.getName());
                    requirement.setNamespace(item.getNamespace());
                } else if (item.isVersionRange()) {
                    Item parent = item.getParent();
                    while (parent.isVersionRange()) {
                        parent = parent.getParent();
                    }
                    requirement = P2Factory.eINSTANCE.createRequirement(parent.getName());
                    requirement.setNamespace(parent.getNamespace());
                    requirement.setVersionRange(item.versionRange);
                }
            }
            this.setSelectedRequirement(requirement);
        }

        @Override
        protected Image getShellImage() {
            return P2UIPlugin.INSTANCE.getSWTImage("tool16/search_requirement.png");
        }

        protected String getShellText() {
            return TITLE;
        }

        protected String getDefaultMessage() {
            return MESSAGE + ".";
        }

        @Override
        protected void handleDetailsDoubleClick() {
            Item item;
            IStructuredSelection selection = (IStructuredSelection)this.detailsViewer.getSelection();
            boolean expanded = this.detailsViewer.getExpandedState((Object)(item = (Item)((Object)selection.getFirstElement())));
            this.detailsViewer.setExpandedState((Object)item, !expanded);
        }

        @Override
        protected void handleDetailsLoad(Item capabilityItem) {
            Map capabilitiesFromSimpleRepositories = P2Index.INSTANCE.lookupCapabilities(capabilityItem.getNamespace(), capabilityItem.getName());
            LinkedHashMap<VersionRange, Item> versionRangeItems = new LinkedHashMap<VersionRange, Item>();
            for (Set versions : capabilitiesFromSimpleRepositories.values()) {
                block1: for (Version version : versions) {
                    Item parent = capabilityItem;
                    for (VersionSegment versionSegment : VersionSegment.VALUES) {
                        VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment, true);
                        Item versionRangeItem = (Item)((Object)versionRangeItems.get(versionRange));
                        if (versionRangeItem == null) {
                            versionRangeItem = Item.createVersionRange(versionRange);
                            parent.getChildren().add((Object)versionRangeItem);
                            versionRangeItems.put(versionRange, versionRangeItem);
                        }
                        if (Version.emptyVersion.equals(version)) continue block1;
                        VersionRange restrictedVersionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment, false);
                        Item restrictedVersionRangeItem = (Item)((Object)versionRangeItems.get(restrictedVersionRange));
                        if (restrictedVersionRangeItem == null) {
                            restrictedVersionRangeItem = Item.createVersionRange(restrictedVersionRange);
                            versionRangeItem.getChildren().add((Object)restrictedVersionRangeItem);
                            versionRangeItems.put(restrictedVersionRange, restrictedVersionRangeItem);
                        }
                        if (versionSegment == VersionSegment.QUALIFIER) {
                            restrictedVersionRange = new VersionRange(version, true, P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MINOR).getMaximum(), false);
                            restrictedVersionRangeItem = (Item)((Object)versionRangeItems.get(restrictedVersionRange));
                            if (restrictedVersionRangeItem == null) {
                                restrictedVersionRangeItem = Item.createVersionRange(restrictedVersionRange);
                                versionRangeItem.getChildren().add((Object)restrictedVersionRangeItem);
                                versionRangeItems.put(restrictedVersionRange, restrictedVersionRangeItem);
                            }
                            if ((restrictedVersionRangeItem = (Item)((Object)versionRangeItems.get(restrictedVersionRange = new VersionRange(version, true, P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MICRO).getMaximum(), false)))) == null) {
                                restrictedVersionRangeItem = Item.createVersionRange(restrictedVersionRange);
                                versionRangeItem.getChildren().add((Object)restrictedVersionRangeItem);
                                versionRangeItems.put(restrictedVersionRange, restrictedVersionRangeItem);
                            }
                        }
                        parent = versionRangeItem;
                    }
                }
            }
            capabilityItem.sort();
        }

        @Override
        protected int getDetailsAutoExpandLevel() {
            return 3;
        }

        @Override
        protected ApplyHandler getApplyHandler(final EditingDomain domain, final Object target) {
            if (target instanceof Requirement) {
                return new ApplyHandler(domain, target, Messages.SearchEclipseDialog_requirementApplyHandler_tooltipPrefix){

                    @Override
                    public void apply() {
                        Requirement requirement = (Requirement)target;
                        CompoundCommand compoundCommand = new CompoundCommand(Integer.MAX_VALUE);
                        compoundCommand.append(SetCommand.create((EditingDomain)domain, (Object)requirement, (Object)P2Package.Literals.REQUIREMENT__NAME, (Object)selectedRequirement.getName()));
                        compoundCommand.append(SetCommand.create((EditingDomain)domain, (Object)requirement, (Object)P2Package.Literals.REQUIREMENT__NAMESPACE, (Object)selectedRequirement.getNamespace()));
                        compoundCommand.append(SetCommand.create((EditingDomain)domain, (Object)requirement, (Object)P2Package.Literals.REQUIREMENT__VERSION_RANGE, (Object)selectedRequirement.getVersionRange()));
                        domain.getCommandStack().execute((Command)compoundCommand);
                    }
                };
            }
            if (target instanceof EObject) {
                EClass eClass = ((EObject)target).eClass();
                for (final EReference eReference : eClass.getEAllContainments()) {
                    if (eReference.getEType() != P2Package.Literals.REQUIREMENT || !eReference.isContainment() || !eReference.isMany()) continue;
                    return new ApplyHandler(domain, target, Messages.SearchEclipseDialog_eObjectApplyHandler_tooltipPrefix){

                        @Override
                        public void apply() {
                            Command addCommand = AddCommand.create((EditingDomain)domain, (Object)target, (Object)eReference, (Object)selectedRequirement);
                            domain.getCommandStack().execute(addCommand);
                        }
                    };
                }
            }
            return null;
        }

        public static Requirements getFor(IWorkbenchWindow workbenchWindow) {
            return (Requirements)DockableDialog.getFor(Requirements.class, (IWorkbenchWindow)workbenchWindow);
        }

        public static void closeFor(IWorkbenchWindow workbenchWindow) {
            DockableDialog.closeFor(Requirements.class, (IWorkbenchWindow)workbenchWindow);
        }

        public static Requirements openFor(IWorkbenchWindow workbenchWindow) {
            DockableDialog.Factory<Requirements> factory = new DockableDialog.Factory<Requirements>(){

                public Requirements create(IWorkbenchWindow workbenchWindow) {
                    return new Requirements(workbenchWindow);
                }
            };
            return (Requirements)DockableDialog.openFor(Requirements.class, (DockableDialog.Factory)factory, (IWorkbenchWindow)workbenchWindow);
        }
    }

    public static class ToolTipLabelProvider
    extends DecoratingColumLabelProvider.StyledLabelProvider {
        public ToolTipLabelProvider(AdapterFactory adapterFactory, Viewer viewer, final ItemFilter itemFilter) {
            super((ILabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider(adapterFactory, viewer), (ILabelDecorator)new IStyledLabelDecorator(viewer){
                private final StyledString.Styler bold;
                {
                    this.bold = new StyledString.Styler(viewer){
                        private final Font boldFont;
                        {
                            this.boldFont = ExtendedFontRegistry.INSTANCE.getFont(viewer.getControl().getFont(), (Object)IItemFontProvider.BOLD_FONT);
                        }

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.font = this.boldFont;
                        }
                    };
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String decorateText(String text, Object element) {
                    return text;
                }

                public Image decorateImage(Image image, Object element) {
                    return image;
                }

                public org.eclipse.jface.viewers.StyledString decorateStyledText(org.eclipse.jface.viewers.StyledString styledString, Object element) {
                    List<Pattern> prefixFilterPatterns;
                    if (itemFilter != null && (prefixFilterPatterns = itemFilter.getPrefixFilterPatterns()) != null) {
                        Item item = (Item)((Object)element);
                        String text = item.getText();
                        String name = item.getQualifiedName();
                        for (Pattern prefixFilterPattern : prefixFilterPatterns) {
                            Matcher matcher = prefixFilterPattern.matcher(name);
                            if (!matcher.find()) continue;
                            org.eclipse.jface.viewers.StyledString styledLabel = new org.eclipse.jface.viewers.StyledString();
                            int groupCount = matcher.groupCount();
                            StringBuilder styleRun = null;
                            boolean previousMatches = false;
                            int i = name.length() - text.length();
                            while (i < name.length()) {
                                boolean matches = false;
                                int j = 1;
                                while (j <= groupCount) {
                                    int start = matcher.start(j);
                                    int end = matcher.end(j);
                                    if (i >= start && i < end) {
                                        matches = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (previousMatches != matches) {
                                    if (styleRun != null) {
                                        if (previousMatches) {
                                            styledLabel.append(styleRun.toString(), this.bold);
                                        } else {
                                            styledLabel.append(styleRun.toString());
                                        }
                                        styleRun = null;
                                    }
                                    previousMatches = matches;
                                }
                                if (styleRun == null) {
                                    styleRun = new StringBuilder();
                                }
                                styleRun.append(name.charAt(i));
                                ++i;
                            }
                            if (styleRun != null) {
                                if (previousMatches) {
                                    styledLabel.append(styleRun.toString(), this.bold);
                                } else {
                                    styledLabel.append(styleRun.toString());
                                }
                            }
                            return styledLabel;
                        }
                    }
                    return styledString;
                }
            });
        }

        public String getToolTipText(Object element) {
            Item item = (Item)((Object)element);
            if (item.isCapability()) {
                StringBuilder result = new StringBuilder();
                result.append(DiagnosticDecorator.enquote((String)("<img src='" + String.valueOf(ImageURIRegistry.INSTANCE.getImageURI(ExtendedImageRegistry.INSTANCE.getImage(item.getImage()))) + "'/> ")));
                result.append("&nbsp;");
                result.append(item.getNamespace());
                result.append('/');
                result.append(URI.decode((String)item.getName()));
                return DiagnosticDecorator.strip((String)result.toString());
            }
            return null;
        }
    }

    private static abstract class WorkbenchWindowSelectionTracker
    implements IPageListener,
    IPartListener,
    ISelectionChangedListener {
        private IWorkbenchPage workbenchPage;
        private IWorkbenchPart workbenchPart;

        public WorkbenchWindowSelectionTracker(IWorkbenchWindow workbenchWindow) {
            workbenchWindow.addPageListener((IPageListener)this);
            IWorkbenchPage activePage = workbenchWindow.getActivePage();
            if (activePage != null) {
                this.pageActivated(activePage);
                IWorkbenchPart activePart = activePage.getActivePart();
                this.partActivated(activePart);
            }
        }

        public IWorkbenchPart getActivePart() {
            return this.workbenchPart;
        }

        public ISelection getSelection() {
            if (this.workbenchPart instanceof ISelectionProvider) {
                return ((ISelectionProvider)this.workbenchPart).getSelection();
            }
            return null;
        }

        protected abstract void selectionChanged(IWorkbenchPart var1, ISelection var2);

        public void pageActivated(IWorkbenchPage page) {
            if (this.workbenchPage != null) {
                this.workbenchPage.removePartListener((IPartListener)this);
            }
            this.workbenchPage = page;
            if (this.workbenchPage != null) {
                this.workbenchPage.addPartListener((IPartListener)this);
            }
        }

        public void pageClosed(IWorkbenchPage page) {
        }

        public void pageOpened(IWorkbenchPage page) {
        }

        public void partActivated(IWorkbenchPart part) {
            ISelectionProvider selectionProvider;
            if (this.workbenchPart instanceof ISelectionProvider) {
                selectionProvider = (ISelectionProvider)this.workbenchPart;
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.workbenchPart = part;
            if (this.workbenchPart instanceof ISelectionProvider) {
                selectionProvider = (ISelectionProvider)this.workbenchPart;
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionChanged(this.workbenchPart, selectionProvider.getSelection());
            } else if (this.workbenchPart != null) {
                this.selectionChanged(this.workbenchPart, null);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selectionChanged(this.workbenchPart, event.getSelection());
        }

        public void dispose() {
            this.pageActivated(null);
            this.partActivated(null);
        }
    }
}

