/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import java.util.Arrays;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Annotation;
import org.eclipse.equinox.p2.internal.repository.comparator.java.AnnotationComponent;
import org.eclipse.equinox.p2.internal.repository.comparator.java.AnnotationComponentValue;
import org.eclipse.equinox.p2.internal.repository.comparator.java.AnnotationDefaultAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.AttributeNamesConstants;
import org.eclipse.equinox.p2.internal.repository.comparator.java.CharOperation;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileReader;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.CodeAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPoolEntry;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantValueAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.DefaultBytecodeVisitor;
import org.eclipse.equinox.p2.internal.repository.comparator.java.EnclosingMethodAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ExceptionAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ExceptionTableEntry;
import org.eclipse.equinox.p2.internal.repository.comparator.java.FieldInfo;
import org.eclipse.equinox.p2.internal.repository.comparator.java.InnerClassesAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.InnerClassesAttributeEntry;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Messages;
import org.eclipse.equinox.p2.internal.repository.comparator.java.MethodInfo;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ParameterAnnotation;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Signature;
import org.eclipse.equinox.p2.internal.repository.comparator.java.SignatureAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.SourceFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.TypeConstants;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Utility;
import org.eclipse.osgi.util.NLS;

public class Disassembler {
    public static final int DETAILED = 1;
    public static final int COMPACT = 8;
    private static final char[] ANY_EXCEPTION = Messages.classfileformat_anyexceptionhandler.toCharArray();
    private static final String VERSION_UNKNOWN = Messages.classfileformat_versionUnknown;

    private boolean appendModifier(StringBuffer buffer, int accessFlags, int modifierConstant, String modifier, boolean firstModifier) {
        if ((accessFlags & modifierConstant) != 0) {
            if (!firstModifier) {
                buffer.append(Messages.disassembler_space);
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append(modifier);
        }
        return firstModifier;
    }

    private void decodeModifiers(StringBuffer buffer, int accessFlags, int[] checkBits) {
        this.decodeModifiers(buffer, accessFlags, false, false, checkBits);
    }

    private void decodeModifiers(StringBuffer buffer, int accessFlags, boolean printDefault, boolean asBridge, int[] checkBits) {
        if (checkBits == null) {
            return;
        }
        boolean firstModifier = true;
        int[] nArray = checkBits;
        int n = checkBits.length;
        int n2 = 0;
        while (n2 < n) {
            int checkBit = nArray[n2];
            switch (checkBit) {
                case 1: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 1, "public", firstModifier);
                    break;
                }
                case 4: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 4, "protected", firstModifier);
                    break;
                }
                case 2: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 2, "private", firstModifier);
                    break;
                }
                case 1024: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 1024, "abstract", firstModifier);
                    break;
                }
                case 8: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 8, "static", firstModifier);
                    break;
                }
                case 16: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 16, "final", firstModifier);
                    break;
                }
                case 32: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 32, "synchronized", firstModifier);
                    break;
                }
                case 256: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 256, "native", firstModifier);
                    break;
                }
                case 2048: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 2048, "strictfp", firstModifier);
                    break;
                }
                case 128: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 128, "transient", firstModifier);
                    break;
                }
                case 64: {
                    if (asBridge) {
                        firstModifier = this.appendModifier(buffer, accessFlags, 64, "bridge", firstModifier);
                        break;
                    }
                    firstModifier = this.appendModifier(buffer, accessFlags, 64, "volatile", firstModifier);
                    break;
                }
                case 16384: {
                    firstModifier = this.appendModifier(buffer, accessFlags, 16384, "enum", firstModifier);
                }
            }
            ++n2;
        }
        if (!firstModifier) {
            if (!printDefault) {
                buffer.append(Messages.disassembler_space);
            }
        } else if (printDefault) {
            buffer.append("default");
        }
    }

    private void decodeModifiersForField(StringBuffer buffer, int accessFlags) {
        this.decodeModifiers(buffer, accessFlags, new int[]{1, 4, 2, 8, 16, 128, 64, 16384});
    }

    private final void decodeModifiersForInnerClasses(StringBuffer buffer, int accessFlags, boolean printDefault) {
        this.decodeModifiers(buffer, accessFlags, printDefault, false, new int[]{1, 4, 2, 1024, 8, 16});
    }

    private final void decodeModifiersForMethod(StringBuffer buffer, int accessFlags) {
        this.decodeModifiers(buffer, accessFlags, false, true, new int[]{1, 4, 2, 1024, 8, 16, 32, 256, 2048, 64});
    }

    private final void decodeModifiersForType(StringBuffer buffer, int accessFlags) {
        this.decodeModifiers(buffer, accessFlags, new int[]{1, 1024, 16});
    }

    public static String escapeString(String s) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int max = s.length();
        while (i < max) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\u0000': {
                    buffer.append("\\0");
                    break;
                }
                case '\u0001': {
                    buffer.append("\\1");
                    break;
                }
                case '\u0002': {
                    buffer.append("\\2");
                    break;
                }
                case '\u0003': {
                    buffer.append("\\3");
                    break;
                }
                case '\u0004': {
                    buffer.append("\\4");
                    break;
                }
                case '\u0005': {
                    buffer.append("\\5");
                    break;
                }
                case '\u0006': {
                    buffer.append("\\6");
                    break;
                }
                case '\u0007': {
                    buffer.append("\\7");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    static String decodeStringValue(char[] chars) {
        StringBuilder buffer = new StringBuilder();
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\u0000': {
                    buffer.append("\\0");
                    break;
                }
                case '\u0001': {
                    buffer.append("\\1");
                    break;
                }
                case '\u0002': {
                    buffer.append("\\2");
                    break;
                }
                case '\u0003': {
                    buffer.append("\\3");
                    break;
                }
                case '\u0004': {
                    buffer.append("\\4");
                    break;
                }
                case '\u0005': {
                    buffer.append("\\5");
                    break;
                }
                case '\u0006': {
                    buffer.append("\\6");
                    break;
                }
                case '\u0007': {
                    buffer.append("\\7");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++n2;
        }
        return buffer.toString();
    }

    static String decodeStringValue(String s) {
        return Disassembler.decodeStringValue(s.toCharArray());
    }

    public String disassemble(byte[] classFileBytes, String lineSeparator, int mode) throws ClassFormatException {
        try {
            return this.disassemble(new ClassFileReader(classFileBytes, 65535), lineSeparator, mode);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ClassFormatException(e.getMessage(), e);
        }
    }

    private void disassemble(Annotation annotation, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        char[] typeName = CharOperation.replaceOnCopy(annotation.getTypeName(), '/', '.');
        buffer.append(NLS.bind((String)Messages.disassembler_annotationentrystart, (Object[])new String[]{new String(this.returnClassName(Signature.toCharArray(typeName), '.', mode))}));
        AnnotationComponent[] annotationComponentArray = annotation.getComponents();
        int n = annotationComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationComponent component = annotationComponentArray[n2];
            this.disassemble(component, buffer, lineSeparator, tabNumber + 1, mode);
            ++n2;
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_annotationentryend);
    }

    private void disassemble(AnnotationComponent annotationComponent, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(NLS.bind((String)Messages.disassembler_annotationcomponent, (Object[])new String[]{new String(annotationComponent.getComponentName())}));
        this.disassemble(annotationComponent.getComponentValue(), buffer, lineSeparator, tabNumber + 1, mode);
    }

    private void disassemble(AnnotationComponentValue annotationComponentValue, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        switch (annotationComponentValue.getTag()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                ConstantPoolEntry constantPoolEntry = annotationComponentValue.getConstantValue();
                Object value = null;
                switch (constantPoolEntry.getKind()) {
                    case 5: {
                        value = constantPoolEntry.getLongValue() + "L";
                        break;
                    }
                    case 4: {
                        value = constantPoolEntry.getFloatValue() + "f";
                        break;
                    }
                    case 6: {
                        value = Double.toString(constantPoolEntry.getDoubleValue());
                        break;
                    }
                    case 3: {
                        switch (annotationComponentValue.getTag()) {
                            case 67: {
                                value = "'" + (char)constantPoolEntry.getIntegerValue() + "'";
                                break;
                            }
                            case 90: {
                                value = constantPoolEntry.getIntegerValue() == 1 ? "true" : "false";
                                break;
                            }
                            case 66: {
                                value = "(byte) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 83: {
                                value = "(short) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 73: {
                                value = "(int) " + constantPoolEntry.getIntegerValue();
                            }
                        }
                        break;
                    }
                    case 1: {
                        value = "\"" + Disassembler.decodeStringValue(constantPoolEntry.getUtf8Value()) + "\"";
                    }
                }
                buffer.append(NLS.bind((String)Messages.disassembler_annotationdefaultvalue, (Object)value));
                break;
            }
            case 101: {
                char[] typeName = CharOperation.replaceOnCopy(annotationComponentValue.getEnumConstantTypeName(), '/', '.');
                char[] constantName = annotationComponentValue.getEnumConstantName();
                buffer.append(NLS.bind((String)Messages.disassembler_annotationenumvalue, (Object[])new String[]{new String(this.returnClassName(Signature.toCharArray(typeName), '.', mode)), new String(constantName)}));
                break;
            }
            case 99: {
                ConstantPoolEntry constantPoolEntry = annotationComponentValue.getClassInfo();
                char[] className = CharOperation.replaceOnCopy(constantPoolEntry.getUtf8Value(), '/', '.');
                buffer.append(NLS.bind((String)Messages.disassembler_annotationclassvalue, (Object[])new String[]{new String(this.returnClassName(Signature.toCharArray(className), '.', mode))}));
                break;
            }
            case 64: {
                buffer.append(Messages.disassembler_annotationannotationvalue);
                Annotation annotation = annotationComponentValue.getAnnotationValue();
                this.disassemble(annotation, buffer, lineSeparator, tabNumber + 1, mode);
                break;
            }
            case 91: {
                AnnotationComponentValue[] annotationComponentValues;
                buffer.append(Messages.disassembler_annotationarrayvaluestart);
                AnnotationComponentValue[] annotationComponentValueArray = annotationComponentValues = annotationComponentValue.getAnnotationComponentValues();
                int n = annotationComponentValues.length;
                int n2 = 0;
                while (n2 < n) {
                    AnnotationComponentValue annotationComponentValue2 = annotationComponentValueArray[n2];
                    this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
                    this.disassemble(annotationComponentValue2, buffer, lineSeparator, tabNumber + 1, mode);
                    ++n2;
                }
                this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
                buffer.append(Messages.disassembler_annotationarrayvalueend);
            }
        }
    }

    private void disassemble(AnnotationDefaultAttribute annotationDefaultAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_annotationdefaultheader);
        AnnotationComponentValue componentValue = annotationDefaultAttribute.getMemberValue();
        this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
        this.disassemble(componentValue, buffer, lineSeparator, tabNumber + 1, mode);
    }

    private void disassemble(ClassFileReader classFileReader, char[] className, MethodInfo methodInfo, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        int length;
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        char[] methodDescriptor = methodInfo.getDescriptor();
        SignatureAttribute signatureAttribute = (SignatureAttribute)Utility.getAttribute(methodInfo, AttributeNamesConstants.SIGNATURE);
        ClassFileAttribute runtimeVisibleAnnotationsAttribute = Utility.getAttribute(methodInfo, AttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        ClassFileAttribute runtimeInvisibleAnnotationsAttribute = Utility.getAttribute(methodInfo, AttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        ClassFileAttribute runtimeVisibleParameterAnnotationsAttribute = Utility.getAttribute(methodInfo, AttributeNamesConstants.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS);
        ClassFileAttribute runtimeInvisibleParameterAnnotationsAttribute = Utility.getAttribute(methodInfo, AttributeNamesConstants.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS);
        ClassFileAttribute annotationDefaultAttribute = Utility.getAttribute(methodInfo, AttributeNamesConstants.ANNOTATION_DEFAULT);
        if (this.checkMode(mode, 1)) {
            buffer.append(NLS.bind((String)Messages.classfileformat_methoddescriptor, (Object[])new String[]{new String(methodDescriptor)}));
            if (methodInfo.isDeprecated()) {
                buffer.append(Messages.disassembler_deprecated);
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            if (signatureAttribute != null) {
                buffer.append(NLS.bind((String)Messages.disassembler_signatureattributeheader, (Object)new String(signatureAttribute.getSignature())));
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            if (codeAttribute != null) {
                buffer.append(NLS.bind((String)Messages.classfileformat_stacksAndLocals, (Object[])new String[]{Integer.toString(codeAttribute.getMaxStack()), Integer.toString(codeAttribute.getMaxLocals())}));
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((RuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((RuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
        }
        int accessFlags = methodInfo.getAccessFlags();
        this.decodeModifiersForMethod(buffer, accessFlags);
        if (methodInfo.isSynthetic()) {
            buffer.append("synthetic");
            buffer.append(Messages.disassembler_space);
        }
        CharOperation.replace(methodDescriptor, '/', '.');
        boolean isVarArgs = this.isVarArgs(methodInfo);
        char[] methodHeader = null;
        methodHeader = methodInfo.isConstructor() ? Signature.toCharArray(methodDescriptor, this.returnClassName(className, '.', 8), null, !this.checkMode(mode, 8), false, isVarArgs) : (methodInfo.isClinit() ? Messages.classfileformat_clinitname.toCharArray() : Signature.toCharArray(methodDescriptor, methodInfo.getName(), null, !this.checkMode(mode, 8), true, isVarArgs));
        if (this.checkMode(mode, 1) && (runtimeInvisibleParameterAnnotationsAttribute != null || runtimeVisibleParameterAnnotationsAttribute != null)) {
            ClassFileAttribute attribute;
            ParameterAnnotation[] invisibleParameterAnnotations = null;
            ParameterAnnotation[] visibleParameterAnnotations = null;
            length = -1;
            if (runtimeInvisibleParameterAnnotationsAttribute != null) {
                attribute = (RuntimeInvisibleParameterAnnotationsAttribute)runtimeInvisibleParameterAnnotationsAttribute;
                invisibleParameterAnnotations = ((RuntimeInvisibleParameterAnnotationsAttribute)attribute).getParameterAnnotations();
                length = invisibleParameterAnnotations.length;
            }
            if (runtimeVisibleParameterAnnotationsAttribute != null) {
                attribute = (RuntimeVisibleParameterAnnotationsAttribute)runtimeVisibleParameterAnnotationsAttribute;
                visibleParameterAnnotations = ((RuntimeVisibleParameterAnnotationsAttribute)attribute).getParameterAnnotations();
                length = visibleParameterAnnotations.length;
            }
            int insertionPosition = CharOperation.indexOf('(', methodHeader) + 1;
            int start = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(methodHeader, 0, insertionPosition);
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                int stringBufferSize = stringBuffer.length();
                if (runtimeVisibleParameterAnnotationsAttribute != null) {
                    this.disassembleAsModifier((RuntimeVisibleParameterAnnotationsAttribute)runtimeVisibleParameterAnnotationsAttribute, stringBuffer, i, lineSeparator, tabNumber, mode);
                }
                if (runtimeInvisibleParameterAnnotationsAttribute != null) {
                    if (stringBuffer.length() != stringBufferSize) {
                        stringBuffer.append(' ');
                        stringBufferSize = stringBuffer.length();
                    }
                    this.disassembleAsModifier((RuntimeInvisibleParameterAnnotationsAttribute)runtimeInvisibleParameterAnnotationsAttribute, stringBuffer, i, lineSeparator, tabNumber, mode);
                }
                if (i == 0 && stringBuffer.length() != stringBufferSize) {
                    stringBuffer.append(' ');
                }
                if ((insertionPosition = CharOperation.indexOf(',', methodHeader, (start = insertionPosition) + 1) + 1) == 0) {
                    stringBuffer.append(methodHeader, start, methodHeader.length - start);
                } else {
                    stringBuffer.append(methodHeader, start, insertionPosition - start);
                }
                ++i;
            }
            buffer.append(stringBuffer);
        } else {
            buffer.append(methodHeader);
        }
        ExceptionAttribute exceptionAttribute = methodInfo.getExceptionAttribute();
        if (exceptionAttribute != null) {
            buffer.append(" throws ");
            char[][] exceptionNames = exceptionAttribute.getExceptionNames();
            length = exceptionNames.length;
            int i = 0;
            while (i < length) {
                if (i != 0) {
                    buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space);
                }
                char[] exceptionName = exceptionNames[i];
                CharOperation.replace(exceptionName, '/', '.');
                buffer.append(this.returnClassName(exceptionName, '.', mode));
                ++i;
            }
        }
        if (this.checkMode(mode, 1) && annotationDefaultAttribute != null) {
            buffer.append(" default ");
            this.disassembleAsModifier((AnnotationDefaultAttribute)annotationDefaultAttribute, buffer, lineSeparator, tabNumber, mode);
        }
        buffer.append(Messages.disassembler_endofmethodheader);
        if (this.checkMode(mode, 1)) {
            if (codeAttribute != null) {
                this.disassemble(codeAttribute, methodDescriptor, (accessFlags & 8) != 0, buffer, lineSeparator, tabNumber, mode);
            }
            if (annotationDefaultAttribute != null) {
                this.disassemble((AnnotationDefaultAttribute)annotationDefaultAttribute, buffer, lineSeparator, tabNumber, mode);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassemble((RuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
            }
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassemble((RuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
            }
            if (runtimeVisibleParameterAnnotationsAttribute != null) {
                this.disassemble((RuntimeVisibleParameterAnnotationsAttribute)runtimeVisibleParameterAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
            }
            if (runtimeInvisibleParameterAnnotationsAttribute != null) {
                this.disassemble((RuntimeInvisibleParameterAnnotationsAttribute)runtimeInvisibleParameterAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
            }
        }
    }

    private String disassemble(ClassFileReader classFileReader, String lineSeparator, int mode) {
        char[][] superclassInterfaces;
        int length;
        if (classFileReader == null) {
            return "";
        }
        char[] className = classFileReader.getClassName();
        if (className == null) {
            return "";
        }
        className = CharOperation.replaceOnCopy(className, '/', '.');
        int accessFlags = classFileReader.getAccessFlags();
        boolean isEnum = (accessFlags & 0x4000) != 0;
        StringBuffer buffer = new StringBuffer();
        SourceFileAttribute sourceAttribute = classFileReader.getSourceFileAttribute();
        ClassFileAttribute classFileAttribute = Utility.getAttribute(classFileReader, AttributeNamesConstants.SIGNATURE);
        SignatureAttribute signatureAttribute = (SignatureAttribute)classFileAttribute;
        if (this.checkMode(mode, 1)) {
            int minorVersion = classFileReader.getMinorVersion();
            int majorVersion = classFileReader.getMajorVersion();
            buffer.append(Messages.disassembler_begincommentline);
            if (sourceAttribute != null) {
                buffer.append(Messages.disassembler_sourceattributeheader);
                buffer.append(sourceAttribute.getSourceFileName());
            }
            String versionNumber = VERSION_UNKNOWN;
            if (minorVersion == 3 && majorVersion == 45) {
                versionNumber = "1.1";
            } else if (minorVersion == 0 && majorVersion == 46) {
                versionNumber = "1.2";
            } else if (minorVersion == 0 && majorVersion == 47) {
                versionNumber = "1.3";
            } else if (minorVersion == 0 && majorVersion == 48) {
                versionNumber = "1.4";
            } else if (minorVersion == 0 && majorVersion == 49) {
                versionNumber = "1.5";
            } else if (minorVersion == 0 && majorVersion == 50) {
                versionNumber = "1.6";
            } else if (minorVersion == 0 && majorVersion == 51) {
                versionNumber = "1.7";
            }
            buffer.append(NLS.bind((String)Messages.classfileformat_versiondetails, (Object[])new String[]{versionNumber, Integer.toString(majorVersion), Integer.toString(minorVersion), ((accessFlags & 0x20) != 0 ? Messages.classfileformat_superflagisset : Messages.classfileformat_superflagisnotset) + (this.isDeprecated(classFileReader) ? ", deprecated" : "")}));
            this.writeNewLine(buffer, lineSeparator, 0);
            if (signatureAttribute != null) {
                buffer.append(NLS.bind((String)Messages.disassembler_signatureattributeheader, (Object)new String(signatureAttribute.getSignature())));
                this.writeNewLine(buffer, lineSeparator, 0);
            }
        }
        InnerClassesAttribute innerClassesAttribute = classFileReader.getInnerClassesAttribute();
        ClassFileAttribute runtimeVisibleAnnotationsAttribute = Utility.getAttribute(classFileReader, AttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        ClassFileAttribute runtimeInvisibleAnnotationsAttribute = Utility.getAttribute(classFileReader, AttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (this.checkMode(mode, 1)) {
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((RuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, 0, mode);
                this.writeNewLine(buffer, lineSeparator, 0);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((RuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, 0, mode);
                this.writeNewLine(buffer, lineSeparator, 0);
            }
        }
        boolean decoded = false;
        if (innerClassesAttribute != null) {
            InnerClassesAttributeEntry[] entries;
            InnerClassesAttributeEntry[] innerClassesAttributeEntryArray = entries = innerClassesAttribute.getInnerClassAttributesEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                InnerClassesAttributeEntry entry = innerClassesAttributeEntryArray[n2];
                char[] innerClassName = entry.getInnerClassName();
                if (innerClassName != null && Arrays.equals(classFileReader.getClassName(), innerClassName)) {
                    this.decodeModifiersForInnerClasses(buffer, entry.getAccessFlags(), false);
                    decoded = true;
                }
                ++n2;
            }
        }
        if (!decoded) {
            this.decodeModifiersForType(buffer, accessFlags);
            if (this.isSynthetic(classFileReader)) {
                buffer.append("synthetic");
                buffer.append(Messages.disassembler_space);
            }
        }
        boolean isAnnotation = (accessFlags & 0x2000) != 0;
        boolean isInterface = false;
        if (isEnum) {
            buffer.append("enum ");
        } else if (classFileReader.isClass()) {
            buffer.append("class ");
        } else {
            if (isAnnotation) {
                buffer.append("@");
            }
            buffer.append("interface ");
            isInterface = true;
        }
        buffer.append(className);
        char[] superclassName = classFileReader.getSuperclassName();
        if (superclassName != null) {
            CharOperation.replace(superclassName, '/', '.');
            if (!this.isJavaLangObject(superclassName) && !isEnum) {
                buffer.append(" extends ");
                buffer.append(this.returnClassName(superclassName, '.', mode));
            }
        }
        if (!isAnnotation && (length = (superclassInterfaces = classFileReader.getInterfaceNames()).length) != 0) {
            if (isInterface) {
                buffer.append(" extends ");
            } else {
                buffer.append(" implements ");
            }
            int i = 0;
            while (i < length) {
                if (i != 0) {
                    buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space);
                }
                char[] superinterface = superclassInterfaces[i];
                CharOperation.replace(superinterface, '/', '.');
                buffer.append(this.returnClassName(superinterface, '.', mode));
                ++i;
            }
        }
        buffer.append(Messages.disassembler_opentypedeclaration);
        this.disassembleTypeMembers(classFileReader, className, buffer, lineSeparator, 1, mode, isEnum);
        if (this.checkMode(mode, 1)) {
            ClassFileAttribute[] attributes = classFileReader.getAttributes();
            int length2 = attributes.length;
            EnclosingMethodAttribute enclosingMethodAttribute = this.getEnclosingMethodAttribute(classFileReader);
            int remainingAttributesLength = length2;
            if (innerClassesAttribute != null) {
                --remainingAttributesLength;
            }
            if (enclosingMethodAttribute != null) {
                --remainingAttributesLength;
            }
            if (sourceAttribute != null) {
                --remainingAttributesLength;
            }
            if (signatureAttribute != null) {
                --remainingAttributesLength;
            }
            if (innerClassesAttribute != null || enclosingMethodAttribute != null || remainingAttributesLength != 0) {
                this.writeNewLine(buffer, lineSeparator, 0);
            }
            if (innerClassesAttribute != null) {
                this.disassemble(innerClassesAttribute, buffer, lineSeparator, 1);
            }
            if (enclosingMethodAttribute != null) {
                this.disassemble(enclosingMethodAttribute, buffer, lineSeparator, 0);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassemble((RuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, 0, mode);
            }
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassemble((RuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, 0, mode);
            }
        }
        this.writeNewLine(buffer, lineSeparator, 0);
        buffer.append(Messages.disassembler_closetypedeclaration);
        return buffer.toString();
    }

    private boolean isJavaLangObject(char[] className) {
        return Arrays.equals((Object[])TypeConstants.JAVA_LANG_OBJECT, (Object[])CharOperation.splitOn('.', className));
    }

    private boolean isVarArgs(MethodInfo methodInfo) {
        int accessFlags = methodInfo.getAccessFlags();
        if ((accessFlags & 0x80) != 0) {
            return true;
        }
        return Utility.getAttribute(methodInfo, AttributeNamesConstants.VAR_ARGS) != null;
    }

    private void disassemble(CodeAttribute codeAttribute, char[] methodDescriptor, boolean isStatic, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber - 1);
        DefaultBytecodeVisitor visitor = new DefaultBytecodeVisitor(codeAttribute, methodDescriptor, isStatic, buffer, lineSeparator, tabNumber, mode);
        try {
            codeAttribute.traverse(visitor);
        }
        catch (ClassFormatException e) {
            this.dumpTab(tabNumber + 2, buffer);
            buffer.append(Messages.classformat_classformatexception);
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        }
        int exceptionTableLength = codeAttribute.getExceptionTableLength();
        if (exceptionTableLength != 0) {
            int tabNumberForExceptionAttribute = tabNumber + 2;
            this.dumpTab(tabNumberForExceptionAttribute, buffer);
            ExceptionTableEntry[] exceptionTableEntries = codeAttribute.getExceptionTable();
            buffer.append(Messages.disassembler_exceptiontableheader);
            this.writeNewLine(buffer, lineSeparator, tabNumberForExceptionAttribute + 1);
            int i = 0;
            while (i < exceptionTableLength) {
                char[] catchType;
                ExceptionTableEntry exceptionTableEntry;
                if (i != 0) {
                    this.writeNewLine(buffer, lineSeparator, tabNumberForExceptionAttribute + 1);
                }
                if ((exceptionTableEntry = exceptionTableEntries[i]).getCatchTypeIndex() != 0) {
                    catchType = exceptionTableEntry.getCatchType();
                    CharOperation.replace(catchType, '/', '.');
                    catchType = this.returnClassName(catchType, '.', mode);
                } else {
                    catchType = ANY_EXCEPTION;
                }
                buffer.append(NLS.bind((String)Messages.classfileformat_exceptiontableentry, (Object[])new String[]{Integer.toString(exceptionTableEntry.getStartPC()), Integer.toString(exceptionTableEntry.getEndPC()), Integer.toString(exceptionTableEntry.getHandlerPC()), new String(catchType)}));
                ++i;
            }
        }
    }

    private void disassemble(EnclosingMethodAttribute enclosingMethodAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_enclosingmethodheader);
        buffer.append(" ").append(enclosingMethodAttribute.getEnclosingClass());
        if (enclosingMethodAttribute.getMethodNameAndTypeIndex() != 0) {
            buffer.append(".").append(enclosingMethodAttribute.getMethodName()).append(enclosingMethodAttribute.getMethodDescriptor());
        }
    }

    private void disassemble(FieldInfo fieldInfo, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        char[] fieldDescriptor = fieldInfo.getDescriptor();
        SignatureAttribute signatureAttribute = (SignatureAttribute)Utility.getAttribute(fieldInfo, AttributeNamesConstants.SIGNATURE);
        if (this.checkMode(mode, 1)) {
            buffer.append(NLS.bind((String)Messages.classfileformat_fieldddescriptor, (Object[])new String[]{new String(fieldDescriptor)}));
            if (fieldInfo.isDeprecated()) {
                buffer.append(Messages.disassembler_deprecated);
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            if (signatureAttribute != null) {
                buffer.append(NLS.bind((String)Messages.disassembler_signatureattributeheader, (Object)new String(signatureAttribute.getSignature())));
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
        }
        ClassFileAttribute runtimeVisibleAnnotationsAttribute = Utility.getAttribute(fieldInfo, AttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        ClassFileAttribute runtimeInvisibleAnnotationsAttribute = Utility.getAttribute(fieldInfo, AttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (this.checkMode(mode, 1)) {
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((RuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((RuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
        }
        this.decodeModifiersForField(buffer, fieldInfo.getAccessFlags());
        if (fieldInfo.isSynthetic()) {
            buffer.append("synthetic");
            buffer.append(Messages.disassembler_space);
        }
        buffer.append(this.returnClassName(this.getSignatureForField(fieldDescriptor), '.', mode));
        buffer.append(' ');
        buffer.append(new String(fieldInfo.getName()));
        ConstantValueAttribute constantValueAttribute = fieldInfo.getConstantValueAttribute();
        if (constantValueAttribute != null) {
            buffer.append(Messages.disassembler_fieldhasconstant);
            ConstantPoolEntry constantPoolEntry = constantValueAttribute.getConstantValue();
            switch (constantPoolEntry.getKind()) {
                case 5: {
                    buffer.append(constantPoolEntry.getLongValue() + "L");
                    break;
                }
                case 4: {
                    buffer.append(constantPoolEntry.getFloatValue() + "f");
                    break;
                }
                case 6: {
                    buffer.append(constantPoolEntry.getDoubleValue());
                    break;
                }
                case 3: {
                    switch (fieldDescriptor[0]) {
                        case 'C': {
                            buffer.append("'" + (char)constantPoolEntry.getIntegerValue() + "'");
                            break;
                        }
                        case 'Z': {
                            buffer.append(constantPoolEntry.getIntegerValue() == 1 ? "true" : "false");
                            break;
                        }
                        case 'B': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                            break;
                        }
                        case 'S': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                            break;
                        }
                        case 'I': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                        }
                    }
                    break;
                }
                case 8: {
                    buffer.append("\"" + Disassembler.decodeStringValue(constantPoolEntry.getStringValue()) + "\"");
                }
            }
        }
        buffer.append(Messages.disassembler_endoffieldheader);
        if (this.checkMode(mode, 1)) {
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassemble((RuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
            }
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassemble((RuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber, mode);
            }
        }
    }

    private void disassemble(InnerClassesAttribute innerClassesAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        buffer.append(Messages.disassembler_innerattributesheader);
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        InnerClassesAttributeEntry[] innerClassesAttributeEntries = innerClassesAttribute.getInnerClassAttributesEntries();
        int length = innerClassesAttributeEntries.length;
        if (length > 1) {
            char[] EMPTY_CHAR_ARRAY = "".toCharArray();
            Arrays.sort(innerClassesAttributeEntries, (o1, o2) -> {
                char[] innerClassName1 = o1.getInnerClassName();
                char[] innerClassName2 = o2.getInnerClassName();
                char[] innerName1 = o1.getInnerName();
                char[] innerName2 = o2.getInnerName();
                char[] outerClassName1 = o1.getOuterClassName();
                char[] outerClassName2 = o2.getOuterClassName();
                StringBuilder buffer1 = new StringBuilder();
                buffer1.append(innerClassName1 == null ? EMPTY_CHAR_ARRAY : innerClassName1);
                buffer1.append(innerName1 == null ? EMPTY_CHAR_ARRAY : innerName1);
                buffer1.append(outerClassName1 == null ? EMPTY_CHAR_ARRAY : outerClassName1);
                StringBuilder buffer2 = new StringBuilder();
                buffer2.append(innerClassName2 == null ? EMPTY_CHAR_ARRAY : innerClassName2);
                buffer2.append(innerName2 == null ? EMPTY_CHAR_ARRAY : innerName2);
                buffer2.append(outerClassName2 == null ? EMPTY_CHAR_ARRAY : outerClassName2);
                return buffer1.toString().compareTo(buffer2.toString());
            });
        }
        int i = 0;
        while (i < length) {
            if (i != 0) {
                buffer.append(Messages.disassembler_comma);
                this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
            }
            InnerClassesAttributeEntry innerClassesAttributeEntry = innerClassesAttributeEntries[i];
            int innerClassNameIndex = innerClassesAttributeEntry.getInnerClassNameIndex();
            int outerClassNameIndex = innerClassesAttributeEntry.getOuterClassNameIndex();
            int innerNameIndex = innerClassesAttributeEntry.getInnerNameIndex();
            int accessFlags = innerClassesAttributeEntry.getAccessFlags();
            buffer.append(Messages.disassembler_openinnerclassentry).append(Messages.disassembler_inner_class_info_name);
            if (innerClassNameIndex != 0) {
                buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getInnerClassName());
            }
            buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_outer_class_info_name);
            if (outerClassNameIndex != 0) {
                buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getOuterClassName());
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.dumpTab(tabNumber, buffer);
            buffer.append(Messages.disassembler_space);
            buffer.append(Messages.disassembler_inner_name);
            if (innerNameIndex != 0) {
                buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getInnerName());
            }
            buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_inner_accessflags).append(accessFlags).append(Messages.disassembler_space);
            this.decodeModifiersForInnerClasses(buffer, accessFlags, true);
            buffer.append(Messages.disassembler_closeinnerclassentry);
            ++i;
        }
    }

    private void disassemble(int index, ParameterAnnotation parameterAnnotation, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        Annotation[] annotations = parameterAnnotation.getAnnotations();
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(NLS.bind((String)Messages.disassembler_parameterannotationentrystart, (Object[])new String[]{Integer.toString(index), Integer.toString(annotations.length)}));
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.disassemble(annotation, buffer, lineSeparator, tabNumber + 1, mode);
            ++n2;
        }
    }

    private void disassemble(RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        Annotation[] annotations;
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimeinvisibleannotationsattributeheader);
        Annotation[] annotationArray = annotations = runtimeInvisibleAnnotationsAttribute.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.disassemble(annotation, buffer, lineSeparator, tabNumber + 1, mode);
            ++n2;
        }
    }

    private void disassemble(RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimeinvisibleparameterannotationsattributeheader);
        ParameterAnnotation[] parameterAnnotations = runtimeInvisibleParameterAnnotationsAttribute.getParameterAnnotations();
        int i = 0;
        int max = parameterAnnotations.length;
        while (i < max) {
            this.disassemble(i, parameterAnnotations[i], buffer, lineSeparator, tabNumber + 1, mode);
            ++i;
        }
    }

    private void disassemble(RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        Annotation[] annotations;
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimevisibleannotationsattributeheader);
        Annotation[] annotationArray = annotations = runtimeVisibleAnnotationsAttribute.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.disassemble(annotation, buffer, lineSeparator, tabNumber + 1, mode);
            ++n2;
        }
    }

    private void disassemble(RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimevisibleparameterannotationsattributeheader);
        ParameterAnnotation[] parameterAnnotations = runtimeVisibleParameterAnnotationsAttribute.getParameterAnnotations();
        int i = 0;
        int max = parameterAnnotations.length;
        while (i < max) {
            this.disassemble(i, parameterAnnotations[i], buffer, lineSeparator, tabNumber + 1, mode);
            ++i;
        }
    }

    private void disassembleAsModifier(Annotation annotation, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        char[] typeName = CharOperation.replaceOnCopy(annotation.getTypeName(), '/', '.');
        buffer.append('@').append(this.returnClassName(Signature.toCharArray(typeName), '.', mode));
        AnnotationComponent[] components = annotation.getComponents();
        int length = components.length;
        if (length != 0) {
            buffer.append('(');
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    buffer.append(',');
                    this.writeNewLine(buffer, lineSeparator, tabNumber);
                }
                this.disassembleAsModifier(components[i], buffer, lineSeparator, tabNumber + 1, mode);
                ++i;
            }
            buffer.append(')');
        }
    }

    private void disassembleAsModifier(AnnotationComponent annotationComponent, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        buffer.append(annotationComponent.getComponentName()).append('=');
        this.disassembleAsModifier(annotationComponent.getComponentValue(), buffer, lineSeparator, tabNumber + 1, mode);
    }

    private void disassembleAsModifier(AnnotationComponentValue annotationComponentValue, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        switch (annotationComponentValue.getTag()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                ConstantPoolEntry constantPoolEntry = annotationComponentValue.getConstantValue();
                Object value = null;
                switch (constantPoolEntry.getKind()) {
                    case 5: {
                        value = constantPoolEntry.getLongValue() + "L";
                        break;
                    }
                    case 4: {
                        value = constantPoolEntry.getFloatValue() + "f";
                        break;
                    }
                    case 6: {
                        value = Double.toString(constantPoolEntry.getDoubleValue());
                        break;
                    }
                    case 3: {
                        switch (annotationComponentValue.getTag()) {
                            case 67: {
                                value = "'" + (char)constantPoolEntry.getIntegerValue() + "'";
                                break;
                            }
                            case 90: {
                                value = constantPoolEntry.getIntegerValue() == 1 ? "true" : "false";
                                break;
                            }
                            case 66: {
                                value = "(byte) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 83: {
                                value = "(short) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 73: {
                                value = "(int) " + constantPoolEntry.getIntegerValue();
                            }
                        }
                        break;
                    }
                    case 1: {
                        value = "\"" + Disassembler.decodeStringValue(constantPoolEntry.getUtf8Value()) + "\"";
                    }
                }
                buffer.append((String)value);
                break;
            }
            case 101: {
                char[] typeName = CharOperation.replaceOnCopy(annotationComponentValue.getEnumConstantTypeName(), '/', '.');
                char[] constantName = annotationComponentValue.getEnumConstantName();
                buffer.append(this.returnClassName(Signature.toCharArray(typeName), '.', mode)).append('.').append(constantName);
                break;
            }
            case 99: {
                ConstantPoolEntry constantPoolEntry = annotationComponentValue.getClassInfo();
                char[] className = CharOperation.replaceOnCopy(constantPoolEntry.getUtf8Value(), '/', '.');
                buffer.append(this.returnClassName(Signature.toCharArray(className), '.', mode));
                break;
            }
            case 64: {
                Annotation annotation = annotationComponentValue.getAnnotationValue();
                this.disassembleAsModifier(annotation, buffer, lineSeparator, tabNumber + 1, mode);
                break;
            }
            case 91: {
                AnnotationComponentValue[] annotationComponentValues = annotationComponentValue.getAnnotationComponentValues();
                buffer.append('{');
                int i = 0;
                int max = annotationComponentValues.length;
                while (i < max) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    this.disassembleAsModifier(annotationComponentValues[i], buffer, lineSeparator, tabNumber + 1, mode);
                    ++i;
                }
                buffer.append('}');
            }
        }
    }

    private void disassembleAsModifier(AnnotationDefaultAttribute annotationDefaultAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        AnnotationComponentValue componentValue = annotationDefaultAttribute.getMemberValue();
        this.disassembleAsModifier(componentValue, buffer, lineSeparator, tabNumber + 1, mode);
    }

    private void disassembleAsModifier(RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        Annotation[] annotationArray = runtimeInvisibleAnnotationsAttribute.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.disassembleAsModifier(annotation, buffer, lineSeparator, tabNumber + 1, mode);
            ++n2;
        }
    }

    private void disassembleAsModifier(RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute, StringBuffer buffer, int index, String lineSeparator, int tabNumber, int mode) {
        ParameterAnnotation[] parameterAnnotations = runtimeInvisibleParameterAnnotationsAttribute.getParameterAnnotations();
        if (parameterAnnotations.length > index) {
            this.disassembleAsModifier(parameterAnnotations[index], buffer, lineSeparator, tabNumber + 1, mode);
        }
    }

    private void disassembleAsModifier(RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute, StringBuffer buffer, int index, String lineSeparator, int tabNumber, int mode) {
        ParameterAnnotation[] parameterAnnotations = runtimeVisibleParameterAnnotationsAttribute.getParameterAnnotations();
        if (parameterAnnotations.length > index) {
            this.disassembleAsModifier(parameterAnnotations[index], buffer, lineSeparator, tabNumber + 1, mode);
        }
    }

    private void disassembleAsModifier(ParameterAnnotation parameterAnnotation, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        Annotation[] annotations = parameterAnnotation.getAnnotations();
        int i = 0;
        int max = annotations.length;
        while (i < max) {
            if (i > 0) {
                buffer.append(' ');
            }
            this.disassembleAsModifier(annotations[i], buffer, lineSeparator, tabNumber + 1, mode);
            ++i;
        }
    }

    private void disassembleAsModifier(RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        Annotation[] annotations = runtimeVisibleAnnotationsAttribute.getAnnotations();
        int i = 0;
        int max = annotations.length;
        while (i < max) {
            if (i > 0) {
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            this.disassembleAsModifier(annotations[i], buffer, lineSeparator, tabNumber + 1, mode);
            ++i;
        }
    }

    private void disassembleTypeMembers(ClassFileReader classFileReader, char[] className, StringBuffer buffer, String lineSeparator, int tabNumber, int mode, boolean isEnum) {
        FieldInfo[] fields = classFileReader.getFieldInfos();
        Arrays.sort(fields, (fieldInfo1, fieldInfo2) -> {
            int compare = new String(fieldInfo1.getName()).compareTo(new String(fieldInfo2.getName()));
            if (compare == 0) {
                return new String(fieldInfo1.getDescriptor()).compareTo(new String(fieldInfo2.getDescriptor()));
            }
            return compare;
        });
        FieldInfo[] fieldInfoArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldInfo field = fieldInfoArray[n2];
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.disassemble(field, buffer, lineSeparator, tabNumber, mode);
            ++n2;
        }
        MethodInfo[] methods = classFileReader.getMethodInfos();
        Arrays.sort(methods, (methodInfo1, methodInfo2) -> {
            int compare = new String(methodInfo1.getName()).compareTo(new String(methodInfo2.getName()));
            if (compare == 0) {
                return new String(methodInfo1.getDescriptor()).compareTo(new String(methodInfo2.getDescriptor()));
            }
            return compare;
        });
        MethodInfo[] methodInfoArray = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            MethodInfo method = methodInfoArray[n];
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.disassemble(classFileReader, className, method, buffer, lineSeparator, tabNumber, mode);
            ++n;
        }
    }

    private final void dumpTab(int tabNumber, StringBuffer buffer) {
        int i = 0;
        while (i < tabNumber) {
            buffer.append(Messages.disassembler_indentation);
            ++i;
        }
    }

    private EnclosingMethodAttribute getEnclosingMethodAttribute(ClassFileReader classFileReader) {
        ClassFileAttribute[] classFileAttributeArray = classFileReader.getAttributes();
        int n = classFileAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassFileAttribute attribute = classFileAttributeArray[n2];
            if (Arrays.equals(attribute.getAttributeName(), AttributeNamesConstants.ENCLOSING_METHOD)) {
                return (EnclosingMethodAttribute)attribute;
            }
            ++n2;
        }
        return null;
    }

    private char[] getSignatureForField(char[] fieldDescriptor) {
        char[] newFieldDescriptor = CharOperation.replaceOnCopy(fieldDescriptor, '/', '.');
        newFieldDescriptor = CharOperation.replaceOnCopy(newFieldDescriptor, '$', '%');
        char[] fieldDescriptorSignature = Signature.toCharArray(newFieldDescriptor);
        CharOperation.replace(fieldDescriptorSignature, '%', '$');
        return fieldDescriptorSignature;
    }

    private boolean isDeprecated(ClassFileReader classFileReader) {
        ClassFileAttribute[] classFileAttributeArray = classFileReader.getAttributes();
        int n = classFileAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassFileAttribute attribute = classFileAttributeArray[n2];
            if (Arrays.equals(attribute.getAttributeName(), AttributeNamesConstants.DEPRECATED)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isSynthetic(ClassFileReader classFileReader) {
        int flags = classFileReader.getAccessFlags();
        if ((flags & 0x1000) != 0) {
            return true;
        }
        ClassFileAttribute[] classFileAttributeArray = classFileReader.getAttributes();
        int n = classFileAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassFileAttribute attribute = classFileAttributeArray[n2];
            if (Arrays.equals(attribute.getAttributeName(), AttributeNamesConstants.SYNTHETIC)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkMode(int mode, int flag) {
        return (mode & flag) != 0;
    }

    private boolean isCompact(int mode) {
        return (mode & 8) != 0;
    }

    private char[] returnClassName(char[] classInfoName, char separator, int mode) {
        int lastIndexOfSlash;
        if (classInfoName.length == 0) {
            return CharOperation.NO_CHAR;
        }
        if (this.isCompact(mode) && (lastIndexOfSlash = CharOperation.lastIndexOf(separator, classInfoName)) != -1) {
            return CharOperation.subarray(classInfoName, lastIndexOfSlash + 1, classInfoName.length);
        }
        return classInfoName;
    }

    private void writeNewLine(StringBuffer buffer, String lineSeparator, int tabNumber) {
        buffer.append(lineSeparator);
        this.dumpTab(tabNumber, buffer);
    }
}

