/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class RegistryCommandProvider
implements CommandProvider {
    private static final String NEW_LINE = "\r\n";
    private static final String indent = "   ";
    private boolean verbose = false;

    public String getHelp() {
        return this.getHelp(null);
    }

    private String getHelp(String commandName) {
        boolean all = commandName == null;
        StringBuilder sb = new StringBuilder();
        if (all) {
            sb.append("---Extension Registry Commands---");
            sb.append(NEW_LINE);
        }
        if (all || "ns".equals(commandName)) {
            sb.append("\tns [-v] [name] - display extension points in the namespace; add -v to display extensions");
            sb.append(NEW_LINE);
        }
        if (all || "pt".equals(commandName)) {
            sb.append("\tpt [-v] uniqueExtensionPointId - display the extension point and extensions; add -v to display config elements");
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public void _ns(CommandInterpreter ci) throws Exception {
        String namespace = this.getArgument(ci);
        if (namespace == null) {
            String[] namespaces = RegistryFactory.getRegistry().getNamespaces();
            ci.println((Object)"Namespace(s):");
            ci.println((Object)"-------------------");
            String[] stringArray = namespaces;
            int n = namespaces.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                ci.println((Object)n3);
                ++n2;
            }
            return;
        }
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint[] extpts = registry.getExtensionPoints(namespace);
        ci.println((Object)"Extension point(s):");
        ci.println((Object)"-------------------");
        IExtensionPoint[] iExtensionPointArray = extpts;
        int n = extpts.length;
        int n4 = 0;
        while (n4 < n) {
            IExtensionPoint extpt = iExtensionPointArray[n4];
            this.displayExtensionPoint(extpt, ci);
            ++n4;
        }
        if (this.verbose) {
            IExtension[] exts;
            ci.println((Object)"\nExtension(s):");
            ci.println((Object)"-------------------");
            IExtension[] iExtensionArray = exts = RegistryFactory.getRegistry().getExtensions(namespace);
            int n5 = exts.length;
            n = 0;
            while (n < n5) {
                IExtension ext = iExtensionArray[n];
                this.displayExtension(ext, ci, true);
                ++n;
            }
        }
    }

    public void _pt(CommandInterpreter ci) throws Exception {
        String extensionPointId = this.getArgument(ci);
        if (extensionPointId == null) {
            return;
        }
        IExtensionPoint extpt = RegistryFactory.getRegistry().getExtensionPoint(extensionPointId);
        if (extpt == null) {
            return;
        }
        ci.print((Object)"Extension point: ");
        this.displayExtensionPoint(extpt, ci);
        IExtension[] exts = extpt.getExtensions();
        ci.println((Object)"\nExtension(s):");
        ci.println((Object)"-------------------");
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            this.displayExtension(ext, ci, false);
            if (this.verbose) {
                IConfigurationElement[] ce;
                IConfigurationElement[] iConfigurationElementArray = ce = ext.getConfigurationElements();
                int n3 = ce.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce1 = iConfigurationElementArray[n4];
                    this.displayConfigElement(ci, ce1, 1);
                    ++n4;
                }
                ci.println();
            }
            ++n2;
        }
    }

    public Object _help(CommandInterpreter intp) {
        String commandName = intp.nextArgument();
        if (commandName == null) {
            return Boolean.FALSE;
        }
        String help = this.getHelp(commandName);
        if (help.length() > 0) {
            return help;
        }
        return Boolean.FALSE;
    }

    private String getArgument(CommandInterpreter ci) {
        String firstParm = ci.nextArgument();
        if ("-v".equals(firstParm)) {
            this.verbose = true;
            return ci.nextArgument();
        }
        this.verbose = false;
        return firstParm;
    }

    private void displayExtensionPoint(IExtensionPoint extentionPoint, CommandInterpreter ci) {
        if (extentionPoint == null) {
            return;
        }
        ci.println((Object)(extentionPoint.getUniqueIdentifier() + " [from " + extentionPoint.getContributor().getName() + "]"));
    }

    private void displayExtension(IExtension extention, CommandInterpreter ci, boolean full) {
        if (extention == null) {
            return;
        }
        if (full) {
            ci.print((Object)("Id: " + extention.getUniqueIdentifier()));
            ci.print((Object)(" PointId: " + extention.getExtensionPointUniqueIdentifier()));
            ci.println((Object)(" [from " + extention.getContributor().getName() + "]"));
        } else {
            ci.println((Object)(extention.getUniqueIdentifier() + " [from " + extention.getContributor().getName() + "]"));
        }
    }

    private void displayConfigElement(CommandInterpreter ci, IConfigurationElement ce, int level) throws Exception {
        IConfigurationElement[] children;
        String[] attrs;
        String spacing = this.spacing(ci, level);
        ci.println((Object)(spacing + "<" + ce.getName() + ">"));
        String[] stringArray = attrs = ce.getAttributeNames();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            ci.println((Object)(indent + spacing + attr + " = " + ce.getAttribute(attr)));
            ++n2;
        }
        String value = ce.getValue();
        if (value != null) {
            ci.println((Object)(indent + spacing + value));
        }
        IConfigurationElement[] iConfigurationElementArray = children = ce.getChildren();
        int n3 = children.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement child = iConfigurationElementArray[n4];
            this.displayConfigElement(ci, child, level + 1);
            ++n4;
        }
        ci.println((Object)(spacing + "</" + ce.getName() + ">"));
    }

    private String spacing(CommandInterpreter ci, int level) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < level) {
            b.append(indent);
            ++i;
        }
        return b.toString();
    }
}

