/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.AbstractLineTracker;
import org.eclipse.jface.text.MultiStringMatcher;
import org.eclipse.jface.text.TextUtilities;

public class ConfigurableLineTracker
extends AbstractLineTracker {
    private final String[] fDelimiters;
    private final AbstractLineTracker.DelimiterInfo fDelimiterInfo = new AbstractLineTracker.DelimiterInfo();
    private final MultiStringMatcher fMatcher;

    public ConfigurableLineTracker(String[] legalLineDelimiters) {
        Assert.isTrue((legalLineDelimiters != null && legalLineDelimiters.length > 0 ? 1 : 0) != 0);
        this.fDelimiters = TextUtilities.copy(legalLineDelimiters);
        this.fMatcher = legalLineDelimiters.length > 1 ? MultiStringMatcher.create(legalLineDelimiters) : null;
    }

    @Override
    public String[] getLegalLineDelimiters() {
        return TextUtilities.copy(this.fDelimiters);
    }

    @Override
    protected AbstractLineTracker.DelimiterInfo nextDelimiterInfo(String text, int offset) {
        if (this.fMatcher != null) {
            MultiStringMatcher.Match m = this.fMatcher.indexOf(text, offset);
            if (m == null) {
                return null;
            }
            this.fDelimiterInfo.delimiterIndex = m.getOffset();
            this.fDelimiterInfo.delimiter = m.getText();
        } else {
            int index = text.indexOf(this.fDelimiters[0], offset);
            if (index == -1) {
                return null;
            }
            this.fDelimiterInfo.delimiterIndex = index;
            this.fDelimiterInfo.delimiter = this.fDelimiters[0];
        }
        this.fDelimiterInfo.delimiterLength = this.fDelimiterInfo.delimiter.length();
        return this.fDelimiterInfo;
    }
}

