/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.DisjointSet;

public class CloseUnrelatedProjectsAction
extends CloseResourceAction {
    public static final String ID = "org.eclipse.ui.CloseUnrelatedProjectsAction";
    private final List<IResource> projectsToClose = new ArrayList<IResource>();
    private boolean selectionDirty = true;
    private List<? extends IResource> oldSelection = Collections.emptyList();

    private static DisjointSet<IProject> buildConnectedComponents(IProject[] projects) {
        IProject project;
        DisjointSet<IProject> set = new DisjointSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            set.makeSet(project);
            ++n2;
        }
        iProjectArray = projects;
        n = projects.length;
        n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            try {
                IProject[] references;
                IProject[] iProjectArray2 = references = project.getReferencedProjects();
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject reference = iProjectArray2[n4];
                    IProject setOne = set.findSet(project);
                    IProject setTwo = set.findSet(reference);
                    if (setOne != null && setTwo != null && setOne != setTwo) {
                        set.union(setOne, setTwo);
                    }
                    ++n4;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return set;
    }

    @Deprecated
    public CloseUnrelatedProjectsAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.CloseUnrelatedProjectsAction_text);
        this.initAction();
    }

    public CloseUnrelatedProjectsAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.CloseUnrelatedProjectsAction_text);
        this.initAction();
    }

    @Override
    public void run() {
        if (this.promptForConfirmation()) {
            super.run();
        }
    }

    private boolean promptForConfirmation() {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("CLOSE_UNRELATED_PROJECTS")) {
            return true;
        }
        List<? extends IResource> selection = super.getSelectedResources();
        int selectionSize = selection.size();
        if (selectionSize == 0) {
            return true;
        }
        String message = null;
        if (selectionSize == 1) {
            IResource firstSelected = selection.get(0);
            String projectName = null;
            if (firstSelected instanceof IProject) {
                projectName = ((IProject)firstSelected).getName();
            }
            message = NLS.bind((String)IDEWorkbenchMessages.CloseUnrelatedProjectsAction_confirmMsg1, projectName);
        } else {
            message = NLS.bind((String)IDEWorkbenchMessages.CloseUnrelatedProjectsAction_confirmMsgN, (Object)selectionSize);
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)IDEWorkbenchMessages.CloseUnrelatedProjectsAction_toolTip, (String)message, (String)IDEWorkbenchMessages.CloseUnrelatedProjectsAction_AlwaysClose, (boolean)false, null, null);
        if (dialog.getReturnCode() != 0) {
            return false;
        }
        store.setValue("CLOSE_UNRELATED_PROJECTS", dialog.getToggleState());
        return true;
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseUnrelatedProjectsAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_unrelated_projects_action_context");
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.oldSelection = Collections.emptyList();
        this.selectionDirty = true;
    }

    private void computeRelated(List<? extends IResource> selection) {
        DisjointSet<IProject> set = CloseUnrelatedProjectsAction.buildConnectedComponents(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        for (IResource iResource : selection) {
            set.removeSet(iResource);
        }
        this.projectsToClose.clear();
        set.toList(this.projectsToClose);
    }

    @Override
    protected List<? extends IResource> getSelectedResources() {
        if (this.selectionDirty) {
            List<? extends IResource> newSelection = super.getSelectedResources();
            if (!this.oldSelection.equals(newSelection)) {
                this.oldSelection = newSelection;
                this.computeRelated(newSelection);
            }
            this.selectionDirty = false;
        }
        return this.projectsToClose;
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas;
            IResourceDelta[] iResourceDeltaArray = projDeltas = delta.getAffectedChildren(4);
            int n = projDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projDelta = iResourceDeltaArray[n2];
                if ((projDelta.getFlags() & 0x84000) != 0) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n2;
            }
        }
    }
}

