/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tablecombo;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class TableCombo
extends Composite {
    private Shell popup;
    private Button arrow;
    private Label selectedImage;
    private Text text;
    private Table table;
    private Font font;
    private boolean hasFocus;
    private int visibleItemCount;
    private Listener listener;
    private Listener focusFilter;
    private int displayColumnIndex;
    private Color foreground;
    private Color background;
    private int[] columnWidths;
    private int tableWidthPercentage;
    private boolean showImageWithinSelection;
    private boolean showColorWithinSelection;
    private boolean showFontWithinSelection;
    private boolean closePupupAfterSelection;
    private boolean selectOnEnter;
    private boolean updateTextWithinSelection;

    public TableCombo(Composite parent, int style) {
        int[] arrowEvents;
        int[] textEvents;
        int[] comboEvents;
        style = TableCombo.checkStyle(style);
        super(parent, style);
        this.visibleItemCount = 7;
        this.displayColumnIndex = 0;
        this.tableWidthPercentage = 100;
        this.showImageWithinSelection = true;
        this.showColorWithinSelection = true;
        this.showFontWithinSelection = true;
        this.closePupupAfterSelection = true;
        this.selectOnEnter = true;
        this.updateTextWithinSelection = true;
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.selectedImage = new Label((Composite)this, 0);
        this.selectedImage.setAlignment(131072);
        this.selectedImage.setBackground(Display.getCurrent().getSystemColor(1));
        this.getLayout();
        this.text = new Text((Composite)this, textStyle);
        this.text.setBackground(Display.getCurrent().getSystemColor(1));
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button((Composite)this, arrowStyle);
        this.createListeners();
        int[] nArray = comboEvents = new int[]{12, 15, 10, 11};
        int n = comboEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int comboEvent = nArray[n2];
            this.addListener(comboEvent, this.listener);
            ++n2;
        }
        int[] nArray2 = textEvents = new int[]{14, 1, 2, 35, 24, 3, 4, 8, 37, 31, 15, 25};
        int n3 = textEvents.length;
        n = 0;
        while (n < n3) {
            int textEvent = nArray2[n];
            this.text.addListener(textEvent, this.listener);
            ++n;
        }
        int[] nArray3 = arrowEvents = new int[]{13, 15};
        int n4 = arrowEvents.length;
        n3 = 0;
        while (n3 < n4) {
            int arrowEvent = nArray3[n3];
            this.arrow.addListener(arrowEvent, this.listener);
            ++n3;
        }
        this.createPopup(-1);
        this.initAccessible();
        this.addDisposeListener(e -> this.popup.dispose());
    }

    private void createListeners() {
        this.focusFilter = event -> {
            if (this.isDisposed()) {
                return;
            }
            Shell shell = ((Control)event.widget).getShell();
            if (shell == this.getShell()) {
                this.handleFocus(16);
            }
        };
        this.listener = event -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.popup == event.widget) {
                this.popupEvent(event);
                return;
            }
            if (this.text == event.widget) {
                this.textEvent(event);
                return;
            }
            if (this.table == event.widget) {
                this.tableEvent(event);
                return;
            }
            if (this.arrow == event.widget) {
                this.arrowEvent(event);
                return;
            }
            if (this == event.widget) {
                this.comboEvent(event);
                return;
            }
            if (this.getShell() == event.widget) {
                this.getDisplay().asyncExec(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    this.handleFocus(16);
                });
            }
        };
    }

    private static int checkStyle(int style) {
        int mask = 0x6800808;
        return 0x80000 | style & 0x6800808;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addTextControlKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.text.addKeyListener(listener);
    }

    public void removeTextControlKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.text.removeKeyListener(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(25, (Listener)typedListener);
    }

    private void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(3, mouseEvent);
                event.doit = mouseEvent.doit;
                break;
            }
            case 4: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(4, mouseEvent);
                event.doit = mouseEvent.doit;
                break;
            }
            case 13: {
                this.text.setFocus();
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.table.deselectAll();
    }

    private void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                this.removeListener(12, this.listener);
                this.notifyListeners(12, event);
                event.type = 0;
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.table.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.focusFilter);
                this.popup = null;
                this.text = null;
                this.table = null;
                this.arrow = null;
                this.selectedImage = null;
                break;
            }
            case 15: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.table) {
                    return;
                }
                if (this.isDropped()) {
                    this.table.setFocus();
                    break;
                }
                this.text.setFocus();
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false, true);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int overallWidth = 0;
        int overallHeight = 0;
        int borderWidth = this.getBorderWidth();
        if (wHint != -1 && hHint != -1) {
            overallWidth = wHint;
            overallHeight = hHint;
        } else {
            TableItem[] tableItems = this.table.getItems();
            GC gc = new GC((Drawable)this.text);
            int spacer = gc.stringExtent((String)" ").x;
            int maxTextWidth = gc.stringExtent((String)this.text.getText()).x;
            int colIndex = this.getDisplayColumnIndex();
            int maxImageHeight = 0;
            int currTextWidth = 0;
            TableItem[] tableItemArray = tableItems;
            int n = tableItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                currTextWidth = gc.stringExtent((String)tableItem.getText((int)colIndex)).x;
                if (tableItem.getImage() != null) {
                    currTextWidth += tableItem.getImage().getBounds().width;
                    maxImageHeight = Math.max(tableItem.getImage().getBounds().height, maxImageHeight);
                }
                maxTextWidth = Math.max(currTextWidth, maxTextWidth);
                ++n2;
            }
            gc.dispose();
            Point textSize = this.text.computeSize(-1, -1, changed);
            Point arrowSize = this.arrow.computeSize(-1, -1, changed);
            overallHeight = Math.max(textSize.y, arrowSize.y);
            overallHeight = Math.max(maxImageHeight, overallHeight);
            overallWidth = maxTextWidth + 2 * spacer + arrowSize.x + 2 * borderWidth;
            if (wHint != -1) {
                overallWidth = wHint;
            }
            if (hHint != -1) {
                overallHeight = hHint;
            }
        }
        return new Point(overallWidth + 2 * borderWidth, overallHeight + 2 * borderWidth);
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    void createPopup(int selectionIndex) {
        int[] tableEvents;
        int[] popupEvents;
        this.popup = new Shell(this.getShell(), 16392);
        this.table = new Table((Composite)this.popup, 65540);
        if (this.font != null) {
            this.table.setFont(this.font);
        }
        if (this.foreground != null) {
            this.table.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.table.setBackground(this.background);
        }
        int[] nArray = popupEvents = new int[]{21, 9, 27, 28};
        int n = popupEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int popupEvent = nArray[n2];
            this.popup.addListener(popupEvent, this.listener);
            ++n2;
        }
        int[] nArray2 = tableEvents = new int[]{4, 13, 31, 1, 2, 15, 12};
        int n3 = tableEvents.length;
        n = 0;
        while (n < n3) {
            int tableEvent = nArray2[n];
            this.table.addListener(tableEvent, this.listener);
            ++n;
        }
        if (selectionIndex != -1) {
            this.table.setSelection(selectionIndex);
        }
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    void dropDown(boolean drop) {
        TableColumn[] tableColumns;
        int totalColumns;
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            if (!this.isDisposed() && this.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        Point tableComboSize = this.getSize();
        int itemCount = this.table.getItemCount();
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount);
        int itemHeight = this.table.getItemHeight() * itemCount;
        if (this.table.getItemCount() <= this.visibleItemCount) {
            ++itemHeight;
        }
        if (itemCount <= this.visibleItemCount && this.table.getHorizontalBar() != null && !this.table.getHorizontalBar().isVisible()) {
            itemHeight -= this.table.getHorizontalBar().getSize().y;
        }
        if (this.table.getHeaderVisible()) {
            itemHeight += this.table.getHeaderHeight();
        }
        int n = totalColumns = (tableColumns = this.table.getColumns()) == null ? 0 : tableColumns.length;
        if (this.table.getColumnCount() == 0) {
            new TableColumn(this.table, 0);
            totalColumns = 1;
            tableColumns = this.table.getColumns();
        }
        int totalColumnWidth = 0;
        int colIndex = 0;
        while (colIndex < totalColumns) {
            if (!this.wasColumnWidthSpecified(colIndex)) {
                tableColumns[colIndex].pack();
            }
            totalColumnWidth += tableColumns[colIndex].getWidth();
            ++colIndex;
        }
        int lastColIndex = totalColumns - 1;
        if (this.wasColumnWidthSpecified(lastColIndex)) {
            tableColumns[lastColIndex].setWidth(this.columnWidths[lastColIndex]);
        }
        Point tableSize = this.table.computeSize(-1, itemHeight, false);
        double pct = (double)this.tableWidthPercentage / 100.0;
        int tableWidth = (int)((double)Math.max(tableComboSize.x - 2, tableSize.x) * pct);
        int tableHeight = tableSize.y;
        if (this.tableWidthPercentage < 100) {
            tableHeight += this.table.getHorizontalBar().getSize().y;
        }
        this.table.setBounds(1, 1, tableWidth, tableHeight);
        if (!this.table.getVerticalBar().getVisible() && tableSize.x - this.table.getVerticalBar().getSize().x >= tableComboSize.x - 2) {
            this.table.setBounds(1, 1, tableWidth -= this.table.getVerticalBar().getSize().x, tableHeight);
        }
        this.autoAdjustColumnWidthsIfNeeded(tableColumns, tableWidth, totalColumnWidth);
        int index = this.table.getSelectionIndex();
        if (index != -1) {
            this.table.setTopIndex(index);
        }
        Display display = this.getDisplay();
        Rectangle tableRect = this.table.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int overallWidth = 0;
        overallWidth = this.tableWidthPercentage < 100 ? tableRect.width + 2 : Math.max(comboSize.x, tableRect.width + 2);
        int overallHeight = tableRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + overallHeight > displayRect.y + displayRect.height) {
            y = parentRect.y - overallHeight;
        }
        if (x + overallWidth > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - tableRect.width;
        }
        this.popup.setBounds(x, y, overallWidth, overallHeight);
        this.popup.setVisible(true);
        this.table.setFocus();
    }

    private Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this && i > 0 && siblings[i - 1] instanceof Label) {
                return (Label)siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.table.getItem(index).getText(this.getDisplayColumnIndex());
    }

    public int getItemCount() {
        this.checkWidget();
        return this.table.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        TableItem[] tableItems = this.table.getItems();
        int totalItems = tableItems == null ? 0 : tableItems.length;
        String[] stringItems = new String[totalItems];
        int colIndex = this.getDisplayColumnIndex();
        int index = 0;
        while (index < totalItems) {
            stringItems[index] = tableItems[index].getText(colIndex);
            ++index;
        }
        return stringItems;
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.table.getSelectionIndex();
    }

    public int getStyle() {
        this.checkWidget();
        int style = super.getStyle();
        style &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            style |= 8;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    private void handleFocus(int type) {
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.focusFilter);
                display.addFilter(15, this.focusFilter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.table || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.focusFilter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    public int indexOf(String string) {
        TableItem[] tableItems;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int totalItems = (tableItems = this.table.getItems()) == null ? 0 : tableItems.length;
        int colIndex = this.getDisplayColumnIndex();
        int index = 0;
        while (index < totalItems) {
            if (string.equals(tableItems[index].getText(colIndex))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int indexOf(String string, int start) {
        TableItem[] tableItems;
        int totalItems;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int n = totalItems = (tableItems = this.table.getItems()) == null ? 0 : tableItems.length;
        if (start < totalItems) {
            int colIndex = this.getDisplayColumnIndex();
            int index = start;
            while (index < totalItems) {
                if (string.equals(tableItems[index].getText(colIndex))) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public void setShowTableLines(boolean showTableLines) {
        this.checkWidget();
        this.table.setLinesVisible(showTableLines);
    }

    public void setShowTableHeader(boolean showTableHeader) {
        this.checkWidget();
        this.table.setHeaderVisible(showTableHeader);
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = TableCombo.this.getAssociatedLabel();
                if (label != null) {
                    name = TableCombo.this.stripMnemonic(TableCombo.this.text.getText());
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = TableCombo.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = TableCombo.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = TableCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = TableCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = TableCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = TableCombo.this.text.getCaretPosition();
            }

            public void getSelectionRange(AccessibleTextEvent e) {
                Point sel = TableCombo.this.text.getSelection();
                e.offset = sel.x;
                e.length = sel.y - sel.x;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = TableCombo.this.toControl(e.x, e.y);
                if (TableCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = TableCombo.this.getBounds();
                Point pt = TableCombo.this.getParent().toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = TableCombo.this.text.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = TableCombo.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = TableCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    private boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.arrow.isFocusControl() || this.table.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    private void internalLayout(boolean changed, boolean closeDropDown) {
        if (closeDropDown && this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height, changed);
        int textYPos = 0;
        Point textSize = this.text.computeSize(-1, -1);
        if (textSize.y < height) {
            textYPos = (height - textSize.y) / 2;
        }
        if (this.selectedImage.getImage() == null) {
            this.selectedImage.setBounds(0, 0, 0, 0);
            this.text.setBounds(0, textYPos, width - arrowSize.x, textSize.y);
            this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
        } else {
            int remainingWidth = width - arrowSize.x;
            Point imageSize = this.selectedImage.computeSize(-1, height, changed);
            int imageWidth = imageSize.x + 2;
            if (imageWidth > remainingWidth) {
                imageWidth = remainingWidth;
                remainingWidth = 0;
            } else {
                remainingWidth -= imageWidth;
            }
            int textWidth = remainingWidth;
            this.selectedImage.setBounds(0, 0, imageWidth, imageSize.y);
            this.text.setBounds(imageWidth, textYPos, textWidth, textSize.y);
            this.arrow.setBounds(imageWidth + textWidth, 0, arrowSize.x, arrowSize.y);
        }
    }

    private void tableEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (!this.closePupupAfterSelection) break;
                this.dropDown(false);
                break;
            }
            case 13: {
                int index = this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.refreshText(index);
                this.table.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.doit = this.text.traverse(event.detail);
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDown(false);
                        }
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    if (this.selectOnEnter) {
                        e = new Event();
                        e.time = event.time;
                        e.stateMask = event.stateMask;
                        this.notifyListeners(14, e);
                    }
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    public void setUpdateSelectionOnEnter(boolean selectOnEnter) {
        this.selectOnEnter = selectOnEnter;
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    private void popupEvent(Event event) {
        block0 : switch (event.type) {
            case 9: {
                Rectangle tableRect = this.table.getBounds();
                event.gc.setForeground(this.getDisplay().getSystemColor(26));
                event.gc.drawRectangle(0, 0, tableRect.width + 1, tableRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                if (!"carbon".equals(SWT.getPlatform())) {
                    Point point = this.arrow.toControl(this.getDisplay().getCursorLocation());
                    Point size = this.arrow.getSize();
                    Rectangle rect = new Rectangle(0, 0, size.x, size.y);
                    if (rect.contains(point)) break;
                    this.dropDown(false);
                    break;
                }
                this.dropDown(false);
                break;
            }
            case 28: {
                if (this.isDropped()) {
                    this.dropDown(false);
                }
                TableCombo comp = this;
                do {
                    if (comp.getListeners(event.type) == null || comp.getListeners(event.type).length <= 0) continue;
                    comp.notifyListeners(event.type, event);
                    break block0;
                } while ((comp = comp.getParent()) != null);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(25, (SWTEventListener)listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.table.deselectAll();
            this.text.setText("");
            this.selectedImage.setImage(null);
            return;
        }
        if (index >= 0 && index < this.table.getItemCount() && index != this.getSelectionIndex()) {
            this.refreshText(index);
            this.table.setSelection(index);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.selectedImage != null) {
            this.selectedImage.setBackground(color);
        }
        if (this.table != null) {
            this.table.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.selectedImage != null) {
            this.selectedImage.setEnabled(enabled);
        }
        if (this.text != null) {
            this.text.setEnabled(enabled);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.table.setFont(font);
        this.internalLayout(true, true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.table != null) {
            this.table.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setTableVisible(boolean visible) {
        this.checkWidget();
        this.dropDown(visible);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if ((index = this.indexOf(string)) == -1) {
            this.table.deselectAll();
            this.text.setText(string);
            return;
        }
        if (!this.updateTextWithinSelection) {
            this.text.setText(string);
        }
        this.select(index);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String tipText) {
        this.checkWidget();
        super.setToolTipText(tipText);
        if (this.selectedImage != null) {
            this.selectedImage.setToolTipText(tipText);
        }
        if (this.text != null) {
            this.text.setToolTipText(tipText);
        }
        if (this.arrow != null) {
            this.arrow.setToolTipText(tipText);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isDisposed()) {
            return;
        }
        if (this.popup == null || this.popup.isDisposed()) {
            return;
        }
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count > 0) {
            this.visibleItemCount = count;
        }
    }

    private String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    public void defineColumns(String[] columnHeaders) {
        if (columnHeaders != null && columnHeaders.length > 0) {
            this.defineColumnsInternal(columnHeaders, null, columnHeaders.length);
        }
    }

    public void defineColumns(int[] columnBounds) {
        this.columnWidths = columnBounds;
        if (columnBounds != null && columnBounds.length > 0) {
            this.defineColumnsInternal(null, columnBounds, columnBounds.length);
        }
    }

    public void defineColumns(int numberOfColumnsToCreate) {
        if (numberOfColumnsToCreate > 0) {
            this.defineColumnsInternal(null, null, numberOfColumnsToCreate);
        }
    }

    public void defineColumns(String[] columnHeaders, int[] columnBounds) {
        if (columnHeaders != null || columnBounds != null) {
            int total;
            int n = total = columnHeaders == null ? 0 : columnHeaders.length;
            if (columnBounds != null && columnBounds.length > total) {
                total = columnBounds.length;
            }
            this.columnWidths = columnBounds;
            this.defineColumnsInternal(columnHeaders, columnBounds, total);
        }
    }

    private void defineColumnsInternal(String[] columnHeaders, int[] columnBounds, int totalColumnsToBeCreated) {
        int totalColBounds;
        this.checkWidget();
        int totalColumnHeaders = columnHeaders == null ? 0 : columnHeaders.length;
        int n = totalColBounds = columnBounds == null ? 0 : columnBounds.length;
        if (totalColumnsToBeCreated > 0) {
            int index = 0;
            while (index < totalColumnsToBeCreated) {
                TableColumn column = new TableColumn(this.table, 0);
                if (index < totalColumnHeaders) {
                    column.setText(columnHeaders[index]);
                }
                if (index < totalColBounds) {
                    column.setWidth(columnBounds[index]);
                }
                column.setResizable(true);
                column.setMoveable(true);
                ++index;
            }
        }
    }

    public void setTableWidthPercentage(int ddWidthPct) {
        this.checkWidget();
        if (ddWidthPct > 0 && ddWidthPct <= 100) {
            this.tableWidthPercentage = ddWidthPct;
        }
    }

    public void setDisplayColumnIndex(int displayColumnIndex) {
        this.checkWidget();
        if (displayColumnIndex >= 0) {
            this.displayColumnIndex = displayColumnIndex;
        }
    }

    public void setClosePopupAfterSelection(boolean closePopupAfterSelection) {
        this.closePupupAfterSelection = closePopupAfterSelection;
    }

    private int getDisplayColumnIndex() {
        return this.displayColumnIndex <= this.table.getColumnCount() - 1 ? this.displayColumnIndex : 0;
    }

    private char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    private void refreshText(int index) {
        TableItem tableItem = this.table.getItem(index);
        int colIndexToUse = this.getDisplayColumnIndex();
        if (this.showImageWithinSelection) {
            this.selectedImage.setImage(tableItem.getImage(colIndexToUse));
            this.internalLayout(false, false);
        }
        if (this.showColorWithinSelection) {
            this.text.setForeground(tableItem.getForeground(colIndexToUse));
        }
        if (this.showFontWithinSelection) {
            this.text.setFont(tableItem.getFont(colIndexToUse));
        }
        if (this.updateTextWithinSelection) {
            this.text.setText(tableItem.getText(colIndexToUse));
        }
        this.text.selectAll();
    }

    public void setShowImageWithinSelection(boolean showImageWithinSelection) {
        this.checkWidget();
        this.showImageWithinSelection = showImageWithinSelection;
    }

    public void setShowColorWithinSelection(boolean showColorWithinSelection) {
        this.checkWidget();
        this.showColorWithinSelection = showColorWithinSelection;
    }

    public void setShowFontWithinSelection(boolean showFontWithinSelection) {
        this.checkWidget();
        this.showFontWithinSelection = showFontWithinSelection;
    }

    public void setUpdateTextWithinSelection(boolean updateTextWithinSelection) {
        this.checkWidget();
        this.updateTextWithinSelection = updateTextWithinSelection;
    }

    public Table getTable() {
        this.checkWidget();
        return this.table;
    }

    private boolean wasColumnWidthSpecified(int columnIndex) {
        return this.columnWidths != null && this.columnWidths.length > columnIndex && this.columnWidths[columnIndex] != -1;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 14: {
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                this.notifyListeners(14, e);
                break;
            }
            case 1: {
                Event keyEvent = new Event();
                keyEvent.time = event.time;
                keyEvent.character = event.character;
                keyEvent.keyCode = event.keyCode;
                keyEvent.stateMask = event.stateMask;
                this.notifyListeners(1, keyEvent);
                if (this.isDisposed()) break;
                event.doit = keyEvent.doit;
                if (!event.doit || event.keyCode != 0x1000001 && event.keyCode != 0x1000002) break;
                event.doit = false;
                if ((event.stateMask & 0x10000) != 0) {
                    boolean dropped = this.isDropped();
                    this.text.selectAll();
                    if (!dropped) {
                        this.setFocus();
                    }
                    this.dropDown(!dropped);
                    break;
                }
                int oldIndex = this.table.getSelectionIndex();
                if (event.keyCode == 0x1000001) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.table.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                event.doit = e.doit;
                break;
            }
            case 35: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(35, e);
                break;
            }
            case 24: {
                this.table.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(3, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit) break;
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.text.selectAll();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(4, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit) break;
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 8: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(8, mouseEvent);
                break;
            }
            case 37: {
                Event keyEvent = new Event();
                keyEvent.time = event.time;
                keyEvent.keyCode = event.count > 0 ? 0x1000001 : 0x1000002;
                keyEvent.stateMask = event.stateMask;
                this.notifyListeners(1, keyEvent);
                if (this.isDisposed()) break;
                event.doit = keyEvent.doit;
                if (!event.doit || event.count == 0) break;
                event.doit = false;
                int oldIndex = this.table.getSelectionIndex();
                if (event.count > 0) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.table.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: {
                        event.doit = this.traverse(8);
                        event.detail = 0;
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 25: {
                Event e = new Event();
                e.text = event.text;
                e.start = event.start;
                e.end = event.end;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(25, e);
                event.doit = e.doit;
            }
        }
    }

    private void autoAdjustColumnWidthsIfNeeded(TableColumn[] tableColumns, int totalAvailWidth, int totalColumnWidthUsage) {
        int totalAmtToBeAllocated;
        int totalColumns;
        int scrollBarSize = 0;
        int n = totalColumns = tableColumns == null ? 0 : tableColumns.length;
        if (this.table.getVerticalBar().getVisible()) {
            int n2 = scrollBarSize = this.table.getVerticalBar() == null ? 0 : this.table.getVerticalBar().getSize().x;
        }
        if (totalAvailWidth > totalColumnWidthUsage + scrollBarSize && (totalAmtToBeAllocated = totalAvailWidth - totalColumnWidthUsage - scrollBarSize) > 0) {
            tableColumns[totalColumns - 1].setWidth(tableColumns[totalColumns - 1].getWidth() + totalAmtToBeAllocated);
        }
    }

    public Text getTextControl() {
        this.checkWidget();
        return this.text;
    }
}

