/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.table;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http3.qpack.internal.util.HuffmanEncoder;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;
import org.eclipse.jetty.util.StringUtil;

public class Entry {
    private final HttpField _field;
    private int _absoluteIndex;
    private final AtomicInteger _referenceCount = new AtomicInteger(0);

    public Entry() {
        this(-1, null);
    }

    public Entry(HttpField field) {
        this(-1, field);
    }

    public Entry(int index, HttpField field) {
        this._field = field;
        this._absoluteIndex = index;
    }

    public int getSize() {
        return Entry.getSize(this._field);
    }

    public void setIndex(int index) {
        this._absoluteIndex = index;
    }

    public int getIndex() {
        return this._absoluteIndex;
    }

    public HttpField getHttpField() {
        return this._field;
    }

    public void reference() {
        this._referenceCount.incrementAndGet();
    }

    public void release() {
        this._referenceCount.decrementAndGet();
    }

    public int getReferenceCount() {
        return this._referenceCount.get();
    }

    public boolean isStatic() {
        return false;
    }

    public byte[] getStaticHuffmanValue() {
        return null;
    }

    public String toString() {
        return String.format("%s@%x{index=%d, refs=%d, field=\"%s\"}", this.getClass().getSimpleName(), this.hashCode(), this._absoluteIndex, this._referenceCount.get(), this._field);
    }

    public static int getSize(Entry entry) {
        return Entry.getSize(entry.getHttpField());
    }

    public static int getSize(HttpField field) {
        return 32 + StringUtil.getLength((String)field.getName()) + StringUtil.getLength((String)field.getValue());
    }

    public static class StaticEntry
    extends Entry {
        private final byte[] _huffmanValue;
        private final byte _encodedField;

        StaticEntry(int index, HttpField field) {
            super(index, field);
            String value = field.getValue();
            if (value != null && value.length() > 0) {
                int huffmanLen = HuffmanEncoder.octetsNeeded(value);
                if (huffmanLen < 0) {
                    throw new IllegalStateException("bad value");
                }
                int lenLen = NBitIntegerEncoder.octectsNeeded(7, huffmanLen);
                this._huffmanValue = new byte[1 + lenLen + huffmanLen];
                ByteBuffer buffer = ByteBuffer.wrap(this._huffmanValue);
                buffer.put((byte)-128);
                NBitIntegerEncoder.encode(buffer, 7, huffmanLen);
                HuffmanEncoder.encode(buffer, value);
            } else {
                this._huffmanValue = null;
            }
            this._encodedField = (byte)(0x80 | index);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public byte[] getStaticHuffmanValue() {
            return this._huffmanValue;
        }

        public byte getEncodedField() {
            return this._encodedField;
        }
    }
}

