/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Duration;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPartialListener;
import org.eclipse.jetty.websocket.api.WebSocketPingPongListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

public class WebSocketDocs {
    private static void forwardToREST(String payload, boolean fin) {
    }

    private static void forwardToREST(Reader reader) {
    }

    private static void appendToFile(ByteBuffer payload, boolean fin) {
    }

    private static void appendToFile(InputStream stream) {
    }

    private static void disposeResources() {
    }

    private static void savePNGImage(byte[] payload, int offset, int length) {
    }

    private static ByteBuffer readImageFromFile() {
        return null;
    }

    private static ByteBuffer readChunkToSend() {
        return null;
    }

    @WebSocket
    public class CloseEndpoint {
        @OnWebSocketMessage
        public void onText(Session session, String text) {
            if ("close".equalsIgnoreCase(text)) {
                session.close(1000, "bye");
            }
        }
    }

    public class RoundTripListenerEndpoint
    implements WebSocketPingPongListener {
        public void onWebSocketConnect(Session session) {
            ByteBuffer buffer = ByteBuffer.allocate(8).putLong(NanoTime.now()).flip();
            session.getRemote().sendPing(buffer, WriteCallback.NOOP);
        }

        public void onWebSocketPong(ByteBuffer payload) {
            long start = payload.getLong();
            long roundTrip = NanoTime.since((long)start);
        }
    }

    @WebSocket
    public class StreamSendNonBlockingEndpoint {
        @OnWebSocketMessage
        public void onText(Session session, String text) {
            RemoteEndpoint remote = session.getRemote();
            new Sender(remote).iterate();
        }

        private class Sender
        extends IteratingCallback
        implements WriteCallback {
            private final RemoteEndpoint remote;
            private boolean finished;

            private Sender(RemoteEndpoint remote) {
                this.remote = remote;
            }

            protected IteratingCallback.Action process() throws Throwable {
                if (this.finished) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
                ByteBuffer chunk = WebSocketDocs.readChunkToSend();
                if (chunk == null) {
                    this.remote.sendPartialBytes(ByteBuffer.allocate(0), true, (WriteCallback)this);
                    this.finished = true;
                    return IteratingCallback.Action.SCHEDULED;
                }
                this.remote.sendPartialBytes(ByteBuffer.allocate(0), false, (WriteCallback)this);
                return IteratingCallback.Action.SCHEDULED;
            }

            public void writeSuccess() {
                this.succeeded();
            }

            public void writeFailed(Throwable x) {
                this.failed(x);
            }

            protected void onCompleteFailure(Throwable x) {
                x.printStackTrace();
            }
        }
    }

    @WebSocket
    public class StreamSendBlockingEndpoint {
        @OnWebSocketMessage
        public void onText(Session session, String text) {
            try {
                RemoteEndpoint remote = session.getRemote();
                while (true) {
                    ByteBuffer chunk;
                    if ((chunk = WebSocketDocs.readChunkToSend()) == null) {
                        remote.sendPartialBytes(ByteBuffer.allocate(0), true);
                        break;
                    }
                    remote.sendPartialBytes(chunk, false);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    @WebSocket
    public class NonBlockingSendEndpoint {
        @OnWebSocketMessage
        public void onText(Session session, String text) {
            final RemoteEndpoint remote = session.getRemote();
            remote.sendString("data", new WriteCallback(){

                public void writeSuccess() {
                    ByteBuffer bytes = WebSocketDocs.readImageFromFile();
                    remote.sendBytes(bytes, new WriteCallback(){

                        public void writeSuccess() {
                        }

                        public void writeFailed(Throwable x) {
                            System.getLogger("websocket").log(System.Logger.Level.WARNING, "could not send binary data", x);
                        }
                    });
                }

                public void writeFailed(Throwable x) {
                    System.getLogger("websocket").log(System.Logger.Level.WARNING, "could not send textual data", x);
                }
            });
        }
    }

    @WebSocket
    public class BlockingSendEndpoint {
        @OnWebSocketMessage
        public void onText(Session session, String text) {
            RemoteEndpoint remote = session.getRemote();
            try {
                remote.sendString("data");
                ByteBuffer bytes = WebSocketDocs.readImageFromFile();
                remote.sendBytes(bytes);
                remote.sendPing(ByteBuffer.allocate(8).putLong(NanoTime.now()).flip());
            }
            catch (IOException x) {
                System.getLogger("websocket").log(System.Logger.Level.WARNING, "could not send data", (Throwable)x);
            }
        }
    }

    public class ConfigureEndpoint
    implements WebSocketListener {
        public void onWebSocketConnect(Session session) {
            session.setMaxTextMessageSize(16384L);
            session.setIdleTimeout(Duration.ofSeconds(30L));
        }
    }

    @WebSocket
    public class StreamingAnnotatedEndpoint {
        @OnWebSocketMessage
        public void onTextMessage(Reader reader) {
            WebSocketDocs.forwardToREST(reader);
        }

        @OnWebSocketMessage
        public void onBinaryMessage(InputStream stream) {
            WebSocketDocs.appendToFile(stream);
        }
    }

    @WebSocket
    public class AnnotatedEndPoint {
        private Session session;

        @OnWebSocketConnect
        public void onConnect(Session session) {
            this.session = session;
            session.setMaxTextMessageSize(16384L);
            session.getRemote().sendString("connected", WriteCallback.NOOP);
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            WebSocketDocs.disposeResources();
        }

        @OnWebSocketError
        public void onError(Throwable cause) {
            cause.printStackTrace();
            WebSocketDocs.disposeResources();
        }

        @OnWebSocketMessage
        public void onTextMessage(Session session, String message) {
            if (message.startsWith("echo:")) {
                session.getRemote().sendString(message.substring("echo:".length()), WriteCallback.NOOP);
            }
        }

        @OnWebSocketMessage
        public void onBinaryMessage(byte[] payload, int offset, int length) {
            byte[] pngBytes = new byte[]{-119, 80, 78, 71};
            for (int i = 0; i < pngBytes.length; ++i) {
                if (pngBytes[i] == payload[offset + i]) continue;
                return;
            }
            WebSocketDocs.savePNGImage(payload, offset, length);
        }
    }

    public class StreamingListenerEndpoint
    implements WebSocketPartialListener {
        private Path textPath;

        public void onWebSocketPartialText(String payload, boolean fin) {
            WebSocketDocs.forwardToREST(payload, fin);
        }

        public void onWebSocketPartialBinary(ByteBuffer payload, boolean fin) {
            WebSocketDocs.appendToFile(payload, fin);
        }
    }

    public class ListenerEndPoint
    implements WebSocketListener {
        private Session session;

        public void onWebSocketConnect(Session session) {
            this.session = session;
            session.setMaxTextMessageSize(16384L);
            session.getRemote().sendString("connected", WriteCallback.NOOP);
        }

        public void onWebSocketClose(int statusCode, String reason) {
            WebSocketDocs.disposeResources();
        }

        public void onWebSocketError(Throwable cause) {
            cause.printStackTrace();
            WebSocketDocs.disposeResources();
        }

        public void onWebSocketText(String message) {
            if (message.startsWith("echo:")) {
                this.session.getRemote().sendString(message.substring("echo:".length()), WriteCallback.NOOP);
            }
        }

        public void onWebSocketBinary(byte[] payload, int offset, int length) {
            byte[] pngBytes = new byte[]{-119, 80, 78, 71};
            for (int i = 0; i < pngBytes.length; ++i) {
                if (pngBytes[i] == payload[offset + i]) continue;
                return;
            }
            WebSocketDocs.savePNGImage(payload, offset, length);
        }
    }
}

