/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;

public class WritableValue<T>
extends AbstractObservableValue<T> {
    private final Object valueType;
    private T value = null;

    public WritableValue() {
        this(null, null);
    }

    public WritableValue(T initialValue, Object valueType) {
        this(Realm.getDefault(), initialValue, valueType);
    }

    public WritableValue(Realm realm) {
        this(realm, null, null);
    }

    public WritableValue(Realm realm, T initialValue, Object valueType) {
        super(realm);
        this.valueType = valueType;
        this.value = initialValue;
    }

    @Override
    public T doGetValue() {
        return this.value;
    }

    @Override
    public void doSetValue(T value) {
        if (this.value != value) {
            this.value = value;
            this.fireValueChange(Diffs.createValueDiff(this.value, this.value));
        }
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    public static <T2> WritableValue<T2> withValueType(Object elementType) {
        return new WritableValue<Object>(Realm.getDefault(), null, elementType);
    }
}

