/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class IntField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();

    public IntField(String name, int value) {
        super(name, FIELD_TYPE);
        this.fieldsData = value;
    }

    @Override
    public BytesRef binaryValue() {
        byte[] bytes = new byte[4];
        NumericUtils.intToSortableBytes((Integer)this.fieldsData, bytes, 0);
        return new BytesRef(bytes);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.name + ":" + this.fieldsData + ">";
    }

    public static Query newExactQuery(String field, int value) {
        return IntField.newRangeQuery(field, value, value);
    }

    public static Query newRangeQuery(String field, int lowerValue, int upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        IndexOrDocValuesQuery fallbackQuery = new IndexOrDocValuesQuery(IntPoint.newRangeQuery(field, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field, lowerValue, upperValue));
        return new IndexSortSortedNumericDocValuesRangeQuery(field, lowerValue, upperValue, fallbackQuery);
    }

    public static Query newSetQuery(String field, int ... values) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        long[] points = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            points[i] = values[i];
        }
        return new IndexOrDocValuesQuery(IntPoint.newSetQuery(field, (int[])values.clone()), SortedNumericDocValuesField.newSlowSetQuery(field, points));
    }

    public static SortField newSortField(String field, boolean reverse, SortedNumericSelector.Type selector) {
        return new SortedNumericSortField(field, SortField.Type.INT, reverse, selector);
    }

    static {
        FIELD_TYPE.setDimensions(1, 4);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        FIELD_TYPE.freeze();
    }
}

