/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.FromTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.persist.file.TidList;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.persist.file.TxnAckList;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;

public class TxnConversionUtil {
    static String convertingToTxnLogMode = "convertingToTxnLogMode";
    static String convertingFromTxnLogMode = "convertingFromTxnLogMode";
    static boolean txnConversionRequired;
    static boolean convertingToTxnLog;
    public static final Logger logger;

    public static String getPrefix() {
        return "TxnConversionUtil.";
    }

    public static void resetAllTransactionState(File rootDir) throws BrokerException {
        logger.log(8, TxnConversionUtil.getPrefix() + "resetAllTransactionState");
        TxnConversionUtil.deleteConversionFile(rootDir, convertingToTxnLogMode);
        TxnConversionUtil.deleteConversionFile(rootDir, convertingFromTxnLogMode);
        TransactionLogManager.deleteAllFileState(rootDir);
        TidList.deleteAllFiles(rootDir);
        TxnAckList.deleteAllFiles(rootDir);
    }

    public static void checkForIncompleteTxnConversion(File rootDir, boolean isNewTxnLogEnabled) throws BrokerException {
        logger.log(4, TxnConversionUtil.getPrefix() + "checkForIncompleteTxnConversion");
        File convertingToTxnFormatFile = new File(convertingToTxnLogMode);
        File convertingFromTxnFormatFile = new File(convertingFromTxnLogMode);
        if (convertingToTxnFormatFile.exists()) {
            if (convertingFromTxnFormatFile.exists()) {
                throw new BrokerException("Inconsistent state. Both " + String.valueOf(convertingToTxnFormatFile) + " and " + String.valueOf(convertingFromTxnFormatFile) + " exist.");
            }
            TxnConversionUtil.resolveIncompleteConversionToTxnLog(rootDir, convertingToTxnFormatFile);
        }
        if (convertingFromTxnFormatFile.exists()) {
            TxnConversionUtil.resolveIncompleteConversionFromTxnLog(rootDir, convertingFromTxnFormatFile);
        }
        boolean nonTxnLogStateExists = false;
        boolean txnLogStateExists = false;
        if (TransactionLogManager.transactionLogExists(rootDir)) {
            txnLogStateExists = true;
        }
        if (TidList.txFileExists(rootDir)) {
            nonTxnLogStateExists = true;
        }
        if (txnLogStateExists && nonTxnLogStateExists) {
            throw new BrokerException("ack file and txnlog file both exist: transaction state exists in both txn-log and non-txn-log formats");
        }
        if (isNewTxnLogEnabled) {
            if (nonTxnLogStateExists) {
                String msg = "TxnLog is enabled but non txn log files exist. TxnConversion required";
                logger.log(8, msg);
                TxnConversionUtil.setTxnConversionRequired(true);
            }
        } else if (txnLogStateExists) {
            String msg = "TxnLog is not enabled but txn log files exist. TxnConversion required";
            logger.log(8, msg);
            TxnConversionUtil.setTxnConversionRequired(true);
        }
    }

    public static boolean isTxnConversionRequired() {
        return txnConversionRequired;
    }

    public static void setTxnConversionRequired(boolean txnConversionRequired) {
        TxnConversionUtil.txnConversionRequired = txnConversionRequired;
    }

    static void resolveIncompleteConversionToTxnLog(File rootDir, File convertingToTxnFormatFile) throws BrokerException {
        String msg = "Found incomplete conversion of transactions to txnLog format on startup. Will redo or complete conversion";
        logger.log(16, msg);
        if (TidList.txFileExists(rootDir) && TidList.txAckFileExists(rootDir)) {
            TransactionLogManager.deleteAllFileState(rootDir);
            TxnConversionUtil.deleteConversionFile(rootDir, convertingToTxnLogMode);
            return;
        }
        if (!TidList.txFileExists(rootDir) || !TidList.txAckFileExists(rootDir)) {
            TransactionLogManager.assertAllFilesExist(rootDir);
            TidList.deleteAllFiles(rootDir);
            TxnAckList.deleteAllFiles(rootDir);
            TxnConversionUtil.deleteConversionFile(rootDir, convertingToTxnLogMode);
            return;
        }
        TransactionLogManager.deleteAllFileState(rootDir);
        TxnConversionUtil.deleteConversionFile(rootDir, convertingToTxnLogMode);
    }

    static void resolveIncompleteConversionFromTxnLog(File rootDir, File convertingFromTxnFormatFile) throws BrokerException {
        String msg = "Found incomplete conversion of transactions from txnLog format on startup. Will redo or complete conversion";
        logger.log(16, msg);
        if (TransactionLogManager.transactionLogExists(rootDir) && TransactionLogManager.incompleteTxnStoreExists(rootDir)) {
            TidList.deleteAllFiles(rootDir);
            TxnAckList.deleteAllFiles(rootDir);
            TxnConversionUtil.deleteConversionFile(rootDir, convertingFromTxnLogMode);
            return;
        }
        if (!TransactionLogManager.transactionLogExists(rootDir) || !TransactionLogManager.incompleteTxnStoreExists(rootDir)) {
            TidList.assertAllFilesExists(rootDir);
            TransactionLogManager.deleteAllFileState(rootDir);
            TxnConversionUtil.deleteConversionFile(rootDir, convertingFromTxnLogMode);
            return;
        }
        TidList.deleteAllFiles(rootDir);
        TxnAckList.deleteAllFiles(rootDir);
        TxnConversionUtil.deleteConversionFile(rootDir, convertingFromTxnLogMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertTxnFormats(FileStore fileStore, File rootDir, TransactionList transactionList) throws BrokerException, IOException {
        if (Globals.isNewTxnLogEnabled()) {
            if (Store.getDEBUG()) {
                String msg = "ConvertingTxnData :loading transactions from txn and txnack";
                logger.log(4, msg);
            }
            try {
                convertingToTxnLog = true;
                TxnConversionUtil.createConversionFile(rootDir, convertingToTxnLogMode);
                transactionList.loadTransactions();
                ToTxnLogConverter.convertToTxnLogFormat(transactionList, fileStore);
                fileStore.closeTidList();
                TidList.deleteAllFiles(rootDir);
                TxnAckList.deleteAllFiles(rootDir);
                TxnConversionUtil.deleteConversionFile(rootDir, convertingToTxnLogMode);
            }
            finally {
                convertingToTxnLog = false;
            }
        } else {
            TxnConversionUtil.createConversionFile(rootDir, convertingFromTxnLogMode);
            FromTxnLogConverter txnCoverter = new FromTxnLogConverter(fileStore);
            txnCoverter.convertFromTxnLogFormat();
            transactionList.loadTransactions();
            fileStore.closeTxnLogManager();
            TransactionLogManager.deleteAllFileState(rootDir);
            TxnConversionUtil.deleteConversionFile(rootDir, convertingFromTxnLogMode);
        }
    }

    public static void createConversionFile(File rootDir, String fileName) throws BrokerException {
        File file = new File(rootDir, fileName);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new BrokerException("can not create transaction conversion file " + String.valueOf(file), e);
        }
    }

    public static void deleteConversionFile(File rootDir, String fileName) throws BrokerException {
        boolean deleted;
        File file = new File(rootDir, fileName);
        if (file.exists() && !(deleted = file.delete())) {
            throw new BrokerException("can not delete transaction conversion file " + String.valueOf(file));
        }
    }

    static {
        logger = Globals.getLogger();
    }
}

