/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.BindRouteCommand;
import org.eclipse.orion.server.cf.commands.BindServicesCommand;
import org.eclipse.orion.server.cf.commands.CreateApplicationCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.commands.UpdateApplicationCommand;
import org.eclipse.orion.server.cf.commands.UploadBitsCommand;
import org.eclipse.orion.server.cf.ds.IDeploymentPackager;
import org.eclipse.orion.server.cf.ext.ICFDeploymentExtService;
import org.eclipse.orion.server.cf.ext.ICFEnvironmentExtService;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushAppCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private App app;
    private IFileStore appStore;
    private String commandName = "Push application";
    private IDeploymentPackager packager;
    private String command;

    public PushAppCommand(Target target, App app, IFileStore appStore, IDeploymentPackager packager) {
        super(target);
        this.app = app;
        this.appStore = appStore;
        this.packager = packager;
    }

    public PushAppCommand(Target target, App app, IFileStore appStore, IDeploymentPackager packager, String command) {
        super(target);
        this.app = app;
        this.appStore = appStore;
        this.packager = packager;
        this.command = command;
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        GetAppCommand.expire(this.target, this.app.getName());
        try {
            ICFEnvironmentExtService environmentExtService;
            AbstractCFCommand setUpApplication = null;
            if (this.app.getSummaryJSON() != null) {
                this.app.setGuid(this.app.getSummaryJSON().getString("guid"));
                setUpApplication = new UpdateApplicationCommand(this.target, this.app);
            } else {
                setUpApplication = new CreateApplicationCommand(this.target, this.app);
            }
            ServerStatus jobStatus = (ServerStatus)setUpApplication.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return status;
            }
            JSONObject respAppJSON = jobStatus.getJsonData();
            ICFDeploymentExtService deploymentExtService = CFActivator.getDefault().getCFDeploymentExtDeploymentService();
            if (deploymentExtService != null && (environmentExtService = deploymentExtService.getDefaultEnvironmentExtService()) != null && environmentExtService.applies(this.app.getManifest())) {
                ServerStatus envExtStatus = environmentExtService.apply(this.target, this.app);
                status.add(envExtStatus);
                if (!envExtStatus.isOK()) {
                    return status;
                }
            }
            BindRouteCommand bindRoute = new BindRouteCommand(this.target, this.app);
            ServerStatus multijobStatus = (ServerStatus)bindRoute.doIt();
            status.add(multijobStatus);
            if (!multijobStatus.isOK()) {
                return status;
            }
            UploadBitsCommand uploadBits = new UploadBitsCommand(this.target, this.app, this.appStore, this.packager, this.command);
            multijobStatus = (ServerStatus)uploadBits.doIt();
            status.add(multijobStatus);
            if (!multijobStatus.isOK()) {
                return status;
            }
            BindServicesCommand bindServices = new BindServicesCommand(this.target, this.app);
            multijobStatus = (ServerStatus)bindServices.doIt();
            status.add(multijobStatus);
            if (!multijobStatus.isOK()) {
                return status;
            }
            ManifestParseTree manifest = this.app.getManifest();
            ManifestParseTree timeoutNode = manifest.get("applications").get(0).getOpt("timeout");
            int timeout = timeoutNode != null ? Integer.parseInt(timeoutNode.getValue()) : 60;
            JSONObject result = new JSONObject();
            result.put("Target", (Object)this.target.toJSON());
            if (this.target.getManageUrl() != null) {
                result.put("ManageUrl", (Object)(String.valueOf(this.target.getManageUrl().toString()) + "#/resources/appGuid=" + this.app.getGuid() + "&orgGuid=" + this.target.getOrg().getGuid() + "&spaceGuid=" + this.target.getSpace().getGuid()));
            }
            result.put("App", (Object)respAppJSON);
            result.put("Domain", (Object)bindRoute.getDomainName());
            result.put("Route", (Object)bindRoute.getRoute());
            result.put("Timeout", timeout);
            result.put("DeployedPackage", (Object)uploadBits.getDeployedAppPackageName());
            status.add(new ServerStatus(Status.OK_STATUS, 200, result));
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return status;
        }
    }
}

