/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMetaStoreMigration {
    private static final long OLD_PASSWORD_RESET_ID_THRESHOLD = 604800000L;
    public static final int VERSION4 = 4;
    public static final int VERSION6 = 6;
    public static final int VERSION7 = 7;
    private Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");

    public void doMigration(File rootLocation, File userMetaFolder) throws JSONException {
        String userId = userMetaFolder.getName();
        this.logger.info("Migration: Start migrating user " + userId + " to the latest (version " + 8 + ")");
        int oldVersion = this.readOrionVersion(userMetaFolder, "user");
        File userMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, "user");
        File[] files = userMetaFolder.listFiles();
        int directoryCount = 0;
        int i = 0;
        while (i < files.length) {
            File next = files[i];
            if (next.isFile()) {
                if (!next.equals(userMetaFile)) {
                    if ((oldVersion == 6 || oldVersion == 7) && next.getName().endsWith(".json")) {
                        File parent = next.getParentFile();
                        String name = next.getName().substring(0, next.getName().length() - ".json".length());
                        this.updateOrionVersion(parent, name);
                        if (oldVersion == 6) {
                            this.updateProjectContentLocation(parent, name);
                        }
                    } else {
                        SimpleMetaStoreUtil.archive(rootLocation, next);
                    }
                }
            } else if (next.isDirectory()) {
                if (oldVersion == 4) {
                    this.updateWorkspaceFolder(rootLocation, next);
                    ++directoryCount;
                } else {
                    ++directoryCount;
                }
            }
            ++i;
        }
        if ((oldVersion == 4 || oldVersion == 6) && directoryCount > 1) {
            this.mergeMultipleWorkspaces(directoryCount, userMetaFolder);
        }
        this.updateOrionProperties(userMetaFolder);
        this.updateOrionVersion(userMetaFolder, "user");
        this.logger.info("Migration: Finished migrating user " + userId);
    }

    public boolean isMigrationRequired(JSONObject jsonObject) throws JSONException, CoreException {
        if (!jsonObject.has("OrionVersion")) {
            return true;
        }
        int version = jsonObject.getInt("OrionVersion");
        if (version < 8) {
            return true;
        }
        if (version > 8) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStoreMigration.isMigrationRequired: cannot run an old server (version 8) on metadata that is at a newer version (version " + version + ")", null));
        }
        return false;
    }

    private void mergeMultipleWorkspaces(int count, File userMetaFolder) throws JSONException {
        JSONObject userJSON = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, "user");
        JSONArray workspaceIds = userJSON.getJSONArray("WorkspaceIds");
        boolean changedUserJSON = false;
        boolean changedWorkspaceJSON = false;
        if (workspaceIds.length() == count) {
            String firstWorkspaceId = null;
            JSONObject firstWorkspaceJSON = null;
            File firstWorkspaceFolder = null;
            int i = 0;
            while (i < workspaceIds.length()) {
                String workspaceId = workspaceIds.getString(i);
                String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
                if (SimpleMetaStoreUtil.isMetaFile(userMetaFolder, workspaceId) && SimpleMetaStoreUtil.isMetaFolder(userMetaFolder, encodedWorkspaceName)) {
                    JSONObject workspaceJSON = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, workspaceId);
                    File workspaceFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
                    if (firstWorkspaceId == null) {
                        firstWorkspaceId = workspaceId;
                        firstWorkspaceJSON = workspaceJSON;
                        firstWorkspaceFolder = workspaceFolder;
                    } else {
                        JSONArray projectNames = workspaceJSON.getJSONArray("ProjectNames");
                        int p = 0;
                        while (p < projectNames.length()) {
                            String projectName = projectNames.getString(p);
                            if (SimpleMetaStoreUtil.isMetaFolder(workspaceFolder, projectName) && SimpleMetaStoreUtil.isMetaFile(userMetaFolder, projectName)) {
                                File originalProjectFolder = SimpleMetaStoreUtil.retrieveMetaFolder(workspaceFolder, projectName);
                                SimpleMetaStoreUtil.moveMetaFolder(workspaceFolder, projectName, firstWorkspaceFolder, projectName);
                                File newProjectFolder = SimpleMetaStoreUtil.retrieveMetaFolder(firstWorkspaceFolder, projectName);
                                this.logger.info("Migration: Moved project folder: " + originalProjectFolder.toString() + " to " + newProjectFolder.toString());
                                JSONObject projectJSON = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, projectName);
                                String contentLocation = newProjectFolder.toURI().toString();
                                contentLocation = contentLocation.substring(0, contentLocation.length() - 1);
                                String encodedContentLocation = SimpleMetaStoreUtil.encodeProjectContentLocation(contentLocation);
                                projectJSON.put("ContentLocation", (Object)encodedContentLocation);
                                projectJSON.put("WorkspaceId", (Object)firstWorkspaceId);
                                SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, projectName, projectJSON);
                                File updatedMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, projectName);
                                this.logger.info("Migration: Updated project metadata: " + updatedMetaFile.toString() + " with new workspaceId " + firstWorkspaceId);
                            }
                            JSONArray firstWorkspaceProjectNames = firstWorkspaceJSON.getJSONArray("ProjectNames");
                            firstWorkspaceProjectNames.put((Object)projectName);
                            this.logger.info("Migration: Updated workspace metadata: updated workspace " + firstWorkspaceId + " with new project " + projectName);
                            changedWorkspaceJSON = true;
                            ++p;
                        }
                        SimpleMetaStoreUtil.deleteMetaFolder(userMetaFolder, encodedWorkspaceName, true);
                        this.logger.info("Migration: Updated workspace metadata: deleted multiple workspace folder of " + workspaceId + " at " + workspaceFolder);
                        File workspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, workspaceId);
                        SimpleMetaStoreUtil.deleteMetaFile(userMetaFolder, workspaceId);
                        this.logger.info("Migration: Updated workspace metadata: deleted multiple workspace file at " + workspaceMetaFile);
                        changedUserJSON = true;
                    }
                } else {
                    this.logger.info("Migration: Workspace folder contains invalid metadata: orphan folder " + workspaceId);
                }
                ++i;
            }
            if (firstWorkspaceId != null) {
                if (changedUserJSON) {
                    this.updateUserJson(userMetaFolder, userJSON, firstWorkspaceId);
                    this.logger.info("Migration: Updated user metadata: user has one workspace " + firstWorkspaceId);
                }
                if (changedWorkspaceJSON) {
                    File updatedMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, firstWorkspaceId);
                    SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, firstWorkspaceId, firstWorkspaceJSON);
                    this.logger.info("Migration: Updated workspace metadata: updated workspace metadata at " + updatedMetaFile.toString());
                }
            }
        }
    }

    private void moveProjectJsonFile(File folder, String projectName) {
        File userMetaFolder = folder.getParentFile();
        File oldProjectMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(folder, projectName);
        File newProjectMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, projectName);
        if (newProjectMetaFile.exists()) {
            this.logger.error("Migration: Duplicate project metadata file at " + newProjectMetaFile.toString());
            return;
        }
        SimpleMetaStoreUtil.moveMetaFile(folder, projectName, userMetaFolder, projectName);
        this.logger.info("Migration: Old project metadata file " + oldProjectMetaFile.toString() + " has been moved to " + newProjectMetaFile.toString());
    }

    private void moveWorkspaceJsonFile(File folder) throws JSONException {
        File parent = folder.getParentFile();
        File oldWorkspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(folder, "workspace");
        JSONObject workspaceJSON = SimpleMetaStoreUtil.readMetaFile(folder, "workspace");
        if (!workspaceJSON.has("UniqueId")) {
            this.logger.error("Migration: Workspace metadata is missing UniqueId " + oldWorkspaceMetaFile.toString());
            return;
        }
        String workspaceId = workspaceJSON.getString("UniqueId");
        File newWorkspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, workspaceId);
        if (newWorkspaceMetaFile.exists()) {
            this.logger.error("Migration: Duplicate workspace metadata file at " + newWorkspaceMetaFile.toString());
            return;
        }
        SimpleMetaStoreUtil.moveMetaFile(folder, "workspace", parent, workspaceId);
        this.logger.info("Migration: Old workspace metadata file " + oldWorkspaceMetaFile.toString() + " has been moved to " + newWorkspaceMetaFile.toString());
    }

    private void updateOrionProperties(File parent) throws JSONException {
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(parent, "user");
        JSONObject properties = jsonObject.getJSONObject("Properties");
        if (jsonObject.has("profileProperties")) {
            JSONObject profileProperties = jsonObject.getJSONObject("profileProperties");
            if (profileProperties.has("openid")) {
                String openid = profileProperties.getString("openid");
                if (!openid.replaceAll("\n", "").equals("")) {
                    properties.put("OpenId", (Object)openid);
                }
                profileProperties.remove("openid");
            }
            if (profileProperties.has("oauth")) {
                String oauth = profileProperties.getString("oauth");
                properties.put("OAuth", (Object)oauth);
                profileProperties.remove("oauth");
            }
            if (profileProperties.has("passwordResetId")) {
                String passwordResetId = profileProperties.getString("passwordResetId");
                try {
                    boolean isRecent;
                    String timestampStr = passwordResetId.substring(0, passwordResetId.indexOf(45));
                    long lastLogin = Long.parseLong(timestampStr);
                    boolean bl = isRecent = System.currentTimeMillis() - lastLogin < 604800000L;
                    if (isRecent) {
                        properties.put("PasswordResetId", (Object)passwordResetId);
                    }
                }
                catch (Exception exception) {}
                profileProperties.remove("passwordResetId");
            }
            if (profileProperties.length() == 0) {
                jsonObject.remove("profileProperties");
            }
        }
        if (jsonObject.has("email")) {
            String email = jsonObject.getString("email");
            properties.put("Email", (Object)email);
            jsonObject.remove("email");
        }
        if (jsonObject.has("blocked")) {
            String blocked = jsonObject.getString("blocked");
            properties.put("Blocked", (Object)blocked);
            jsonObject.remove("blocked");
        }
        if (jsonObject.has("email_confirmation")) {
            String email_confirmation = jsonObject.getString("email_confirmation");
            properties.put("EmailConfirmationId", (Object)email_confirmation);
            jsonObject.remove("email_confirmation");
        }
        if (jsonObject.has("diskusage")) {
            String diskusage = jsonObject.getString("diskusage");
            properties.put("DiskUsage", (Object)diskusage);
            jsonObject.remove("diskusage");
        }
        if (jsonObject.has("diskusagetimestamp")) {
            String diskusagetimestamp = jsonObject.getString("diskusagetimestamp");
            properties.put("DiskUsageTimestamp", (Object)diskusagetimestamp);
            jsonObject.remove("diskusagetimestamp");
        }
        if (jsonObject.has("lastlogintimestamp")) {
            String lastlogintimestamp = jsonObject.getString("lastlogintimestamp");
            properties.put("LastLoginTimestamp", (Object)lastlogintimestamp);
            jsonObject.remove("lastlogintimestamp");
        }
        if (jsonObject.has("password")) {
            String password = jsonObject.getString("password");
            properties.put("Password", (Object)password);
            jsonObject.remove("password");
        }
        if (jsonObject.has("GitName") && jsonObject.has("GitMail") && !properties.has("git/config/userInfo")) {
            String gitName = jsonObject.getString("GitName");
            String gitMail = jsonObject.getString("GitMail");
            properties.put("git/config/userInfo", (Object)("{\"GitName\":\"" + gitName + "\",\"GitMail\":\"" + gitMail + "\"}"));
        }
        if (jsonObject.has("GitName")) {
            jsonObject.remove("GitName");
        }
        if (jsonObject.has("GitMail")) {
            jsonObject.remove("GitMail");
        }
        SimpleMetaStoreUtil.updateMetaFile(parent, "user", jsonObject);
        File metaFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, "user");
        this.logger.info("Migration: Updated Orion properties to version 8 in metadata file: " + metaFile.toString());
    }

    private void updateOrionVersion(File parent, String name) throws JSONException {
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(parent, name);
        int oldVersion = -1;
        if (jsonObject.has("OrionVersion")) {
            oldVersion = jsonObject.getInt("OrionVersion");
        }
        jsonObject.put("OrionVersion", 8);
        SimpleMetaStoreUtil.updateMetaFile(parent, name, jsonObject);
        File metaFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
        String oldVersionStr = oldVersion == -1 ? "UNKNOWN" : Integer.toString(oldVersion);
        this.logger.info("Migration: Updated Orion version from version " + oldVersionStr + " to version " + 8 + " in metadata file: " + metaFile.toString());
    }

    private int readOrionVersion(File parent, String name) throws JSONException {
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(parent, name);
        if (jsonObject == null) {
            throw new RuntimeException("Meta File Error, cannot read JSON file", null);
        }
        if (jsonObject.has("OrionVersion")) {
            return jsonObject.getInt("OrionVersion");
        }
        return -1;
    }

    private void updateUserJson(File userMetaFolder, JSONObject userJSON, String workspaceId) throws JSONException {
        JSONArray workspaceIds = new JSONArray();
        workspaceIds.put((Object)workspaceId);
        userJSON.put("WorkspaceIds", (Object)workspaceIds);
        JSONObject properties = userJSON.getJSONObject("Properties");
        JSONArray userRights = new JSONArray();
        JSONObject userRight = new JSONObject();
        userRight.put("Method", 15);
        String usersRight = "/users/";
        userRight.put("Uri", (Object)usersRight.concat(userMetaFolder.getName()));
        userRights.put((Object)userRight);
        userRight = new JSONObject();
        userRight.put("Method", 15);
        String workspaceRight = "/workspace/";
        userRight.put("Uri", (Object)workspaceRight.concat(workspaceId));
        userRights.put((Object)userRight);
        userRight = new JSONObject();
        userRight.put("Method", 15);
        userRight.put("Uri", (Object)workspaceRight.concat(workspaceId).concat("/*"));
        userRights.put((Object)userRight);
        userRight = new JSONObject();
        userRight.put("Method", 15);
        String fileRight = "/file/";
        userRight.put("Uri", (Object)fileRight.concat(workspaceId));
        userRights.put((Object)userRight);
        userRight = new JSONObject();
        userRight.put("Method", 15);
        userRight.put("Uri", (Object)fileRight.concat(workspaceId).concat("/*"));
        userRights.put((Object)userRight);
        properties.put("UserRights", (Object)userRights);
        userJSON.put("Properties", (Object)properties);
        SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, "user", userJSON);
    }

    private void updateWorkspaceFolder(File rootLocation, File workspaceMetaFolder) throws JSONException {
        if (!SimpleMetaStoreUtil.isMetaFile(workspaceMetaFolder, "workspace")) {
            SimpleMetaStoreUtil.archive(rootLocation, workspaceMetaFolder);
            return;
        }
        File workspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(workspaceMetaFolder, "workspace");
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(workspaceMetaFolder, "workspace");
        if (!jsonObject.has("ProjectNames")) {
            this.logger.error("Migration: Workspace metadata is missing ProjectNames " + workspaceMetaFile.toString());
            return;
        }
        JSONArray projectNames = jsonObject.getJSONArray("ProjectNames");
        ArrayList<String> projectNameList = new ArrayList<String>();
        int i = 0;
        while (i < projectNames.length()) {
            projectNameList.add(projectNames.getString(i));
            ++i;
        }
        File[] files = workspaceMetaFolder.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            File next = files[i2];
            if (!next.equals(workspaceMetaFile)) {
                String name;
                String decodedProjectName;
                if (next.isDirectory()) {
                    String decodedProjectName2 = SimpleMetaStoreUtil.decodeProjectNameFromProjectId(next.getName());
                    if (!projectNameList.contains(decodedProjectName2)) {
                        SimpleMetaStoreUtil.archive(rootLocation, next);
                    }
                } else if (next.isFile() && next.getName().endsWith(".json") && projectNameList.contains(decodedProjectName = SimpleMetaStoreUtil.decodeProjectNameFromProjectId(name = next.getName().substring(0, next.getName().length() - ".json".length())))) {
                    if (this.readOrionVersion(workspaceMetaFolder, name) == -1) {
                        return;
                    }
                    this.updateOrionVersion(workspaceMetaFolder, name);
                    this.updateProjectContentLocation(workspaceMetaFolder, name);
                    this.moveProjectJsonFile(workspaceMetaFolder, name);
                }
            }
            ++i2;
        }
        this.updateOrionVersion(workspaceMetaFolder, "workspace");
        this.moveWorkspaceJsonFile(workspaceMetaFolder);
    }

    private void updateProjectContentLocation(File parent, String name) throws JSONException {
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(parent, name);
        if (jsonObject.has("ContentLocation")) {
            String contentLocation = jsonObject.getString("ContentLocation");
            String encodedContentLocation = SimpleMetaStoreUtil.encodeProjectContentLocation(contentLocation);
            jsonObject.put("ContentLocation", (Object)encodedContentLocation);
            SimpleMetaStoreUtil.updateMetaFile(parent, name, jsonObject);
            File metaFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            this.logger.info("Migration: Updated the ContentLocation in metadata file: " + metaFile.toString());
        }
    }
}

