/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Status")
public class Status
extends GitObject {
    public static final String RESOURCE = "status";
    public static final String TYPE = "Status";
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private URI baseLocation;
    private org.eclipse.jgit.api.Status status;
    private IPath basePath;

    public Status(URI baseLocation, Repository db, org.eclipse.jgit.api.Status status, IPath basePath) throws URISyntaxException, CoreException {
        super(BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.STATUS), db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Added"), new Property("Changed"), new Property("Missing"), new Property("Modified"), new Property("Removed"), new Property("Untracked"), new Property("Conflicting"), new Property("RepositoryState"), new Property("IndexLocation"), new Property("CommitLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.baseLocation = baseLocation;
        this.status = status;
        this.basePath = basePath;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Added")
    private JSONArray getAdded() throws JSONException, URISyntaxException {
        return this.toJSONArray(this.status.getAdded(), this.basePath, this.baseLocation, "Default");
    }

    @PropertyDescription(name="Changed")
    private JSONArray getChanged() throws JSONException, URISyntaxException {
        return this.toJSONArray(this.status.getChanged(), this.basePath, this.baseLocation, "Cached");
    }

    @PropertyDescription(name="Missing")
    private JSONArray getMissing() throws JSONException, URISyntaxException {
        return this.toJSONArray(this.status.getMissing(), this.basePath, this.baseLocation, "Default");
    }

    @PropertyDescription(name="Modified")
    private JSONArray getModified() throws JSONException, URISyntaxException {
        return this.toJSONArray(this.status.getModified(), this.basePath, this.baseLocation, "Default");
    }

    @PropertyDescription(name="Removed")
    private JSONArray getRemoved() throws JSONException, URISyntaxException {
        return this.toJSONArray(this.status.getRemoved(), this.basePath, this.baseLocation, "Cached");
    }

    @PropertyDescription(name="Untracked")
    private JSONArray getUntracked() throws JSONException, URISyntaxException {
        return this.toJSONArray(this.status.getUntracked(), this.basePath, this.baseLocation, "Default");
    }

    @PropertyDescription(name="Conflicting")
    private JSONArray getConflicting() throws JSONException, URISyntaxException {
        return this.toJSONArray(this.status.getConflicting(), this.basePath, this.baseLocation, "Default");
    }

    @PropertyDescription(name="RepositoryState")
    private String getRepositoryState() {
        return this.db.getRepositoryState().name();
    }

    @PropertyDescription(name="IndexLocation")
    private URI getIndexLocation() throws URISyntaxException {
        return this.statusToIndexLocation(this.baseLocation);
    }

    @PropertyDescription(name="CommitLocation")
    private URI getCommitLocation() throws URISyntaxException {
        return this.statusToCommitLocation(this.baseLocation, "HEAD");
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return this.baseLocation;
    }

    private JSONArray toJSONArray(Set<String> set, IPath basePath, URI baseLocation, String diffType) throws JSONException, URISyntaxException {
        JSONArray result = new JSONArray();
        DirCache cache = null;
        try {
            cache = this.db.readDirCache();
        }
        catch (Exception exception) {}
        for (String s : set) {
            JSONObject object = new JSONObject();
            boolean isSubmodule = false;
            boolean isDirectory = false;
            if (cache != null) {
                DirCacheEntry entry = cache.getEntry(s);
                int fileMode = -1;
                if (entry != null) {
                    fileMode = entry.getRawMode();
                }
                isSubmodule = fileMode != -1 && fileMode == 57344;
                isDirectory = fileMode != -1 && (fileMode & 0x4000) != 0;
            }
            object.put("Name", (Object)s);
            IPath relative = new Path(s).makeRelativeTo(basePath);
            object.put("Path", (Object)relative);
            URI fileLocation = this.statusToFileLocation(baseLocation);
            object.put("Location", (Object)URIUtil.append((URI)fileLocation, (String)relative.toString()));
            if (isDirectory) {
                object.put("Directory", true);
            }
            if (isSubmodule) {
                object.put("IsSubmodule", true);
            }
            JSONObject gitSection = new JSONObject();
            URI diffLocation = this.statusToDiffLocation(baseLocation, diffType);
            gitSection.put("DiffLocation", (Object)URIUtil.append((URI)diffLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            URI commitLocation = this.statusToCommitLocation(baseLocation, "HEAD");
            gitSection.put("CommitLocation", (Object)URIUtil.append((URI)commitLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            URI indexLocation = this.statusToIndexLocation(baseLocation);
            gitSection.put("IndexLocation", (Object)URIUtil.append((URI)indexLocation, (String)relative.toString()));
            object.put("Git", (Object)gitSection);
            result.put((Object)object);
        }
        return result;
    }

    private URI statusToFileLocation(URI u) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToDiffLocation(URI u, String diffType) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        uriPath = String.valueOf(prefix) + "/gitapi" + '/' + "diff" + '/' + diffType + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToCommitLocation(URI u, String ref) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        uriPath = String.valueOf(prefix) + "/gitapi" + '/' + "commit" + '/' + ref + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }

    private URI statusToIndexLocation(URI u) throws URISyntaxException {
        String uriPath = u.getPath();
        String prefix = uriPath.substring(0, uriPath.indexOf("/gitapi"));
        uriPath = uriPath.substring(prefix.length() + "/gitapi/status".length());
        uriPath = String.valueOf(prefix) + "/gitapi" + '/' + "index" + uriPath;
        return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), uriPath, u.getQuery(), u.getFragment());
    }
}

