/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.jobs.StatusJob;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.osgi.util.NLS;

public class GitStatusHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitStatusHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String gitPathInfo) throws ServletException {
        Path path;
        block4: {
            try {
                path = new Path(gitPathInfo);
                if (!path.hasTrailingSeparator()) {
                    String msg = NLS.bind((String)"Cannot get status on a file: {0}", (Object)gitPathInfo);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                if (AuthorizationService.checkRights((String)request.getRemoteUser(), (String)("/" + path.toString()), (String)request.getMethod())) break block4;
                response.sendError(403);
                return true;
            }
            catch (Exception e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "Error generating status response", (Throwable)e));
            }
        }
        StatusJob job = new StatusJob(TaskJobHandler.getUserId((HttpServletRequest)request), path, GitStatusHandlerV1.getURI((HttpServletRequest)request));
        return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
    }
}

