/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import org.json.JSONException;
import org.json.JSONObject;

public class HostFingerprintException
extends JSchException {
    private static final long serialVersionUID = -8889137881831717667L;
    private static final String HOST = "Host";
    private static final String HOST_FINGERPRINT = "HostFingerprint";
    private static final String HOST_KEY = "HostKey";
    private static final String KEY_TYPE = "KeyType";
    private HostKey hostkey;

    public HostFingerprintException(String host, byte[] key) {
        super("The authenticity of host " + host + " can't be established");
        try {
            this.hostkey = new HostKey(host, key);
        }
        catch (JSchException jSchException) {}
    }

    public HostKey getHostkey() {
        return this.hostkey;
    }

    public JSONObject formJson() {
        JSONObject result = new JSONObject();
        try {
            if (this.hostkey != null) {
                result.put(HOST, (Object)this.hostkey.getHost());
                result.put(HOST_FINGERPRINT, (Object)this.hostkey.getFingerPrint(new JSch()));
                result.put(HOST_KEY, (Object)this.hostkey.getKey());
                result.put(KEY_TYPE, (Object)this.hostkey.getType());
            }
        }
        catch (JSONException jSONException) {}
        return result;
    }
}

