/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formoauth;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.server.authentication.oauth.OAuthConsumer;
import org.eclipse.orion.server.authentication.oauth.OAuthException;
import org.eclipse.orion.server.authentication.oauth.OAuthHelper;
import org.eclipse.orion.server.authentication.oauth.OAuthParams;
import org.eclipse.orion.server.authentication.oauth.github.GitHubOAuthParams;
import org.eclipse.orion.server.authentication.oauth.google.GoogleOAuthParams;
import org.eclipse.orion.server.core.resources.Base64;

public class ManageOAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = -3863741024714602634L;
    private OAuthParams oauthParams;

    private static void writeOAuthError(String error, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("redirect") == null) {
            resp.setContentType("text/html; charset=UTF-8");
            PrintWriter out = resp.getWriter();
            out.println("<html><head></head>");
            out.print("<body onload=\"window.opener.handleOAuthResponse((window.location+'').split('?')[1],'");
            out.print(error);
            out.println("');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<html><head></head>");
        String url = req.getParameter("redirect");
        url = url.replaceAll("/&error(\\=[^&]*)?(?=&|$)|^error(\\=[^&]*)?(&|$)/", "");
        out.print("<body onload=\"window.location.replace('");
        out.print(url.toString());
        if (url.contains("?")) {
            out.print("&error=");
        } else {
            out.print("?error=");
        }
        out.print(new String(Base64.encode((byte[])error.getBytes())));
        out.println("');\">");
        out.println("</body>");
        out.println("</html>");
    }

    private void handleGet(HttpServletRequest req, HttpServletResponse resp, Boolean login) throws ServletException, IOException, OAuthException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/oauth")) {
            String oauthParam = req.getParameter("oauth");
            if (oauthParam != null) {
                OAuthHelper.redirectToOAuthProvider(req, resp, this.getOAuthParams(req, oauthParam, login));
            } else {
                OAuthConsumer oauthConsumer = OAuthHelper.handleOAuthReturnAndTokenAccess(req, resp, this.getOAuthParams());
                if (login.booleanValue()) {
                    OAuthHelper.handleLogin(req, resp, oauthConsumer);
                } else {
                    OAuthHelper.handleReturnAndLinkAccount(req, resp, oauthConsumer);
                }
            }
        }
    }

    private OAuthParams getOAuthParams(HttpServletRequest req, String type, boolean login) throws OAuthException {
        if (type.equals("google")) {
            this.oauthParams = new GoogleOAuthParams(req, login);
        } else if (type.equals("github")) {
            this.oauthParams = new GitHubOAuthParams(req, login);
        } else {
            throw new OAuthException("No OAuth provider given");
        }
        return this.getOAuthParams();
    }

    private OAuthParams getOAuthParams() throws OAuthException {
        if (this.oauthParams == null) {
            throw new OAuthException("No OAuth provider given");
        }
        return this.oauthParams;
    }

    public void handleGetAndLink(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.handleGet(req, resp, false);
        }
        catch (OAuthException e) {
            ManageOAuthServlet.writeOAuthError(e.getMessage(), req, resp);
        }
    }

    public void handleGetAndLogin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, OAuthException {
        this.handleGet(req, resp, true);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/oauth")) {
            this.handleGetAndLink(req, resp);
        }
    }
}

