/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.sftpfile.AuthCoreException;

public abstract class ServletResourceHandler<T> {
    public static Method getMethod(HttpServletRequest request) {
        return Method.fromString(request.getMethod());
    }

    public static URI getURI(HttpServletRequest request) {
        String path = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            path = String.valueOf(path) + request.getPathInfo();
        }
        try {
            return new URI("orion", null, path, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URI resovleOrionURI(HttpServletRequest request, URI uri) {
        if (!uri.getScheme().equals("orion")) {
            return uri;
        }
        try {
            return new URI(null, null, String.valueOf(request.getContextPath()) + uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String toOrionLocation(HttpServletRequest request, String location) {
        String contextPath = request.getContextPath();
        if (location != null && contextPath.length() != 0 && location.startsWith(contextPath)) {
            location = location.substring(contextPath.length());
        }
        return location;
    }

    public abstract boolean handleRequest(HttpServletRequest var1, HttpServletResponse var2, T var3) throws ServletException;

    protected boolean handleAuthFailure(HttpServletRequest request, HttpServletResponse response, Exception e) {
        if (e instanceof AuthCoreException) {
            String realm = ((AuthCoreException)((Object)e)).getRealm();
            response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
            try {
                response.sendError(401);
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    protected IFileStore resolveSourceLocation(HttpServletRequest request, String locationString) throws URISyntaxException {
        URI sourceLocation = new URI(locationString);
        String sourcePath = sourceLocation.getPath().substring(request.getContextPath().length());
        IPath path = new Path(sourcePath).removeFirstSegments(1);
        return NewFileServlet.getFileStore(request, path);
    }

    public static enum Method {
        GET,
        HEAD,
        OPTIONS,
        POST,
        PUT,
        DELETE;


        public static Method fromString(String methodName) {
            if ("GET".equals(methodName)) {
                return GET;
            }
            if ("PUT".equals(methodName)) {
                return PUT;
            }
            if ("POST".equals(methodName)) {
                return POST;
            }
            if ("HEAD".equals(methodName)) {
                return HEAD;
            }
            if ("OPTIONS".equals(methodName)) {
                return OPTIONS;
            }
            if ("DELETE".equals(methodName)) {
                return DELETE;
            }
            return null;
        }
    }
}

