/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Org;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSpaceByNameCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private String spaceName;
    private String orgName;

    public GetSpaceByNameCommand(Target target, String orgName, String spaceName) {
        super(target);
        this.orgName = orgName;
        this.spaceName = spaceName;
        this.commandName = "Get Space By Name";
    }

    protected Space getSpace(JSONArray spaces, String orgSpace) throws JSONException {
        int i = 0;
        while (i < spaces.length()) {
            JSONObject spaceJSON = spaces.getJSONObject(i);
            if (orgSpace.equals(spaceJSON.getJSONObject("entity").getString("name"))) {
                return new Space().setCFJSON(spaceJSON);
            }
            ++i;
        }
        return null;
    }

    protected Org getOrganization(JSONArray orgs, String organization) throws JSONException {
        int i = 0;
        while (i < orgs.length()) {
            JSONObject orgJSON = orgs.getJSONObject(i);
            if (organization.equals(orgJSON.getJSONObject("entity").getString("name"))) {
                return new Org().setCFJSON(orgJSON);
            }
            ++i;
        }
        return null;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI orgsURI = targetURI.resolve("/v2/organizations");
            GetMethod getOrgsMethod = new GetMethod(orgsURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getOrgsMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus getOrgsStatus = HttpUtil.executeMethod((HttpMethodBase)getOrgsMethod);
            if (!getOrgsStatus.isOK() && getOrgsStatus.getHttpCode() != 206) {
                return getOrgsStatus;
            }
            JSONObject result = getOrgsStatus.getJsonData();
            JSONArray orgs = result.getJSONArray("resources");
            if (orgs.length() == 0) {
                return new ServerStatus(4, 404, "Organization not found", null);
            }
            Org organization = this.getOrganization(orgs, this.orgName);
            if (organization == null) {
                return new ServerStatus(4, 404, "Organization not found", null);
            }
            String spaceUrl = organization.getCFJSON().getJSONObject("entity").getString("spaces_url");
            URI spaceURI = targetURI.resolve(spaceUrl);
            GetMethod getSpaceMethod = new GetMethod(spaceURI.toString());
            confStatus = HttpUtil.configureHttpMethod((HttpMethod)getSpaceMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus getSpaceStatus = HttpUtil.executeMethod((HttpMethodBase)getSpaceMethod);
            if (!getSpaceStatus.isOK()) {
                return getSpaceStatus;
            }
            result = getSpaceStatus.getJsonData();
            JSONArray spaces = result.getJSONArray("resources");
            if (spaces.length() == 0) {
                return new ServerStatus(4, 404, "Space not found", null);
            }
            Space space = this.getSpace(spaces, this.spaceName);
            if (space == null) {
                return new ServerStatus(4, 404, "Space not found", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200, space.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

