/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.jobs;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.LogUtils;
import org.eclipse.orion.server.logs.objects.RollingFileAppenderResource;
import org.eclipse.osgi.util.NLS;

public class RollingFileAppenderJob
extends TaskJob {
    private final ILogService logService;
    private final URI baseLocation;
    private final String appenderName;

    public RollingFileAppenderJob(String userRunningTask, ILogService logService, URI baseLocation, String appenderName) {
        super(userRunningTask, false);
        this.logService = logService;
        this.baseLocation = baseLocation;
        this.appenderName = appenderName;
    }

    protected IStatus performJob() {
        try {
            RollingFileAppender<ILoggingEvent> appender = this.logService.getRollingFileAppender(this.appenderName);
            if (appender == null) {
                String msg = NLS.bind((String)"Rolling appender not found: {0}", (Object)this.appenderName);
                return new ServerStatus(4, 404, msg, null);
            }
            RollingFileAppenderResource rollingFileAppender = new RollingFileAppenderResource(appender, this.baseLocation);
            if (rollingFileAppender.getArchivedLogFiles() == null) {
                LogUtils.attachArchivedLogFiles(appender, rollingFileAppender, this.logService);
            }
            return new ServerStatus(Status.OK_STATUS, 200, rollingFileAppender.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when looking for rolling appender: {0}", (Object)this.appenderName);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

