/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public abstract class SWTPartRenderer
extends AbstractPartRenderer {
    Map<String, Image> imageMap = new HashMap<String, Image>();
    String pinURI = "platform:/plugin/org.eclipse.e4.ui.workbench.renderers.swt/icons/full/ovr16/pinned_ovr.gif";
    Image pinImage;
    private ISWTResourceUtilities resUtils;

    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                renderer.createGui(childME);
                ++i;
            }
        }
    }

    public void styleElement(MUIElement element, boolean active) {
        if (!active) {
            element.getTags().remove("active");
        } else {
            element.getTags().add("active");
        }
        if (element.getWidget() != null) {
            this.setCSSInfo(element, element.getWidget());
        }
    }

    public void setCSSInfo(MUIElement me, Object widget) {
        if (widget == null) {
            return;
        }
        IEclipseContext ctxt = this.getContext(me);
        if (ctxt == null) {
            return;
        }
        IStylingEngine engine = (IStylingEngine)ctxt.get(IStylingEngine.SERVICE_NAME);
        if (engine == null) {
            return;
        }
        EObject eObj = (EObject)me;
        String cssClassStr = String.valueOf('M') + eObj.eClass().getName();
        for (String tag : me.getTags()) {
            cssClassStr = String.valueOf(cssClassStr) + ' ' + tag;
        }
        String id = me.getElementId();
        if (id != null) {
            id = id.replace(".", "-");
        }
        engine.setClassnameAndId(widget, cssClassStr, id);
    }

    protected void reapplyStyles(Widget widget) {
        CSSEngine engine = WidgetElement.getEngine((Widget)widget);
        if (engine != null) {
            engine.applyStyles((Object)widget, false);
        }
    }

    public void bindWidget(MUIElement me, Object widget) {
        if (widget instanceof Widget) {
            ((Widget)widget).setData("modelElement", (Object)me);
            this.setCSSInfo(me, widget);
            Widget swtWidget = (Widget)widget;
            swtWidget.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MUIElement element = (MUIElement)e.widget.getData("modelElement");
                    if (element != null) {
                        SWTPartRenderer.this.unbindWidget(element);
                    }
                }
            });
        }
        me.setWidget(widget);
    }

    public Object unbindWidget(MUIElement me) {
        Widget widget = (Widget)me.getWidget();
        if (widget != null) {
            me.setWidget(null);
            if (!widget.isDisposed()) {
                widget.setData("modelElement", null);
            }
        }
        me.setRenderer(null);
        return widget;
    }

    protected Widget getParentWidget(MUIElement element) {
        return (Widget)element.getParent().getWidget();
    }

    public void disposeWidget(MUIElement element) {
        block4: {
            Widget curWidget;
            if (element.getWidget() instanceof Widget && (curWidget = (Widget)element.getWidget()) != null && !curWidget.isDisposed()) {
                this.unbindWidget(element);
                try {
                    curWidget.dispose();
                }
                catch (Exception e) {
                    Logger logService = (Logger)this.context.get(Logger.class);
                    if (logService == null) break block4;
                    String msg = "Error disposing widget for : " + element.getClass().getName();
                    if (element instanceof MUILabel) {
                        msg = String.valueOf(msg) + ' ' + ((MUILabel)element).getLocalizedLabel();
                    }
                    logService.error((Throwable)e, msg);
                }
            }
        }
        element.setWidget(null);
    }

    public void hookControllerLogic(final MUIElement me) {
        Object widget = me.getWidget();
        if (widget instanceof Control && me instanceof MUILabel) {
            ((Control)widget).getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = ((MUILabel)me).getLocalizedLabel();
                }
            });
        }
    }

    protected String getToolTip(MUILabel element) {
        String overrideTip = (String)((MUIElement)element).getTransientData().get("e4_override_title_tool_tip_key");
        return overrideTip == null ? element.getTooltip() : overrideTip;
    }

    protected Image getImageFromURI(String iconURI) {
        if (iconURI == null || iconURI.length() == 0) {
            return null;
        }
        Image image = this.imageMap.get(iconURI);
        if (image == null) {
            image = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))).createImage();
            this.imageMap.put(iconURI, image);
        }
        return image;
    }

    public Image getImage(MUILabel element) {
        Image image = (Image)((MUIElement)element).getTransientData().get("e4_override_icon_image_key");
        if (image == null || image.isDisposed()) {
            String iconURI = element.getIconURI();
            image = this.getImageFromURI(iconURI);
        }
        if (image != null) {
            image = this.adornImage((MUIElement)element, image);
        }
        return image;
    }

    private Image adornImage(MUIElement element, Image image) {
        Image previouslyAdornedImage = (Image)element.getTransientData().get("previouslyAdorned");
        if (previouslyAdornedImage != null && !previouslyAdornedImage.isDisposed()) {
            previouslyAdornedImage.dispose();
        }
        element.getTransientData().remove("Pin Adornment");
        Image adornedImage = image;
        if (element.getTags().contains("Pin Adornment") && (adornedImage = this.resUtils.adornImage(image, this.pinImage)) != image) {
            element.getTransientData().put("previouslyAdorned", adornedImage);
        }
        return adornedImage;
    }

    protected int calcVisibleIndex(MUIElement element) {
        MElementContainer parent = element.getParent();
        int curIndex = 0;
        for (MUIElement child : parent.getChildren()) {
            if (child == element) {
                return curIndex;
            }
            if (child.getWidget() == null) continue;
            ++curIndex;
        }
        return -1;
    }

    protected int calcIndex(MUIElement element) {
        MElementContainer parent = element.getParent();
        return parent.getChildren().indexOf(element);
    }

    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
    }

    public void init(IEclipseContext context) {
        super.init(context);
        this.resUtils = (ISWTResourceUtilities)context.get(IResourceUtilities.class.getName());
        this.pinImage = this.getImageFromURI(this.pinURI);
        Display.getCurrent().disposeExec(new Runnable(){

            @Override
            public void run() {
                for (Image image : SWTPartRenderer.this.imageMap.values()) {
                    image.dispose();
                }
            }
        });
    }

    protected boolean requiresFocus(MPart element) {
        MUIElement focussed = SWTPartRenderer.getModelElement(Display.getDefault().getFocusControl());
        if (focussed == null) {
            return true;
        }
        do {
            if (focussed != element && focussed != element.getToolbar()) continue;
            return false;
        } while ((focussed = focussed.getParent()) != null);
        return true;
    }

    protected static MUIElement getModelElement(Control ctrl) {
        if (ctrl == null) {
            return null;
        }
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        if (element != null) {
            return element;
        }
        return SWTPartRenderer.getModelElement((Control)ctrl.getParent());
    }

    public void forceFocus(MUIElement element) {
        Control ctrl;
        if (element.getWidget() instanceof Control && !(ctrl = (Control)element.getWidget()).isDisposed()) {
            ctrl.forceFocus();
        }
    }
}

