/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.hosting.HostingActivator;
import org.eclipse.orion.internal.server.hosting.IHostedSite;
import org.eclipse.orion.internal.server.hosting.ISiteHostingService;
import org.eclipse.orion.internal.server.hosting.SiteHostingException;
import org.eclipse.orion.internal.server.hosting.SiteHostingService;
import org.eclipse.orion.internal.server.hosting.SiteInfo;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SiteConfigurationResourceHandler
extends ServletResourceHandler<SiteInfo> {
    private final ServletResourceHandler<IStatus> statusHandler;

    public SiteConfigurationResourceHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public static SiteInfo createFromJSON(UserInfo user, String name, String workspace, JSONObject object) throws CoreException {
        if (name == null || name.length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Name is missing", null));
        }
        if (workspace == null || name.length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Workspace is missing", null));
        }
        SiteInfo site = SiteInfo.newSiteConfiguration(user, name, workspace);
        SiteConfigurationResourceHandler.copyProperties(object, site, false);
        site.save(user);
        return site;
    }

    private static void copyProperties(JSONObject source, SiteInfo target, boolean copyName) throws CoreException {
        JSONArray mappings;
        String workspace;
        String hostHint;
        String name;
        if (copyName && (name = source.optString("Name", null)) != null) {
            target.setName(name);
        }
        if ((hostHint = source.optString("HostHint", null)) != null) {
            target.setHostHint(hostHint);
        }
        if ((workspace = source.optString("Workspace", null)) != null) {
            target.setWorkspace(workspace);
        }
        if ((mappings = source.optJSONArray("Mappings")) != null) {
            target.setMappings(mappings);
        }
        if (target.getName() == null || target.getName().length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Name was not specified", null));
        }
        if (target.getWorkspace() == null || target.getWorkspace().length() == 0) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, "Workspace was not specified", null));
        }
    }

    public static JSONObject toJSON(SiteInfo site, URI baseLocation) {
        JSONObject result = site.toJSON();
        try {
            result.put("Location", (Object)URIUtil.append((URI)baseLocation, (String)site.getId()));
        }
        catch (JSONException jSONException) {}
        return result;
    }

    private boolean handleGet(HttpServletRequest req, HttpServletResponse resp, SiteInfo site) throws IOException {
        URI location = SiteConfigurationResourceHandler.getURI((HttpServletRequest)req);
        URI baseLocation = location.resolve("");
        JSONObject result = SiteConfigurationResourceHandler.toJSON(site, baseLocation);
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.LOCATION_ONLY);
        return true;
    }

    private boolean handlePost(HttpServletRequest req, HttpServletResponse resp, SiteInfo site) throws CoreException, IOException, JSONException {
        if (site != null) {
            throw new IllegalArgumentException("Can't POST to an existing site");
        }
        UserInfo user = OrionConfiguration.getMetaStore().readUser(SiteConfigurationResourceHandler.getUserName(req));
        JSONObject requestJson = SiteConfigurationResourceHandler.getRequestJson(req);
        try {
            site = this.doCreateSiteConfiguration(req, requestJson, user);
            this.changeHostingStatus(req, resp, requestJson, user, site);
        }
        catch (CoreException e) {
            if (site != null) {
                site.delete(user);
            }
            throw e;
        }
        URI baseLocation = SiteConfigurationResourceHandler.getURI((HttpServletRequest)req);
        JSONObject result = SiteConfigurationResourceHandler.toJSON(site, baseLocation);
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.LOCATION_ONLY);
        resp.setStatus(201);
        resp.addHeader("Location", result.getString("Location"));
        return true;
    }

    private boolean handlePut(HttpServletRequest req, HttpServletResponse resp, SiteInfo site) throws IOException, CoreException, JSONException {
        UserInfo user = OrionConfiguration.getMetaStore().readUser(SiteConfigurationResourceHandler.getUserName(req));
        JSONObject requestJson = OrionServlet.readJSONRequest((HttpServletRequest)req);
        SiteConfigurationResourceHandler.copyProperties(requestJson, site, true);
        this.changeHostingStatus(req, resp, requestJson, user, site);
        site.save(user);
        URI location = SiteConfigurationResourceHandler.getURI((HttpServletRequest)req);
        URI baseLocation = location.resolve("");
        JSONObject result = SiteConfigurationResourceHandler.toJSON(site, baseLocation);
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.LOCATION_ONLY);
        return true;
    }

    private boolean handleDelete(HttpServletRequest req, HttpServletResponse resp, SiteInfo site) throws CoreException {
        UserInfo user = OrionConfiguration.getMetaStore().readUser(SiteConfigurationResourceHandler.getUserName(req));
        ISiteHostingService hostingService = SiteConfigurationResourceHandler.getHostingService();
        IHostedSite runningSite = hostingService.get(site, user);
        if (runningSite != null) {
            String msg = NLS.bind((String)"Site configuration is running at {0}. Must be stopped before it can be deleted", (Object)runningSite.getHost());
            throw new CoreException((IStatus)new ServerStatus(4, 409, msg, null));
        }
        site.delete(user);
        return true;
    }

    public boolean handleRequest(HttpServletRequest req, HttpServletResponse resp, SiteInfo site) throws ServletException {
        if (site == null && SiteConfigurationResourceHandler.getMethod((HttpServletRequest)req) != ServletResourceHandler.Method.POST) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 404, "Site configuration not found", null));
        }
        try {
            switch (SiteConfigurationResourceHandler.getMethod((HttpServletRequest)req)) {
                case GET: {
                    return this.handleGet(req, resp, site);
                }
                case PUT: {
                    return this.handlePut(req, resp, site);
                }
                case POST: {
                    return this.handlePost(req, resp, site);
                }
                case DELETE: {
                    return this.handleDelete(req, resp, site);
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(req, resp, (Object)e.getStatus());
        }
    }

    private static JSONObject getRequestJson(HttpServletRequest req) throws IOException, JSONException {
        return OrionServlet.readJSONRequest((HttpServletRequest)req);
    }

    private SiteInfo doCreateSiteConfiguration(HttpServletRequest req, JSONObject requestJson, UserInfo user) throws CoreException {
        String name = SiteConfigurationResourceHandler.computeName(req, requestJson);
        String workspace = requestJson.optString("Workspace", null);
        SiteInfo site = SiteConfigurationResourceHandler.createFromJSON(user, name, workspace, requestJson);
        return site;
    }

    private void changeHostingStatus(HttpServletRequest req, HttpServletResponse resp, JSONObject requestJson, UserInfo user, SiteInfo site) throws CoreException {
        JSONObject hostingStatus = requestJson.optJSONObject("HostingStatus");
        if (hostingStatus == null) {
            return;
        }
        String status = hostingStatus.optString("Status");
        try {
            if ("started".equalsIgnoreCase(status)) {
                String editServer = String.valueOf(req.getScheme()) + "://" + req.getHeader("Host");
                SiteConfigurationResourceHandler.getHostingService().start(site, user, editServer, new URI(req.getRequestURL().toString()));
            } else if ("stopped".equalsIgnoreCase(status)) {
                SiteConfigurationResourceHandler.getHostingService().stop(site, user);
            } else if (status != null) {
                throw new CoreException((IStatus)new ServerStatus(4, 400, NLS.bind((String)"Status not understood: {0}", (Object)status), null));
            }
        }
        catch (SiteHostingException e) {
            throw new CoreException((IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CoreException((IStatus)new ServerStatus(4, 400, NLS.bind((String)"Error parsing request URL \"{0}\"", (Object)status), null));
        }
    }

    private static ISiteHostingService getHostingService() throws CoreException {
        SiteHostingService service = HostingActivator.getDefault().getHostingService();
        if (service == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Site hosting service unavailable"));
        }
        return service;
    }

    private static String computeName(HttpServletRequest req, JSONObject requestBody) {
        String name = req.getHeader("Slug");
        if (name == null || name.length() == 0) {
            name = requestBody.optString("Name");
        }
        return name;
    }

    private static String getUserName(HttpServletRequest req) {
        return req.getRemoteUser();
    }
}

