/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.ServerStatus;
import org.json.JSONObject;

public class MultiServerStatus
extends ServerStatus {
    private List<ServerStatus> statuses = new ArrayList<ServerStatus>();

    public MultiServerStatus() {
        super(Status.OK_STATUS, 200);
    }

    public MultiServerStatus(ServerStatus serverStatus) {
        super(Status.OK_STATUS, 200);
        this.add(serverStatus);
    }

    public boolean add(MultiServerStatus status) {
        for (ServerStatus s : status.getStatuses()) {
            if (this.add(s)) continue;
            return false;
        }
        return true;
    }

    public boolean add(ServerStatus status) {
        return this.statuses.add(status);
    }

    public ServerStatus getLastStatus() {
        if (this.statuses.size() < 1) {
            return null;
        }
        return this.statuses.get(this.statuses.size() - 1);
    }

    public List<String> getMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (ServerStatus status : this.statuses) {
            messages.add(status.getMessage());
        }
        return messages;
    }

    public List<ServerStatus> getStatuses() {
        return this.statuses;
    }

    public IStatus[] getChildren() {
        return (IStatus[])this.statuses.toArray();
    }

    public int getCode() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().getCode();
        }
        return super.getCode();
    }

    public Throwable getException() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().getException();
        }
        return super.getException();
    }

    public String getMessage() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().getMessage();
        }
        return super.getMessage();
    }

    public String getPlugin() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().getPlugin();
        }
        return super.getPlugin();
    }

    public int getSeverity() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().getSeverity();
        }
        return super.getSeverity();
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().isOK();
        }
        return super.isOK();
    }

    public boolean matches(int severityMask) {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().matches(severityMask);
        }
        return super.matches(severityMask);
    }

    public JSONObject getJsonData() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().getJsonData();
        }
        return super.getJsonData();
    }

    public JSONObject toJSON() {
        if (!this.statuses.isEmpty()) {
            return this.getLastStatus().toJSON();
        }
        return super.toJSON();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status ");
        int severity = this.getSeverity();
        if (severity == 0) {
            buf.append("OK");
        } else if (severity == 4) {
            buf.append("ERROR");
        } else if (severity == 2) {
            buf.append("WARNING");
        } else if (severity == 1) {
            buf.append("INFO");
        } else if (severity == 8) {
            buf.append("CANCEL");
        } else {
            buf.append("severity=");
            buf.append(severity);
        }
        buf.append(": ");
        buf.append(this.getPlugin());
        buf.append(" code=");
        buf.append(this.getCode());
        buf.append(' ');
        buf.append(this.getMessage());
        buf.append(' ');
        buf.append(this.getException());
        buf.append(" children=[");
        int i = 0;
        while (i < this.statuses.size()) {
            if (i != 0) {
                buf.append(" ");
            }
            buf.append(this.statuses.get(i).toString());
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }
}

