/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.objects;

import ch.qos.logback.classic.Level;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.core.resources.JSONSerializer;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.Serializer;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONObject;

@ResourceDescription(type="Logger")
public class LoggerResource {
    public static final String RESOURCE = "logger";
    public static final String TYPE = "Logger";
    protected static ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected Serializer<JSONObject> jsonSerializer;
    protected URI baseLocation;
    protected String name;
    protected Level level;
    protected Level effectiveLevel;

    public LoggerResource() {
        Property[] defaultProperties = new Property[]{new Property("Name"), new Property("Location"), new Property("Level"), new Property("EffectiveLevel")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.jsonSerializer = new JSONSerializer();
    }

    protected URI createUriWithPath(IPath path) throws URISyntaxException {
        return new URI(this.baseLocation.getScheme(), this.baseLocation.getUserInfo(), this.baseLocation.getHost(), this.baseLocation.getPort(), path.toString(), this.baseLocation.getQuery(), this.baseLocation.getFragment());
    }

    public JSONObject toJSON() throws URISyntaxException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @PropertyDescription(name="Level")
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    @PropertyDescription(name="EffectiveLevel")
    public Level getEffectiveLevel() {
        return this.effectiveLevel;
    }

    public void setEffectiveLevel(Level effectiveLevel) {
        this.effectiveLevel = effectiveLevel;
    }

    public void setBaseLocation(URI baseLocation) {
        this.baseLocation = baseLocation;
    }

    @PropertyDescription(name="Location")
    public URI getLocation() throws URISyntaxException {
        IPath path = new Path("/logapi").append(RESOURCE).append(this.getName());
        return this.createUriWithPath(path);
    }
}

